package com.thebeastshop.pegasus.component.product.warehouse.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.product.warehouse.service.ProductWarehouseService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleSaleInvVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.pegasus.service.purchase.PegasusPurchaseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhRecipeInvVO;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class ProductWarehouseServiceImpl implements ProductWarehouseService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	// 鲜花固定仓
	//private final String FLOWER_WAREHOUSE_CODE = "WH020600020002";
	// 鲜花类目id
	// private final Long FLOWER_CATEGORY_ID = 119L;
	// 永生花SKU编号
	//private final List<String> IMMORTAL_FLOWER_SKU_CODES = Arrays.asList("11012520", "11012521");

	private PegasusWarehouseServiceFacade warehouseService = PegasusWarehouseServiceFacade.getInstance();

	private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();
	
    private PegasusPurchaseServiceFacade phInstance = PegasusPurchaseServiceFacade.getInstance();

	@Autowired
	private McPsSkuService mcPsSkuService;

	// ==============private==============

	/**
	 * 判断是否是鲜花
	 * 
	 * @param sku
	 * @return
	 */
//	private boolean checkIsFlower(PsSkuVO sku) {
//		boolean flag = false;
//		if (sku != null && IMMORTAL_FLOWER_SKU_CODES.contains(sku.getSkuCode())) {
//			flag = true;
//		}
//		return flag;
//	}

	/**
	 * 判断是否为来单制作
	 * 
	 * @param sku
	 * @return
	 */
	private boolean checkIsJIT(PsSkuVO sku) {
		boolean flag = false;
		if (sku != null && sku.getIsJit().equals(1)) {
			flag = true;
		}
		return flag;
	}

	/**
	 * 批量查询来单制作商品库存，并组成map
	 * 
	 * @param skus
	 * @return
	 */
	private Map<PsSkuVO, Integer> mapJITSkuStock(List<PsSkuVO> skus, boolean isCombined,String warehouseCode) {
		// XXX: 组合商品不需要获取来单制作库存
		if (!isCombined) {
			List<String> skuCodes = Lists.newArrayList();
			Map<PsSkuVO, Integer> rt = Maps.newHashMap();
			Map<PsSkuVO, Integer> rtn = Maps.newHashMap();
			if (CollectionUtils.isNotEmpty(skus)) {
				for (PsSkuVO sku : skus) {
					if (sku != null) {
						if (checkIsJIT(sku)) {
							rt.put(sku, Integer.MAX_VALUE);
							
							if(sku.getCanCustomize()!=null && sku.getCanCustomize()==1){
								
								skuCodes.add(sku.getSkuCode());
								
							}
							
						}
					}
				}
			}
			
			// 判断是否有配方定制商品存在
			if (skuCodes.size() > 0 && rt.size() > 0) {
				Map<String, WhRecipeInvVO> whReipeInvVOMaps = phInstance.caculateRecipeAmountForAssemble(skuCodes,
						warehouseCode);

				for (PsSkuVO psSku : rt.keySet()) {
					WhRecipeInvVO whRecipeInvVO = whReipeInvVOMaps.get(psSku.getSkuCode());
					
					if(whRecipeInvVO != null && whRecipeInvVO.isRecipeExist()==true){
						// 设置配方可用库存
						rtn.put(psSku, whRecipeInvVO.getCanUseInv());
					}else{
						rtn.put(psSku, Integer.MAX_VALUE);
					}

				}

				return rtn;
			}
			
			
			return rt;
		}
		return null;
	}

	/**
	 * 批量查询预售库存，并组成map
	 * 
	 * @param skus
	 * @return
	 */
	private Map<PsSkuVO, Integer> mapPresaleSkuStock(List<PsSkuVO> skus, boolean isCombined, boolean isOversea) {
		// XXX: 海淘商品或者组合商品不需要获取预售库存
		if (!isCombined && !isOversea) {
			Map<PsSkuVO, Integer> rt = Maps.newHashMap();
			if (CollectionUtils.isNotEmpty(skus)) {
				Map<String, PsSkuVO> mapSkuCodes = Maps.newHashMap();
				for (PsSkuVO sku : skus) {
					if (sku != null) {
						mapSkuCodes.put(sku.getSkuCode(), sku);
					}
				}
				Integer stock = 0;
				Map<String, OpPresaleSaleInvVO> presaleMap = null;// 预售库存
				if (mapSkuCodes.size() > 0) {
					List<String> presaleSkuCodes = Lists.newArrayList(mapSkuCodes.keySet());
					presaleMap = poInstance.findCanUseQttBySkuCodes(presaleSkuCodes, null);
					for (String code : presaleSkuCodes) {
						OpPresaleSaleInvVO presale = presaleMap != null ? presaleMap.get(code) : null;
						int presaleCount = presale == null ? 0 : presale.getCanUseInv(); // 预售库存数
						stock = presaleCount;

						PsSkuVO sku = mapSkuCodes.get(code);
						rt.put(sku, stock);
					}
				}
			}
			return rt;
		}
		return null;
	}

//	/**
//	 * 批量查询鲜花商品库存，并组成map
//	 * 
//	 * @param skus
//	 * @return
//	 */
//	private Map<PsSkuVO, Integer> mapFlowerSkuStock(List<PsSkuVO> skus, boolean isCombined, boolean isOversea) {
//		Map<PsSkuVO, Integer> rt = Maps.newHashMap();
//		Map<String, PsSkuVO> mapSkuCodes = Maps.newHashMap();
//		for (PsSkuVO sku : skus) {
//			if (sku != null) {
//				if (!checkIsJIT(sku) && checkIsFlower(sku)) {
//					mapSkuCodes.put(sku.getSkuCode(), sku);
//				}
//			}
//		}
//		// 库存的计算方式
//		// 第一步取预售库存数
//		// 第二步取实际库存数
//		// 第三步计算预售库存和实际库存的总和
//		Integer stock = 0;
//		if (mapSkuCodes.keySet().size() > 0) {
//			List<String> skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
//			Map<PsSkuVO, Integer> presaleMap = mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()), isCombined,
//					isOversea);// 预售库存
//			Map<String, WhInvVO> map = warehouseService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes,
//					FLOWER_WAREHOUSE_CODE);
//			for (String code : skuCodes) {
//				PsSkuVO sku = mapSkuCodes.get(code);
//				WhInvVO warehouse = map != null ? map.get(code) : null;
//				int presaleCount = presaleMap != null ? presaleMap.get(sku) : 0; // 预售库存数
//				int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseInv();// 实际库存数
//				stock = presaleCount + warehouseCount;
//				rt.put(sku, stock);
//			}
//		}
//
//		return rt;
//	}

	/**
	 * 批量查询普通商品（非鲜花）库存，并组成map
	 * 
	 * @param skus
	 * @return
	 */
	private Map<PsSkuVO, Integer> mapNormalSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined,
			boolean isOversea) {
		Map<PsSkuVO, Integer> rt = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(skus)) {
			Map<String, PsSkuVO> mapSkuCodes = Maps.newHashMap();
			for (PsSkuVO sku : skus) {
				if (sku != null) {
					//if (!checkIsJIT(sku) && !checkIsFlower(sku)) {
					if (!checkIsJIT(sku)) {
						
						mapSkuCodes.put(sku.getSkuCode(), sku);

					}
				}
			}
			// 库存的计算方式
			// 第一步取预售库存数
			// 第二步取实际库存数
			// 第三步计算预售库存和实际库存的总和
			Integer stock = 0;
			if (mapSkuCodes.keySet().size() > 0) {
				List<String> skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
				Map<PsSkuVO, Integer> presaleMap = mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()),
						isCombined, isOversea);// 预售库存
				Map<String, WhInvVO> map = warehouseService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes,
						warehouseCode);
				for (String code : skuCodes) {
					PsSkuVO sku = mapSkuCodes.get(code);
					WhInvVO warehouse = map != null ? map.get(code) : null;
					int presaleCount = presaleMap != null ? presaleMap.get(sku) : 0;// 预售库存数
					int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseInv();// 实际库存数
					stock = presaleCount + warehouseCount;
					rt.put(sku, stock);
				}
			}
		}
		return rt;
	}

	/**
	 * 批量查询普通商品（非鲜花）库存，并组成map
	 * 
	 * @param skus
	 * @return
	 */
	private Map<PsSkuVO, Integer> mapNormalSkuStockOptimize(List<PsSkuVO> skus, String warehouseCode, boolean isCombined,
			boolean isOversea,Map<String,OpPresaleVO> presaleVOMap,Map<String, WhInvVO> warehouseMap) {
		Map<PsSkuVO, Integer> rt = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(skus)) {
			Map<String, PsSkuVO> mapSkuCodes = Maps.newHashMap();
			for (PsSkuVO sku : skus) {
				if (sku != null) {
					//if (!checkIsJIT(sku) && !checkIsFlower(sku)) {
					if (!checkIsJIT(sku)) {
						// 判断是否有抢购活动
//						if(CollectionUtils.isNotEmpty(sku.getCampaignList())){
//							
//							boolean bool = true;
//							
//							for(PsCampaignVO psCampaignVO:sku.getCampaignList()){
//								
//								// 抢购活动
//								if(psCampaignVO.getDiscountTypeId() == 6){
//									rt.put(sku, Integer.MAX_VALUE);
//									bool = false;
//									break;
//								}
//								
//							}
//							// 没有抢购活动，需要验证库存
//							if(bool){
//								mapSkuCodes.put(sku.getSkuCode(), sku);
//							}
//
//						}else{
							mapSkuCodes.put(sku.getSkuCode(), sku);
					//	}

					}else{
						rt.put(sku, Integer.MAX_VALUE);
					}
				}
			}
			// 库存的计算方式
			// 第一步取预售库存数
			// 第二步取实际库存数
			// 第三步计算预售库存和实际库存的总和
			Integer stock = 0;
			if (mapSkuCodes.keySet().size() > 0) {
				List<String> skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
				//Map<PsSkuVO, Integer> presaleMap = mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()),
						//isCombined, isOversea);// 预售库存
				//Map<String, WhInvVO> map = warehouseService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes,
					//	warehouseCode);
				for (String code : skuCodes) {
					PsSkuVO sku = mapSkuCodes.get(code);
					
					// 如果是预售商品暂时将库存设为最大
					if(presaleVOMap!=null && presaleVOMap.get(code)!=null){
						stock = Integer.MAX_VALUE;
					}else{
						WhInvVO warehouse = warehouseMap != null ? warehouseMap.get(code) : null;

						int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseInv();// 实际库存数
						stock = warehouseCount;
					}
			
					rt.put(sku, stock);
				}
			}
		}
		return rt;
	}
	/**
	 * 批量查询sku库存，并组成map
	 * 
	 * @param skus
	 * @param warehouseCode
	 * @return
	 */
	private Map<PsSkuVO, Integer> mapSkuStockOptimize(List<PsSkuVO> skus, String warehouseCode, boolean isCombined,
			boolean isOversea,Map<String,OpPresaleVO> presaleVOMap,Map<String, WhInvVO> warehouseMap) {
		Map<PsSkuVO, Integer> rt = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(skus)) {
			//Map<PsSkuVO, Integer> mapJITSkuStock = mapJITSkuStock(skus, isCombined);
			//if (mapJITSkuStock != null) {
				//rt.putAll(mapJITSkuStock);
			//}
//			Map<PsSkuVO, Integer> mapFlowerSkuStock = mapFlowerSkuStock(skus, isCombined, isOversea);
//			if (mapFlowerSkuStock != null) {
//				rt.putAll(mapFlowerSkuStock);
//			}
			Map<PsSkuVO, Integer> mapNormalSkuStock = mapNormalSkuStockOptimize(skus, warehouseCode, isCombined, isOversea,presaleVOMap,warehouseMap);
			if (mapNormalSkuStock != null) {
				rt.putAll(mapNormalSkuStock);
			}
		}
		return rt;
	}
	
	 /* 批量查询sku库存，并组成map
	 * 
	 * @param skus
	 * @param warehouseCode
	 * @return
	 */
	@Deprecated
	private Map<PsSkuVO, Integer> mapSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined,
			boolean isOversea) {
		Map<PsSkuVO, Integer> rt = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(skus)) {
			Map<PsSkuVO, Integer> mapJITSkuStock = mapJITSkuStock(skus, isCombined,warehouseCode);
			if (mapJITSkuStock != null) {
				rt.putAll(mapJITSkuStock);
			}
//			Map<PsSkuVO, Integer> mapFlowerSkuStock = mapFlowerSkuStock(skus, isCombined, isOversea);
//			if (mapFlowerSkuStock != null) {
//				rt.putAll(mapFlowerSkuStock);
//			}
			Map<PsSkuVO, Integer> mapNormalSkuStock = mapNormalSkuStock(skus, warehouseCode, isCombined, isOversea);
			if (mapNormalSkuStock != null) {
				rt.putAll(mapNormalSkuStock);
			}
		}
		return rt;
	}

	// ==================华丽丽的分割线===================

	@Override
	public boolean isSellout(PsSpvVO spv, String warehouseCode) {
		if (spv != null) {
			Integer stock = getSpvStock(spv, warehouseCode);
			Integer minAmount = spv.getMinAmount() != null && spv.getMinAmount() != 0 ? spv.getMinAmount() : 1;
			if (stock != null && (stock <= 0 || stock / minAmount <= 0)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public Integer getSpvStock(PsSpvVO spv, String warehouseCode) {
		Date start = new Date();
		// spv库存数量
		Integer stock = null;
		List<String> codes = Lists.newArrayList();
		Map<String, Integer> skuQuantityMap = Maps.newHashMap();// spv中sku绑定数
		boolean isCombined = false;
		boolean isOversea = false;
		if (spv.getCombined()) {
			isCombined = true;
			List<PsSkuCombinationVO> skuComns = spv.getSkuCombinationList();
			if (CollectionUtils.isNotEmpty(skuComns)) {
				for (PsSkuCombinationVO skuComn : skuComns) {
					codes.add(skuComn.getSubSkuCode());
					skuQuantityMap.put(skuComn.getSubSkuCode(), skuComn.getQuantity());
				}
			}
		} else {
			isCombined = false;
			codes.add(spv.getSkuCode());
		}
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);
		// 判断是否是海淘商品（spv）
		for (PsSkuVO sku : skus) {
			if (sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
				isOversea = true;
				break;
			}
		}
		Map<PsSkuVO, Integer> mapSkuStock = mapSkuStock(skus, warehouseCode, isCombined, isOversea);
		if (mapSkuStock != null && mapSkuStock.size() > 0) {
			for (Entry<PsSkuVO, Integer> e : mapSkuStock.entrySet()) {
				Integer tempStock = e.getValue();
				if (tempStock == null || tempStock < 0) {
					tempStock = 0;
				}
				Integer quantity = skuQuantityMap.get(e.getKey().getSkuCode());
				if (quantity != null && !quantity.equals(0)) {
					tempStock = tempStock / quantity;
				}
				if (stock != null) {
					if (stock > tempStock) {
						stock = tempStock;
					}
				} else {
					stock = tempStock;
				}
			}
		}
		Date end = new Date();
		logger.info("方法getSpvStock花费时间：{}毫秒", end.getTime() - start.getTime());
		return stock != null ? stock : 0;
	}

	@Override
	public Map<PsSpvVO, Boolean> mapSpvsIsSellout(Collection<PsSpvVO> spvs, String warehouseCode) {
		Map<PsSpvVO, Boolean> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			for (PsSpvVO spv : spvs) {
				map.put(spv, isSellout(spv, warehouseCode));
			}
		}
		return map;
	}

	@Override
	public Map<PsSpvVO, Integer> mapSpvsStock(Collection<PsSpvVO> spvs, String warehouseCode) {
		Map<PsSpvVO, Integer> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			for (PsSpvVO spv : spvs) {
				map.put(spv, getSpvStock(spv, warehouseCode));
			}
		}
		return map;
	}

	@Override
	public Map<PsSpvVO, Integer> mapSpvsStockOptimize(Collection<PsSpvVO> spvs, String warehouseCode, Map<String, PsSkuVO> psSkuVOMap, Map<String,OpPresaleVO> presaleVOMap,Map<String, WhInvVO> warehouseMap) {
		Map<PsSpvVO, Integer> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			for (PsSpvVO spv : spvs) {
				map.put(spv, getSpvStockOptimize(spv, warehouseCode, psSkuVOMap,presaleVOMap,warehouseMap));
			}
		}
		return map;
	}

	/**
	 * 曾对getSpvStock的优化
	 * @param spv
	 * @param warehouseCode
	 * @param psSkuVOMap
	 * @return
	 */
	private Integer getSpvStockOptimize(PsSpvVO spv, String warehouseCode,Map<String, PsSkuVO> psSkuVOMap,Map<String,OpPresaleVO> presaleVOMap,Map<String, WhInvVO> warehouseMap) {
		Date start = new Date();
		// spv库存数量
		Integer stock = null;
		List<String> codes = Lists.newArrayList();
		Map<String, Integer> skuQuantityMap = Maps.newHashMap();// spv中sku绑定数
		boolean isCombined = false;
		boolean isOversea = false;
		if (spv.getCombined()) {
			isCombined = true;
			List<PsSkuCombinationVO> skuComns = spv.getSkuCombinationList();
			if (CollectionUtils.isNotEmpty(skuComns)) {
				for (PsSkuCombinationVO skuComn : skuComns) {
					codes.add(skuComn.getSubSkuCode());
					skuQuantityMap.put(skuComn.getSubSkuCode(), skuComn.getQuantity());
				}
			}
		} else {
			isCombined = false;
			codes.add(spv.getSkuCode());
		}
		List<PsSkuVO> skus = getPsSkuVOByMap(codes,psSkuVOMap);
				//mcPsSkuService.findBySkuCodes(codes);
		// 判断是否是海淘商品（spv）
		for (PsSkuVO sku : skus) {
			if (sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
				isOversea = true;
				break;
			}
		}
		Map<PsSkuVO, Integer> mapSkuStock = mapSkuStockOptimize(skus, warehouseCode, isCombined, isOversea,presaleVOMap,warehouseMap);
		//Map<PsSkuVO, Integer> mapSkuStock = mapSkuStock(skus, warehouseCode, isCombined, isOversea);
		if (mapSkuStock != null && mapSkuStock.size() > 0) {
			for (Entry<PsSkuVO, Integer> e : mapSkuStock.entrySet()) {
				Integer tempStock = e.getValue();
				if (tempStock == null || tempStock < 0) {
					tempStock = 0;
				}
				Integer quantity = skuQuantityMap.get(e.getKey().getSkuCode());
				if (quantity != null && !quantity.equals(0)) {
					tempStock = tempStock / quantity;
				}
				if (stock != null) {
					if (stock > tempStock) {
						stock = tempStock;
					}
				} else {
					stock = tempStock;
				}
			}
		}
		Date end = new Date();
		logger.info("方法getSpvStock花费时间：{}毫秒", end.getTime() - start.getTime());
		return stock != null ? stock : 0;
	}

	/**
	 * 给 getSpvStockOptimize 次方法用的
	 * @param codes
	 * @param psSkuVOMap
	 * @return
	 */
	private List<PsSkuVO> getPsSkuVOByMap(List<String> codes ,Map<String, PsSkuVO> psSkuVOMap){
		List<PsSkuVO> ps = new ArrayList<>();
		for(String code : codes){
			PsSkuVO psSkuVO = psSkuVOMap.get(code);
			if(null != psSkuVO){
				ps.add(psSkuVO);
			}else{
				logger.error("getPsSkuVOByMap skucode 异常");
			}
		}
		return ps;
	}

}
