package com.thebeastshop.pegasus.component.product.warehouse.service;

import java.util.Collection;
import java.util.Map;

import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;

/**
 * 商品-仓库关系。
 * 
 * @author Paul-xiong
 *
 */
public interface ProductWarehouseService {

	boolean isSellout(final PsSpvVO spv, String warehouseCode);

	Map<PsSpvVO, Boolean> mapSpvsIsSellout(final Collection<PsSpvVO> spvs, String warehouseCode);

	/**
	 * 查询spv库存数量
	 * 
	 * @author jim.huang
	 * @date 2016年7月23日
	 * @param spv
	 * @param warehouseCode
	 * @return
	 */
	public Integer getSpvStock(PsSpvVO spv, String warehouseCode);

	/**
	 * 批量查询spv库存数量,并组成map
	 * 
	 * @param spvs
	 * @param warehouseCode
	 * @return
	 */
	public Map<PsSpvVO, Integer> mapSpvsStock(Collection<PsSpvVO> spvs, String warehouseCode);

	/**
	 * 批量查询spv库存数量,并组成map
	 * 这是优化接口  不走for 查询
	 * @param spvs
	 * @param warehouseCode
	 * @param psSkuVOMap sku 的map 针对spvs的 优化
	 * @return
	 */
	public Map<PsSpvVO, Integer> mapSpvsStockOptimize(Collection<PsSpvVO> spvs, String warehouseCode,Map<String,PsSkuVO> psSkuVOMap,Map<String,OpPresaleVO> presaleVOMap,Map<String, WhInvVO> warehouseMap);

}
