package com.thebeastshop.pegasus.component.discount;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * @author Liang Wenjian
 */
public enum PriceOperationType implements HasIntIdGetter, HasName {
    /**
     * 绝对值
     */
    ABSOLUTE_VALUE(1, "绝对值"),
    /**
     * 百分比
     */
    PERCENT(2, "百分比");

    public final Integer id;
    public final String name;

    PriceOperationType(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
