package com.thebeastshop.pegasus.component.delivery.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 配送信息
 * 
 * @author Paul-xiong
 *
 */
public class Deliverable {
	/**
	 * 是否支持配送（0表示不可配送，1表示可配送，2表示不提示）
	 */
	private int result;
	/**
	 * 城市的名称
	 */
	private String cityName;
	/**
	 * 邮费
	 */
	private BigDecimal postFee;
	/**
	 * 限时邮费
	 */
	private BigDecimal extraPostFee;
	/**
	 * 时间
	 */
	private List<DeliverableDate> deliverableDates = new ArrayList<>();

	public int isResult() {
		return result;
	}

	public void setResult(int result) {
		this.result = result;
	}

	public List<DeliverableDate> getDeliverableDates() {
		return deliverableDates;
	}

	public void setDeliverableDates(List<DeliverableDate> deliverableDates) {
		this.deliverableDates = deliverableDates;
	}

	public String getCityName() {
		return cityName;
	}

	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	public BigDecimal getPostFee() {
		return postFee;
	}

	public void setPostFee(BigDecimal postFee) {
		this.postFee = postFee;
	}

	public List<DeliverableDate> getDeliverableDateVOs() {
		return deliverableDates;
	}

	public void setDeliverableDateVOs(List<DeliverableDate> deliverableDateVOs) {
		this.deliverableDates = deliverableDateVOs;
	}

	public BigDecimal getExtraPostFee() {
		return extraPostFee;
	}

	public void setExtraPostFee(BigDecimal extraPostFee) {
		this.extraPostFee = extraPostFee;
	}

	@Override
	public String toString() {
		return "DeliverableInfo [result=" + result + ", cityName=" + cityName + ", postFee=" + postFee
				+ ", deliverableDates=" + deliverableDates + "]";
	}

}
