package com.thebeastshop.pegasus.component.compatible.service.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.compatible.domain.Ring;
import com.thebeastshop.pegasus.component.compatible.old.ResponseVO;
import com.thebeastshop.pegasus.component.compatible.old.RingConstant;
import com.thebeastshop.pegasus.component.compatible.old.RingDTO;
import com.thebeastshop.pegasus.component.compatible.service.RingService;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class RingServiceImpl implements RingService {
	protected Logger logger = LoggerFactory.getLogger(getClass());

	public RingServiceImpl() {
		super();
	}

	// ===========private===========
	private List<Ring> _callOldGetRings(Long districtId) {
		List<Ring> rt = null;
		try {
			String url = RingConstant.GET_RING;
			RingDTO ringDTO = new RingDTO();
			ringDTO.setId(districtId);
			String ringStr = JSON.toJSONString(ringDTO);
			logger.info("接口名={}", url);
			logger.info("发送的参数 ringDTO={}", ringDTO);
			Date start = new Date();
			String resultStr = HttpUtil.doJsonPost(url, ringStr, RingConstant.CHART_SET);
			Date end = new Date();
			logger.info("请求官方服务器查询环线列表的访问时间：{}毫秒", end.getTime() - start.getTime());
			logger.info("返回的参数 resultStr={}", resultStr);
			if (StringUtils.isNotBlank(resultStr)) {
				ResponseVO responseVO = JsonUtil.alibabaToObject(resultStr, ResponseVO.class);
				if (null != responseVO && responseVO.getMeta().getErrno() == 0) {
					rt = JsonUtil.alibabaToList(responseVO.getResult().getData().toString(), Ring.class);
				}
			}
		} catch (Exception e) {
			logger.error("获取环线信息异常:{}", e);
		}
		return rt;
	}

	private Ring _callOldGetRingDetail(Long id) {
		Ring rt = null;
		try {
			String url = RingConstant.GET_RING_DETAIL;
			RingDTO ringDTO = new RingDTO();
			ringDTO.setId(id);
			String ringStr = JSON.toJSONString(ringDTO);
			logger.info("接口名={}", url);
			logger.info("发送的参数 ringDTO={}", ringDTO);
			Date start = new Date();
			String resultStr = HttpUtil.doJsonPost(url, ringStr, RingConstant.CHART_SET);
			Date end = new Date();
			logger.info("请求官方服务器查询环线详情的访问时间：{}毫秒", end.getTime() - start.getTime());
			logger.info("返回的参数 resultStr={}", resultStr);
			if (StringUtils.isNotBlank(resultStr)) {
				ResponseVO responseVO = JsonUtil.alibabaToObject(resultStr, ResponseVO.class);
				if (null != responseVO && responseVO.getMeta().getErrno() == 0) {
					rt = JsonUtil.alibabaToObject(responseVO.getResult().getData().toString(), Ring.class);
				}
			}
		} catch (Exception e) {
			logger.error("获取环线信息异常:{}", e);
		}
		return rt;
	}

	@Override
	public Ring getById(long id) {
		return _callOldGetRingDetail(id);
	}

	@Override
	public List<Ring> list(long districtId) {
		return _callOldGetRings(districtId);
	}

	// ===========================

}
