package com.thebeastshop.pegasus.component.compatible.service.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.compatible.old.DeliverableConstant;
import com.thebeastshop.pegasus.component.compatible.old.DeliverableDateDTO;
import com.thebeastshop.pegasus.component.compatible.old.ResponseVO;
import com.thebeastshop.pegasus.component.compatible.service.OldDeliverableService;
import com.thebeastshop.pegasus.component.delivery.domain.Deliverable;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class OldDeliverableServiceImpl implements OldDeliverableService {
	private final static Logger logger = LoggerFactory.getLogger(OldDeliverableServiceImpl.class);

	// ============private==============

	private Deliverable _callOldGetDeliverable(Long addressId, List<PsSkuVO> skus) {
		Deliverable deliverableInfo = null;
		if (addressId != null && CollectionUtils.isNotEmpty(skus)) {
			try {
				String url = DeliverableConstant.GET_ALL_ADDRESSVO;
				DeliverableDateDTO deliverableDateDTO = new DeliverableDateDTO();
				deliverableDateDTO.setAddress(addressId);
				List<String> skuCodes = Lists.newArrayList();
				for (PsSkuVO sku : skus) {
					skuCodes.add(sku.getSkuCode());
				}
				deliverableDateDTO.setSkuIds(skuCodes);
				String dddressStr = JSON.toJSONString(deliverableDateDTO);
				logger.info("接口名={}", url);
				logger.info("发送的参数 orderAddressStr={}", dddressStr);
				Date start = new Date();
				String resultStr = HttpUtil.doJsonPost(url, dddressStr,
						DeliverableConstant.CHART_SET);
				Date end = new Date();
				logger.info("请求官方服务器获查询配送信息的访问时间：{}毫秒", end.getTime() - start.getTime());
				logger.info("接受的参数 resultStr={}", resultStr);
				if (StringUtils.isNotBlank(resultStr)) {
					ResponseVO responseVO = JsonUtil.alibabaToObject(resultStr, ResponseVO.class);
					if (null != responseVO && responseVO.getMeta().getErrno() == 0) {
						deliverableInfo = JsonUtil.alibabaToObject(responseVO.getResult().getData().toString(),
								Deliverable.class);
					}
				}
			} catch (Exception e) {
				logger.error("获取可以用的时间 异常:{}", e);
			}
		}
		return deliverableInfo;
	}

	// ============华丽丽的分割线==========

	@Override
	public Deliverable getDeliverable(Long addressId, List<PsSkuVO> skus) {
		logger.info("====查询配送信息 参数 address={}, skus={}", addressId, skus);
		Deliverable deliverableInfo = _callOldGetDeliverable(addressId, skus);
		logger.info("====查询配送信息 返回值 deliverableDateVOs={}", deliverableInfo);
		return deliverableInfo;
	}

}
