package com.thebeastshop.pegasus.component.category.dao;

import java.util.List;

import com.thebeastshop.pegasus.component.category.CategoryFront;

public interface CategoryFrontDao {
	/**
	 * 获取前端显示一级类目
	 */
	public List<CategoryFront> getFirstCategory();

	/**
	 * 获取分类列表。
	 *
	 * @return
	 */
	public List<CategoryFront> getCategoriesByParentId(Integer parentId);

	/**
	 * 通过id 查询对象
	 */
	public List<CategoryFront> getCategoryFrontisById(List<Long> ids);

	/**
	 * 得到所有叶子结点的ids
	 * 
	 * @param categoryCodes
	 * @return
	 */
	public List<CategoryFront> getLeftCategorIdsByCodes(List<String> categoryCodes);

	/**
	 * 通过code 查询 下一级目录
	 * 
	 * @param categoryCodes
	 * @return
	 */
	public List<String> getCategoryCodeBycode(List<String> categoryCodes);

	/**
	 * 获取所有子类目
	 * 
	 * @author WangYawei
	 * @date 2017-5-12
	 * @return
	 */
	public List<Long> getAllCategories();

}
