package com.thebeastshop.pegasus.component.campaign.support;

import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;

import java.math.BigDecimal;

/**
 * @author Liang Wenjian
 */
public class DefaultCampaignSectionProductImpl implements CampaignSectionProduct {
	private Long id;							//记录编号
	private Long campaignId;					//活动编号
	private Long campaignSectionId;				//活动关联的优惠区间编号
	private Long additionalProductId;			//活动关联的额外商品编号
	private int additionalProductCount;			//额外商品数量
	private BigDecimal additionalProductPrice;	//额外商品的价格
	private double ranking;						//排序
	private Integer temp;						//是否为临时记录
	private String productCode;					//额外商品编码
	private Integer limitCount = 1;				//额外商品数量，赠品数量或 换购商品最大换购数量

	@Override
	public String getProductCode() {
		return productCode;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getCampaignId() {
		return campaignId;
	}

	public void setCampaignId(Long campaignId) {
		this.campaignId = campaignId;
	}

	public void setCampaignSectionId(final Long campaignSectionId) {
		this.campaignSectionId = campaignSectionId;
	}

	@Override
	public double getRanking() {
		return ranking;
	}

	public void setRanking(final double ranking) {
		this.ranking = ranking;
	}

	@Override
	public Integer getTemp() {
		return temp;
	}

	public void setTemp(Integer temp) {
		this.temp = temp;
	}

	@Override
	public Long getAdditionalProductId() {
		return additionalProductId;
	}

	public void setAdditionalProductId(final Long additionalProductId) {
		this.additionalProductId = additionalProductId;
	}

	@Override
	public int getAdditionalProductCount() {
		return additionalProductCount;
	}

	public void setAdditionalProductCount(final int additionalProductCount) {
		this.additionalProductCount = additionalProductCount;
	}

	@Override
	public BigDecimal getAdditionalProductPrice() {
		return additionalProductPrice;
	}

	public void setAdditionalProductPrice(final BigDecimal additionalProductPrice) {
		this.additionalProductPrice = additionalProductPrice;
	}

	@Override
	public Integer getLimitCount(){
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	@Override
	public boolean equals(Object obj) {
		if(this == obj) {
			return true;
		}
		if(!(obj instanceof DefaultCampaignSectionProductImpl)) {
			return false;
		}
		DefaultCampaignSectionProductImpl that = (DefaultCampaignSectionProductImpl)obj;
		return this.additionalProductId.equals(that.getAdditionalProductId())
				&& this.additionalProductCount == that.getAdditionalProductCount()
				&& this.additionalProductPrice.compareTo(that.getAdditionalProductPrice()) == 0;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("DefaultCampaignSectionProductImpl{");
		sb.append("id=").append(id);
		sb.append(", campaignId=").append(campaignId);
		sb.append(", campaignSectionId=").append(campaignSectionId);
		sb.append(", additionalProductId=").append(additionalProductId);
		sb.append(", additionalProductCount=").append(additionalProductCount);
		sb.append(", additionalProductPrice=").append(additionalProductPrice);
		sb.append(", ranking=").append(ranking);
		sb.append(", temp=").append(temp);
		sb.append(", productCode='").append(productCode).append('\'');
		sb.append(", limitCount=").append(limitCount);
		sb.append('}');
		return sb.toString();
	}
}
