package com.thebeastshop.pegasus.component.announcement.support;

import com.thebeastshop.pegasus.component.announcement.Announcement;

import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class DefaultAnnouncementImpl implements Announcement {

    private String title;
    private String link;

    public DefaultAnnouncementImpl() {
        super();
    }

    public DefaultAnnouncementImpl(final String title, final String link) {
        this.title = title;
        this.link = link;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    @Override
    public String getLink() {
        return link;
    }

    public void setLink(final String link) {
        this.link = link;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Announcement)) {
            return false;
        }
        final Announcement that = (Announcement) o;
        return Objects.equals(getTitle(), that.getTitle()) && Objects.equals(getLink(), that.getLink());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTitle(), getLink());
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                "title:'" + title + '\'' +
                ", link:'" + link + '\'' +
                '}';
    }
}
