package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.adaptor.sns.config.QQConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.QQUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.QQService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

@Service
public class QQServiceImpl implements QQService {

	private static final String CHARSET = "UTF-8";

	@Override
	public QQUserInfo getSimpleUserInfo(String accessToken, String openId, String platform) {
		QQUserInfo userInfo = null;

		// qq api接口
		StringBuilder url = new StringBuilder(QQConfig.getSimpleUserInfoUrl());
		// app id
		String appId = "";

		if (platform == null) {
			throw new WrongArgException("平台参数不正确");
		} else if (platform.toLowerCase().contains("ios")) {
			appId = QQConfig.getAppIdForIOS();
		} else if (platform.toLowerCase().contains("android")) {
			appId = QQConfig.getAppIdForAndroid();
		} else {
			throw new WrongArgException("平台参数不正确");
		}

		// 请求参数
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("access_token", accessToken);
		params.put("oauth_consumer_key", appId);
		params.put("openid", openId);

		try {
			// 调用请求
			String dataStr = HttpUtil.doGet(url.toString(), params, CHARSET);
			userInfo = JsonUtil.toObject(dataStr, QQUserInfo.class);
		} catch (Exception e) {
			throw new UnknownError(e.getMessage());
		}

		return userInfo;
	}

	// test
//	public static void main(String[] args) {
//		QQService service = new QQServiceImpl();
//		String accessToken = "9F04FD2E3FF9DDC7A5627DBADA2F0534";
//		String openId = "F38A27071A2D5743C175E60D02197029";
//		service.getSimpleUserInfo(accessToken, openId, "ios");
//	}

}
