package com.thebeastshop.pegasus.component.adaptor.sns.service;

import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXUserInfo;

/**
 * 微信第三方服务
 * 
 * @author Paul-xiong
 *
 */
public interface WeiXinService {

	/**
	 * 通过code获取access_token
	 * 
	 * @param code
	 *            前一步获取的code
	 * @return
	 */
	public WXAccessToken getAccessToken(String code);

	/**
	 * 获取用户个人信息
	 * 
	 * @param accessToken
	 *            调用凭证
	 * @param openId
	 *            普通用户的标识
	 * @return
	 */
	public WXUserInfo getUserInfo(String accessToken, String openId);

	/**
	 * 获取微信公众号js config
	 * 
	 * @param url
	 *            当前网页的URL
	 * @return
	 */
	public WXJsConfig getJsConfig(String url,String accessToken);
	/**
	 * 取得token
	 * @return String
	 */
	//public String takeToken();
}
