package com.thebeastshop.pegasus.component.adaptor.sns.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 微博用户信息
 * 
 * @author Paul-xiong
 *
 */
public class WBUserInfo {
	/**
	 * 用户UID
	 */
	private String id;
	/**
	 * 字符串型的用户UID
	 */
	private String idstr;
	/**
	 * 用户昵称
	 */
	private String screen_name;
	/**
	 * 友好显示名称
	 */
	private String name;
	/**
	 * 用户所在省级ID
	 */
	private String province;
	/**
	 * 用户所在城市ID
	 */
	private String city;
	/**
	 * 用户所在地
	 */
	private String location;
	/**
	 * 用户个人描述
	 */
	private String description;
	/**
	 * 用户博客地址
	 */
	private String url;
	/**
	 * 用户头像地址（中图），50×50像素
	 */
	private String profile_image_url;
	/**
	 * 用户的微博统一URL地址
	 */
	private String profile_url;
	/**
	 * 用户的个性化域名
	 */
	private String domain;
	/**
	 * 用户的微号
	 */
	private String weihao;
	/**
	 * 性别，m：男、f：女、n：未知
	 */
	private String gender;
	/**
	 * 粉丝数
	 */
	private String followers_count;
	/**
	 * 关注数
	 */
	private String friends_count;
	/**
	 * 微博数
	 */
	private String statuses_count;
	/**
	 * 收藏数
	 */
	private String favourites_count;
	/**
	 * 用户创建（注册）时间
	 */
	private String created_at;
	/**
	 * 暂未支持
	 */
	private String following;
	/**
	 * 是否允许所有人给我发私信，true：是，false：否
	 */
	private String allow_all_act_msg;
	/**
	 * 是否允许标识用户的地理位置，true：是，false：否
	 */
	private String geo_enabled;
	/**
	 * 是否是微博认证用户，即加V用户，true：是，false：否
	 */
	private String verified;
	/**
	 * 暂未支持
	 */
	private String verified_type;
	/**
	 * 用户备注信息，只有在查询用户关系时才返回此字段
	 */
	private String remark;
	/**
	 * 用户的最近一条微博信息字段
	 */
	@JsonIgnore
	private String status;
	/**
	 * 是否允许所有人对我的微博进行评论，true：是，false：否
	 */
	private String allow_all_comment;
	/**
	 * 用户头像地址（大图），180×180像素
	 */
	private String avatar_large;
	/**
	 * 用户头像地址（高清），高清头像原图
	 */
	private String avatar_hd;
	/**
	 * 认证原因
	 */
	private String verified_reason;
	/**
	 * 该用户是否关注当前登录用户，true：是，false：否
	 */
	private String follow_me;
	/**
	 * 用户的在线状态，0：不在线、1：在线
	 */
	private String online_status;
	/**
	 * 用户的互粉数
	 */
	private String bi_followers_count;
	/**
	 * 用户当前的语言版本，zh-cn：简体中文，zh-tw：繁体中文，en：英语
	 */
	private String lang;

	@Override
	public String toString() {
		return "WBUserInfo [id=" + id + ", idstr=" + idstr + ", screen_name=" + screen_name + ", name=" + name
				+ ", province=" + province + ", city=" + city + ", location=" + location + ", description="
				+ description + ", url=" + url + ", profile_image_url=" + profile_image_url + ", profile_url="
				+ profile_url + ", domain=" + domain + ", weihao=" + weihao + ", gender=" + gender
				+ ", followers_count=" + followers_count + ", friends_count=" + friends_count + ", statuses_count="
				+ statuses_count + ", favourites_count=" + favourites_count + ", created_at=" + created_at
				+ ", following=" + following + ", allow_all_act_msg=" + allow_all_act_msg + ", geo_enabled="
				+ geo_enabled + ", verified=" + verified + ", verified_type=" + verified_type + ", remark=" + remark
				+ ", status=" + status + ", allow_all_comment=" + allow_all_comment + ", avatar_large=" + avatar_large
				+ ", avatar_hd=" + avatar_hd + ", verified_reason=" + verified_reason + ", follow_me=" + follow_me
				+ ", online_status=" + online_status + ", bi_followers_count=" + bi_followers_count + ", lang=" + lang
				+ "]";
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIdstr() {
		return idstr;
	}

	public void setIdstr(String idstr) {
		this.idstr = idstr;
	}

	public String getScreen_name() {
		return screen_name;
	}

	public void setScreen_name(String screen_name) {
		this.screen_name = screen_name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getProfile_image_url() {
		return profile_image_url;
	}

	public void setProfile_image_url(String profile_image_url) {
		this.profile_image_url = profile_image_url;
	}

	public String getProfile_url() {
		return profile_url;
	}

	public void setProfile_url(String profile_url) {
		this.profile_url = profile_url;
	}

	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

	public String getWeihao() {
		return weihao;
	}

	public void setWeihao(String weihao) {
		this.weihao = weihao;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getFollowers_count() {
		return followers_count;
	}

	public void setFollowers_count(String followers_count) {
		this.followers_count = followers_count;
	}

	public String getFriends_count() {
		return friends_count;
	}

	public void setFriends_count(String friends_count) {
		this.friends_count = friends_count;
	}

	public String getStatuses_count() {
		return statuses_count;
	}

	public void setStatuses_count(String statuses_count) {
		this.statuses_count = statuses_count;
	}

	public String getFavourites_count() {
		return favourites_count;
	}

	public void setFavourites_count(String favourites_count) {
		this.favourites_count = favourites_count;
	}

	public String getCreated_at() {
		return created_at;
	}

	public void setCreated_at(String created_at) {
		this.created_at = created_at;
	}

	public String getFollowing() {
		return following;
	}

	public void setFollowing(String following) {
		this.following = following;
	}

	public String getAllow_all_act_msg() {
		return allow_all_act_msg;
	}

	public void setAllow_all_act_msg(String allow_all_act_msg) {
		this.allow_all_act_msg = allow_all_act_msg;
	}

	public String getGeo_enabled() {
		return geo_enabled;
	}

	public void setGeo_enabled(String geo_enabled) {
		this.geo_enabled = geo_enabled;
	}

	public String getVerified() {
		return verified;
	}

	public void setVerified(String verified) {
		this.verified = verified;
	}

	public String getVerified_type() {
		return verified_type;
	}

	public void setVerified_type(String verified_type) {
		this.verified_type = verified_type;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getAllow_all_comment() {
		return allow_all_comment;
	}

	public void setAllow_all_comment(String allow_all_comment) {
		this.allow_all_comment = allow_all_comment;
	}

	public String getAvatar_large() {
		return avatar_large;
	}

	public void setAvatar_large(String avatar_large) {
		this.avatar_large = avatar_large;
	}

	public String getAvatar_hd() {
		return avatar_hd;
	}

	public void setAvatar_hd(String avatar_hd) {
		this.avatar_hd = avatar_hd;
	}

	public String getVerified_reason() {
		return verified_reason;
	}

	public void setVerified_reason(String verified_reason) {
		this.verified_reason = verified_reason;
	}

	public String getFollow_me() {
		return follow_me;
	}

	public void setFollow_me(String follow_me) {
		this.follow_me = follow_me;
	}

	public String getOnline_status() {
		return online_status;
	}

	public void setOnline_status(String online_status) {
		this.online_status = online_status;
	}

	public String getBi_followers_count() {
		return bi_followers_count;
	}

	public void setBi_followers_count(String bi_followers_count) {
		this.bi_followers_count = bi_followers_count;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}

}
