package com.thebeastshop.pegasus.component.adaptor.sns.config;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;

/**
 * QQ配置信息
 * 
 * @author Paul-xiong
 *
 */
public class WeiXinConfig {

	/**
	 * app客户端获取access_token的接口
	 */
	public static String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";

	/**
	 * js sdk获取access_token的接口
	 */
	public static String JS_SDK_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token";

	/**
	 * js sdk获取jsapi_ticket的接口
	 */
	public static String JS_SDK_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";

	/**
	 * 获取用户个人信息（UnionID机制）的接口
	 */
	public static String USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo";

	/**
	 * appid
	 */
	public static String APP_ID = "wx29e84033eae3cd0f";
	/**
	 * 公众号appid
	 */
	public static String APP_ID2 = "wxbce29784bdd01454";

	/**
	 * secret
	 */
	public static String SECRET = "6b7d1883df4e779eb077245c59b4041e";
	/**
	 * 公众号secret
	 */
	//public static String SECRET2 = "0ffa10d458545e7d4fdd1e5ebcc8dbd5";

	static {
		PropertyConfigurer configurer = ComponentServiceLoader.getBean(PropertyConfigurer.class);
		if (configurer != null) {
			String appId = configurer.getProperty("weixin.appId");
			if (StringUtils.isNotBlank(appId)) {
				APP_ID = appId;
			}
			String secret = configurer.getProperty("weixin.secret");
			if (StringUtils.isNotBlank(secret)) {
				SECRET = secret;
			}
			String appId2 = configurer.getProperty("weixin.appId2");
			if (StringUtils.isNotBlank(appId2)) {
				APP_ID2 = appId2;
			}
//			String secret2 = configurer.getProperty("weixin.secret2");
//			if (StringUtils.isNotBlank(secret2)) {
//				SECRET2 = secret2;
//			}
		}
	}

}
