package com.thebeastshop.pegasus.component.adaptor.payment.service.impl;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.payment.config.WeiXinConfig;
import com.thebeastshop.pegasus.component.adaptor.payment.constants.WXStatusConstant;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.service.WeiXinPayService;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeChatAppletConfig;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import com.thebeastshop.support.exception.PlatErrInfo;
import com.thebeastshop.support.exception.PlatInternalException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.MD5SignUtil;
import com.thebeastshop.support.util.XmlUtil;

@Service
public class WeiXinPayServiceImpl extends BaseService implements WeiXinPayService {

	/**
	 * 字符编码
	 */
	private static final String CHARSET = "UTF-8";

	@Override
	public WXUnifiedOrderResponse unifiedOrder(WXUnifiedOrderParams params) {
		WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
		try {
			WXUnifiedOrderRequest request = params.toRequest();
			// 设置appid
			request.setAppid(WeiXinConfig.APP_ID);
			// 设置mch_id
			request.setMch_id(WeiXinConfig.MCH_ID);
			// 设置随机字符串
			request.setNonce_str(StringUtil.getRandomString(16));
			// 设置签名
			request.setSign(this.sign(request));

			logger.info("微信统一下单请求数据：" + request.toString());

			String dataStr = HttpUtil.doXmlPost(WeiXinConfig.UNIFIED_ORDER_URL, XmlUtil.toXml(request), CHARSET);

			response = XmlUtil.toObject(dataStr, WXUnifiedOrderResponse.class);

			logger.info("微信统一下单返回数据：" + response.toString());

		} catch (Exception e) {
			throw new UnknownError("微信统一下单异常: " + e.getMessage() + " " + e.getStackTrace());
		}

		if (response.getReturn_code().equals(WXStatusConstant.ReturnCode.SUCCESS) && response.getResult_code().equals(WXStatusConstant.ReslutCode.SUCCESS)) {
			return response;
		} else {
			String platErrCode = StringUtils.isNotBlank(response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
			String platErrMsg = StringUtils.isNotBlank(response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
			throw new PlatInternalException(new PlatErrInfo("微信统一下单", platErrCode, platErrMsg));
		}

	}

	@Override
	public WXOrderQueryResponse orderQuery(WXOrderQueryParams params) {
		WXOrderQueryResponse response = new WXOrderQueryResponse();
		try {
			WXOrderQueryRequest request = params.toRequest();
			// 设置appid
			request.setAppid(WeiXinConfig.APP_ID);
			// 设置mch_id
			request.setMch_id(WeiXinConfig.MCH_ID);
			// 设置随机字符串
			request.setNonce_str(StringUtil.getRandomString(16));
			// 设置签名
			request.setSign(this.sign(request));

			logger.info("微信查询订单请求数据：" + request.toString());

			String dataStr = HttpUtil.doXmlPost(WeiXinConfig.ORDER_QUERY_URL, XmlUtil.toXml(request), CHARSET);

			response = XmlUtil.toObject(dataStr, WXOrderQueryResponse.class);

			logger.info("微信查询订单返回数据：" + response.toString());

		} catch (Exception e) {
			throw new UnknownError("微信查询订单异常: " + e.getMessage() + " " + e.getStackTrace());
		}

		if (response.getReturn_code().equals(WXStatusConstant.ReturnCode.SUCCESS) && response.getResult_code().equals(WXStatusConstant.ReslutCode.SUCCESS)) {
			return response;
		} else {
			String platErrCode = StringUtils.isNotBlank(response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
			String platErrMsg = StringUtils.isNotBlank(response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
			throw new PlatInternalException(new PlatErrInfo("微信查询订单", platErrCode, platErrMsg));
		}
	}

	@Override
	public String sign(Map<String, String> map) {
		try {
			return MD5SignUtil.md5Sign(map, WeiXinConfig.KEY, WeiXinConfig.CHARSET);
		} catch (Exception e) {
			throw new WrongArgException("微信签名出错", "map:", map);
		}
	}

	@Override
	public String sign(Object obj) {
		try {
			return MD5SignUtil.md5Sign(obj, WeiXinConfig.KEY, WeiXinConfig.CHARSET);
		} catch (Exception e) {
			throw new WrongArgException("微信签名出错", "object:", obj);
		}
	}

	@Override
	public String signPc(Object obj) {
		try {
			return MD5SignUtil.md5Sign(obj, WeiXinConfig.PC_KEY, WeiXinConfig.CHARSET);
		} catch (Exception e) {
			throw new WrongArgException("微信签名出错", "object:", obj);
		}
	}

	@Override
	public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params) {

		WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
		try {
			WXUnifiedOrderRequest request = params.toRequest();
			// 设置appid
			request.setAppid(WeChatAppletConfig.APP_ID);
			// 设置mch_id
			request.setMch_id(WeChatAppletConfig.MCH_ID);
			// 设置随机字符串
			request.setNonce_str(StringUtil.getRandomString(16));
			// 设置签名
			request.setSign(this.signForWX(request).toUpperCase());
			logger.info("微信统一下单请求数据：" + request.toString());

			String dataStr = HttpUtil.doXmlPost(WeiXinConfig.UNIFIED_ORDER_URL, XmlUtil.toXml(request), CHARSET);

			response = XmlUtil.toObject(dataStr, WXUnifiedOrderResponse.class);

			logger.info("微信统一下单返回数据：" + response.toString());

		} catch (Exception e) {
			throw new UnknownError("微信统一下单异常: " + e.getMessage() + " " + e.getStackTrace());
		}

		if (response.getReturn_code().equals(WXStatusConstant.ReturnCode.SUCCESS) && response.getResult_code().equals(WXStatusConstant.ReslutCode.SUCCESS)) {
			return response;
		} else {
			String platErrCode = StringUtils.isNotBlank(response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
			String platErrMsg = StringUtils.isNotBlank(response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
			throw new PlatInternalException(new PlatErrInfo("微信统一下单", platErrCode, platErrMsg));
		}

	}



	@Override
	public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params,Boolean isWebSite) {

		WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
		try {
			WXUnifiedOrderRequest request = params.toRequest();
			// 设置appid
			if(isWebSite){
				request.setAppid(WeChatAppletConfig.APP_ID2);
			}else{
				request.setAppid(WeChatAppletConfig.APP_ID);
			}
			// 设置mch_id
			request.setMch_id(WeChatAppletConfig.MCH_ID);
			// 设置随机字符串
			request.setNonce_str(StringUtil.getRandomString(16));
			// 设置签名
			request.setSign(this.signForWX(request).toUpperCase());
			logger.info("微信统一下单请求数据：" + request.toString());

			String dataStr = HttpUtil.doXmlPost(WeiXinConfig.UNIFIED_ORDER_URL, XmlUtil.toXml(request), CHARSET);

			response = XmlUtil.toObject(dataStr, WXUnifiedOrderResponse.class);

			logger.info("微信统一下单返回数据：" + response.toString());

		} catch (Exception e) {
			throw new UnknownError("微信统一下单异常: " + e.getMessage() + " " + e.getStackTrace());
		}

		if (response.getReturn_code().equals(WXStatusConstant.ReturnCode.SUCCESS) && response.getResult_code().equals(WXStatusConstant.ReslutCode.SUCCESS)) {
			return response;
		} else {
			String platErrCode = StringUtils.isNotBlank(response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
			String platErrMsg = StringUtils.isNotBlank(response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
			throw new PlatInternalException(new PlatErrInfo("微信统一下单", platErrCode, platErrMsg));
		}

	}

	@Override
	public String signForWX(Map<String, String> map) {
		try {
			return MD5SignUtil.md5Sign(map, WeChatAppletConfig.KEY, WeiXinConfig.CHARSET);
		} catch (Exception e) {
			throw new WrongArgException("微信签名出错", "map:", map);
		}
	}

	@Override
	public String signForWX(Object obj) {
		try {
			return MD5SignUtil.md5Sign(obj, WeChatAppletConfig.KEY, WeiXinConfig.CHARSET);
		} catch (Exception e) {
			throw new WrongArgException("微信签名出错", "object:", obj);
		}
	}

}
