package com.thebeastshop.pegasus.component.adaptor.payment.service;

import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayCrossBorderMobilePayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayDirectPayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayMobilePayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2.AlipayTradeQueryParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2.AlipayTradeQueryResponse;

/**
 * 微信第三方服务
 * 
 * @author Paul-xiong
 *
 */
public interface AliPayService {

	/**
	 * 验证是否是支付宝发来的通知
	 * 
	 * @param notify_id
	 * @param isCrossBorder
	 *            是国际支付
	 * @return
	 */
	public boolean notifyVerify(String notify_id, boolean isCrossBorder);

	/**
	 * 国内移动支付
	 *
	 * @param params
	 *            移动支付参数
	 * @return 主要包含商户的订单信息，key=“value”形式，以&连接
	 */
	public String mobilePay(AlipayMobilePayParams params);

	/**
	 * 国际移动支付
	 *
	 * @param params
	 *            移动支付参数
	 * @return 主要包含商户的订单信息，key=“value”形式，以&连接
	 */
	public String crossBorderMobilePay(AlipayCrossBorderMobilePayParams params);

	/**
	 * 即时到账
	 * 
	 * @param params
	 *            即时到账参数
	 * @return 支付宝即时到账链接
	 */
	public String directPay(AlipayDirectPayParams params);

	/**
	 * 交易查询
	 * 
	 * @param params
	 *            交易查询参数
	 * @return 交易查询返回
	 */
	public AlipayTradeQueryResponse tradeQuery(AlipayTradeQueryParams params);

	/**
	 * 签名
	 * 
	 * @param object
	 *            签名对象
	 * @param signType
	 *            签名类型（MD5, RSA）
	 * @param isCrossBorder
	 *            是国际支付
	 * @return
	 */
	public String sign(Object object, String signType, boolean isCrossBorder);

}
