package com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2;

import java.util.List;

/**
 * 支付宝交易查询api返回
 * 
 * @author Paul-xiong
 *
 */
public class AlipayTradeQueryResponse implements AlipayResponse_API2 {

	private String code;

	private String msg;

	private String sub_code;

	private String sub_msg;
	
	/**
	 * 支付宝交易号
	 */
	private String trade_no;
	/**
	 * 商家订单号
	 */
	private String out_trade_no;
	/**
	 * 买家支付宝用户号
	 */
	private String open_id;
	/**
	 * 买家支付宝账号
	 */
	private String buyer_logon_id;
	/**
	 * 交易状态
	 */
	private String trade_status;
	/**
	 * 交易的订单金额
	 */
	private String total_amount;
	/**
	 * 实收金额
	 */
	private String receipt_amount;
	/**
	 * 买家实付金额
	 */
	private String buyer_pay_amount;
	/**
	 * 积分支付的金额
	 */
	private String point_amount;
	/**
	 * 交易中用户支付的可开具发票的金额
	 */
	private String invoice_amount;
	/**
	 * 本次交易打款给卖家的时间
	 */
	private String send_pay_date;
	/**
	 * 支付宝店铺编号
	 */
	private String alipay_store_id;
	/**
	 * 商户门店编号
	 */
	private String store_id;
	/**
	 * 商户机具终端编号
	 */
	private String terminal_id;
	/**
	 * 资金单据信息的集合
	 */
	private List<TradeFundBill> fund_bill_list;
	/**
	 * 请求交易支付中的商户店铺的名称
	 */
	private String store_name;
	/**
	 * 买家在支付宝的用户id
	 */
	private String buyer_user_id;
	/**
	 * 本次交易支付所使用的单品券优惠的商品优惠信息
	 */
	private String discount_goods_detail;
	/**
	 * 行业特殊信息（例如在医保卡支付业务中，向用户返回医疗信息）
	 */
	private String industry_sepc_detail;

	public void setCode(String code) {
		this.code = code;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public void setSub_code(String sub_code) {
		this.sub_code = sub_code;
	}

	public void setSub_msg(String sub_msg) {
		this.sub_msg = sub_msg;
	}

	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	public String getSub_code() {
		return sub_code;
	}

	public String getSub_msg() {
		return sub_msg;
	}

	public String getTrade_no() {
		return trade_no;
	}

	public void setTrade_no(String trade_no) {
		this.trade_no = trade_no;
	}

	public String getOut_trade_no() {
		return out_trade_no;
	}

	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	public String getOpen_id() {
		return open_id;
	}

	public void setOpen_id(String open_id) {
		this.open_id = open_id;
	}

	public String getBuyer_logon_id() {
		return buyer_logon_id;
	}

	public void setBuyer_logon_id(String buyer_logon_id) {
		this.buyer_logon_id = buyer_logon_id;
	}

	public String getTrade_status() {
		return trade_status;
	}

	public void setTrade_status(String trade_status) {
		this.trade_status = trade_status;
	}

	public String getTotal_amount() {
		return total_amount;
	}

	public void setTotal_amount(String total_amount) {
		this.total_amount = total_amount;
	}

	public String getReceipt_amount() {
		return receipt_amount;
	}

	public void setReceipt_amount(String receipt_amount) {
		this.receipt_amount = receipt_amount;
	}

	public String getBuyer_pay_amount() {
		return buyer_pay_amount;
	}

	public void setBuyer_pay_amount(String buyer_pay_amount) {
		this.buyer_pay_amount = buyer_pay_amount;
	}

	public String getPoint_amount() {
		return point_amount;
	}

	public void setPoint_amount(String point_amount) {
		this.point_amount = point_amount;
	}

	public String getInvoice_amount() {
		return invoice_amount;
	}

	public void setInvoice_amount(String invoice_amount) {
		this.invoice_amount = invoice_amount;
	}

	public String getSend_pay_date() {
		return send_pay_date;
	}

	public void setSend_pay_date(String send_pay_date) {
		this.send_pay_date = send_pay_date;
	}

	public String getAlipay_store_id() {
		return alipay_store_id;
	}

	public void setAlipay_store_id(String alipay_store_id) {
		this.alipay_store_id = alipay_store_id;
	}

	public String getStore_id() {
		return store_id;
	}

	public void setStore_id(String store_id) {
		this.store_id = store_id;
	}

	public String getTerminal_id() {
		return terminal_id;
	}

	public void setTerminal_id(String terminal_id) {
		this.terminal_id = terminal_id;
	}

	public List<TradeFundBill> getFund_bill_list() {
		return fund_bill_list;
	}

	public void setFund_bill_list(List<TradeFundBill> fund_bill_list) {
		this.fund_bill_list = fund_bill_list;
	}

	public String getStore_name() {
		return store_name;
	}

	public void setStore_name(String store_name) {
		this.store_name = store_name;
	}

	public String getBuyer_user_id() {
		return buyer_user_id;
	}

	public void setBuyer_user_id(String buyer_user_id) {
		this.buyer_user_id = buyer_user_id;
	}

	public String getDiscount_goods_detail() {
		return discount_goods_detail;
	}

	public void setDiscount_goods_detail(String discount_goods_detail) {
		this.discount_goods_detail = discount_goods_detail;
	}

	public String getIndustry_sepc_detail() {
		return industry_sepc_detail;
	}

	public void setIndustry_sepc_detail(String industry_sepc_detail) {
		this.industry_sepc_detail = industry_sepc_detail;
	}

	@Override
	public String toString() {
		return "AlipayTradeQueryResponse [code=" + code + ", msg=" + msg + ", sub_code=" + sub_code + ", sub_msg="
				+ sub_msg + ", trade_no=" + trade_no + ", out_trade_no=" + out_trade_no + ", open_id=" + open_id
				+ ", buyer_logon_id=" + buyer_logon_id + ", trade_status=" + trade_status + ", total_amount="
				+ total_amount + ", receipt_amount=" + receipt_amount + ", buyer_pay_amount=" + buyer_pay_amount
				+ ", point_amount=" + point_amount + ", invoice_amount=" + invoice_amount + ", send_pay_date="
				+ send_pay_date + ", alipay_store_id=" + alipay_store_id + ", store_id=" + store_id + ", terminal_id="
				+ terminal_id + ", fund_bill_list=" + fund_bill_list + ", store_name=" + store_name + ", buyer_user_id="
				+ buyer_user_id + ", discount_goods_detail=" + discount_goods_detail + ", industry_sepc_detail="
				+ industry_sepc_detail + "]";
	}



	/**
	 * 交易支付的渠道属性
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class TradeFundBill {

		/**
		 * 该支付工具类型所使用的金额
		 */
		private String amount;

		/**
		 * 支付所使用的渠道
		 */
		private String fundChannel;

		public String getAmount() {
			return this.amount;
		}

		public void setAmount(String amount) {
			this.amount = amount;
		}

		public String getFundChannel() {
			return this.fundChannel;
		}

		public void setFundChannel(String fundChannel) {
			this.fundChannel = fundChannel;
		}

		@Override
		public String toString() {
			return "TradeFundBill [amount=" + amount + ", fundChannel=" + fundChannel + "]";
		}

	}

}
