package com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1;

/**
 * 支付宝移动支付请求参数(调用支付宝api时使用)
 * 
 * @author Paul-xiong
 *
 */
public class AlipayMobilePayRequest extends AlipayRequest_API1 {
	// 业务参数

	/**
	 * 标识客户端 (示例:external)
	 * 是否必填(否)
	 */
	private String app_id;
	/**
	 * 标识客户端来源。参数值内容约定如下：appenv=”system=客户端平台名^version=业务系统版本” (示例:appenv=”system=android^version=3.0.1.2”)
	 * 是否必填(否)
	 */
	private String appenv;
	/**
	 * 支付宝合作商户网站唯一订单号 (示例:0819145412-6177)
	 * 是否必填(是)
	 */
	private String out_trade_no;
	/**
	 * 商品的标题/交易标题/订单标题/订单关键字等。该参数最长为128个汉字 (示例:测试)
	 * 是否必填(是)
	 */
	private String subject;
	/**
	 * 支付类型。默认值为：1（商品购买）(示例:1)
	 * 是否必填(是)
	 */
	private String payment_type = "1";
	/**
	 * 卖家支付宝账号（邮箱或手机号码格式）或其对应的支付宝唯一用户号（以2088开头的纯16位数字）(示例:xxx@alipay.com)
	 * 是否必填(是)
	 */
	private String seller_id;
	/**
	 * 该笔订单的资金总额，单位为RMB-Yuan。取值范围为[0.01，100000000.00]，精确到小数点后两位 (示例:0.01)
	 * 是否必填(是)
	 */
	private String total_fee;
	/**
	 * 对一笔交易的具体描述信息。如果是多种商品，请将商品描述字符串累加传给body (示例:测试测试)
	 * 是否必填(是)
	 */
	private String body;
	/**
	 * 具体区分本地交易的商品类型。 1：实物交易； 0：虚拟交易。 默认为1（实物交易）(示例:1)
	 * 是否必填(否)
	 */
	private String goods_type;
	/**
	 * T：发起实名校验； F：不发起实名校验 (示例:T)
	 * 是否必填(否)
	 */
	private String rn_check;
	/**
	 * 设置未付款交易的超时时间，一旦超时，该笔交易就会自动被关闭。当用户输入支付密码、点击确认付款后（即创建支付宝交易后）开始计时。
	 * 取值范围：1m～15d，或者使用绝对时间（示例格式：2014-06-13 16:00:00）。
	 * m-分钟，h-小时，d-天，1c-当天（1c-当天的情况下，无论交易何时创建，都在0点关闭）。
	 * 该参数数值不接受小数点，如1.5h，可转换为90m (示例:30m)
	 * 是否必填(否)
	 */
	private String it_b_pay;
	/**
	 * 开放平台返回的包含账户信息的token（授权令牌，商户在一定时间内对支付宝某些服务的访问权限）。
	 * 通过授权登录后获取的alipay_open_id，作为该参数的value，登录授权账户即会为支付账户 (示例:1b258b84ed2faf3e88b4d979ed9fd4db)
	 * 是否必填(否)
	 */
	private String extern_token;

	public String getApp_id() {
		return app_id;
	}

	public void setApp_id(String app_id) {
		this.app_id = app_id;
	}

	public String getAppenv() {
		return appenv;
	}

	public void setAppenv(String appenv) {
		this.appenv = appenv;
	}

	public String getOut_trade_no() {
		return out_trade_no;
	}

	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getPayment_type() {
		return payment_type;
	}

	public void setPayment_type(String payment_type) {
		this.payment_type = payment_type;
	}

	public String getSeller_id() {
		return seller_id;
	}

	public void setSeller_id(String seller_id) {
		this.seller_id = seller_id;
	}

	public String getTotal_fee() {
		return total_fee;
	}

	public void setTotal_fee(String total_fee) {
		this.total_fee = total_fee;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getGoods_type() {
		return goods_type;
	}

	public void setGoods_type(String goods_type) {
		this.goods_type = goods_type;
	}

	public String getRn_check() {
		return rn_check;
	}

	public void setRn_check(String rn_check) {
		this.rn_check = rn_check;
	}

	public String getIt_b_pay() {
		return it_b_pay;
	}

	public void setIt_b_pay(String it_b_pay) {
		this.it_b_pay = it_b_pay;
	}

	public String getExtern_token() {
		return extern_token;
	}

	public void setExtern_token(String extern_token) {
		this.extern_token = extern_token;
	}

	@Override
	public String toString() {
		return "AlipayMobilePayRequest [app_id=" + getApp_id() + ", appenv=" + getAppenv() + ", out_trade_no="
				+ getOut_trade_no() + ", subject=" + getSubject() + ", payment_type=" + getPayment_type()
				+ ", seller_id=" + getSeller_id() + ", total_fee=" + getTotal_fee() + ", body=" + getBody()
				+ ", goods_type=" + getGoods_type() + ", rn_check=" + getRn_check() + ", it_b_pay=" + getIt_b_pay()
				+ ", extern_token=" + getExtern_token() + ", service=" + getService() + ", partner=" + getPartner()
				+ ", _input_charset=" + get_input_charset() + ", sign_type=" + getSign_type() + ", sign=" + getSign()
				+ ", notify_url=" + getNotify_url() + ", return_url=" + getReturn_url() + "]";
	}
	
}
