package com.thebeastshop.pegasus.component.adaptor.logistics.service.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.logistics.config.SFConfig;
import com.thebeastshop.pegasus.component.adaptor.logistics.constants.SFConstants;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRequest;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRequestBody;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRoute;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRouteRequest;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.SFService;
import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.encode.MD5Util;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.XmlUtil;

/**
 * 顺丰物流信息服务实现
 * 
 * @author Paul-xiong
 *
 */
@Service
public class SFServiceImpl extends BaseService implements SFService {
	/**
	 * 字符编码
	 */
	private final String CHARSET = "UTF-8";

	@Override
	public SFResponse queryByCode(String code) {
		if (StringUtils.isBlank(code)) {
			throw new WrongArgException("物流单号不能为空", "LogisticCode", code);
		}
		try {
			SFRequest request = new SFRequest();
			request.setService(SFConfig.ROUTE_SERVICE);
			request.setLang(SFConfig.LANG_CN);
			request.setHead(SFConfig.ENVI_CODE);
			SFRouteRequest routeRequest = new SFRouteRequest();
			routeRequest.setMethodType(SFConfig.METHOD_TYPE);
			routeRequest.setTrackingType(SFConfig.TRACKING_TYPE);
			routeRequest.setTrackingNumber(code);
			SFRequestBody body = new SFRequestBody();
			body.setRouteRequest(routeRequest);
			request.setBody(body);
			String xml = XmlUtil.toXml(request);
			Map<String, String> params = new HashMap<String, String>();
			params.put("xml", xml);
			String verifyCode = Base64Util.encode(MD5Util.md5ToBytes(xml + SFConfig.CHECKWORD));
			params.put("verifyCode", verifyCode);

			logger.info("查询顺丰快递物流请求信息: {}", params);

			String responseXml = HttpUtil.doFormPost(SFConfig.URL, params, CHARSET);

			logger.info("查询顺丰快递物流返回信息: {}", responseXml);

			SFResponse response = new SFResponse();
			response = XmlUtil.toObject(responseXml, SFResponse.class);

			if (response.getHead().equals(SFConstants.Head.OK) && response.getResponseBody() != null
					&& response.getResponseBody().getRouteResponse() != null) {

				List<SFRoute> list = response.getResponseBody().getRouteResponse().getRoute();
				Collections.sort(list, new Comparator<SFRoute>() {
					@Override
					public int compare(SFRoute o1, SFRoute o2) {
						return o2.getAcceptTime().compareTo(o1.getAcceptTime());
					}
				});
				return response;
			}
		} catch (Exception e) {
			logger.info("查询顺丰快递物流异常 e={}", e);
		}
		return null;
	}

	// public static void main(String[] args) {
	// SFService service = new SFServiceImpl();
	// String code = "606060149917";
	// service.queryByCode(code);
	// }

}
