package com.thebeastshop.pegasus.component.adaptor.logistics.service.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.logistics.config.FedexConfig;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex.FedexResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex.FedexResponse.FedexActivity;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.FedexService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.XmlUtil;

/**
 * 联邦物流信息服务实现
 * 
 * @author Paul-xiong
 *
 */
@Service
public class FedexServiceImpl extends BaseService implements FedexService {
	/**
	 * 字符编码
	 */
	private final String CHARSET = "UTF-8";

	@Override
	public FedexResponse queryByCode(String code) {
		if (StringUtils.isBlank(code)) {
			throw new WrongArgException("物流单号不能为空", "LogisticCode", code);
		}

		try {
			logger.info("查询联邦快递物流信息 orderNo = {}", code);

			String url = FedexConfig.FEDEX_URL_CN + code;
			String dataStr = HttpUtil.doGet(url, null, CHARSET);

			logger.info("联邦快递返回信息: {}", dataStr);
			FedexResponse response = new FedexResponse();
			response = XmlUtil.toObject(dataStr, FedexResponse.class);

			if (response.getTracking() != null && response.getTracking().getDetail() != null
					&& response.getTracking().getDetail().getActivities() != null) {
				List<FedexActivity> activities = response.getTracking().getDetail().getActivities().getActivity();
				Collections.sort(activities, new Comparator<FedexActivity>() {
					@Override
					public int compare(FedexActivity o1, FedexActivity o2) {
						return o2.getDatetime().compareTo(o1.getDatetime());
					}
				});
				return response;
			}
		} catch (Exception e) {
			logger.info("查询联邦物流异常 e={}", e);
		}
		return null;
	}

	// public static void main(String[] args) {
	// FedexService service = new FedexServiceImpl();
	// String code = "120886177797";
	// service.queryByCode(code);
	// }

}
