package com.thebeastshop.pegasus.component.coupon.vo;

import com.thebeastshop.pegasus.component.vo.AccessWayVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-06-30
 */
public class CouponSampleVO {
    /**
     * 优惠券模板主键
     */
    private Long id;

    /**
     * 优惠券模板名称
     */
    private String name;

    /**
     * 优惠券标题
     */
    private String title;

    /**
     * 优惠券类型: 1 满减
     */
    private TypeVO couponType;

    /**
     * 优惠券类型id: 1 满减
     */
    private Integer couponTypeId;

    /**
     * 适用商品简述
     */
    private String productDesc;

    /**
     * 派发方式
     */
    private CouponSendWayVO couponSendWay;

    /**
     * 派发方式id
     */
    private Integer couponSendWayId;

    /**
     * 优惠内容 1.优惠类型为满减情况：返回json数据格式 {"fullPrice":100,"cutPrice":20}
     */
    private Map couponContentMap;

    /**
     * 优惠内容VO
     */
    private CouponContentVO couponContent;

    /**
     * 优惠券状态
     */
    private Integer stateId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 详细信息
     */
    private String description;

    /**
     * 备注
     */
    private String note;

    /**
     * 创建人
     */
    private Long creatorId;

    /**
     * 生成数量
     */
    private Integer maxCount;

    /**
     * 剩余数量
     */
    private Integer balanceCount;

    /**
     * 用户限领数量
     */
    private Integer maxPerMember;

    /**
     * 适用平台集合，平台类型有: 1 PC, 2 APP, 3 WAP, 4 线下门店
     */
    private List<AccessWayVO> accessWays;

    /**
     * 适用平台集合ID，平台类型有: 1 PC, 2 APP, 3 WAP, 4 线下门店
     */
    private List<Integer> accessWayIds;

    /**
     * 适用类目id集合
     */
    private List<Long> categoryIds;

    /**
     * 适用商品范围Id
     */
    private Integer productScopeId;

    /**
     * 适用商品id集合
     */
    private List<Long> productIds;

    /**
     * 排除商品id集合
     */
    private List<Long> excludeProductIds;

    /**
     * 优惠口令
     */
    private String couponCode;

    /**
     * 优惠口令id
     */
    private Long couponCodeId;

    public CouponSampleVO() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TypeVO getCouponType() {
        return this.couponType;
    }

    public void setCouponType(TypeVO couponType) {
        this.couponType = couponType;
    }

    public Integer getCouponTypeId() {
        return this.couponTypeId;
    }

    public void setCouponTypeId(Integer couponTypeId) {
        this.couponTypeId = couponTypeId;
    }

    public String getProductDesc() {
        return this.productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public Map getCouponContentMap() {
        return this.couponContentMap;
    }

    public void setCouponContentMap(Map couponContentMap) {
        this.couponContentMap = couponContentMap;
    }

    public CouponContentVO getCouponContent() {
        return this.couponContent;
    }

    public void setCouponContent(CouponContentVO couponContent) {
        this.couponContent = couponContent;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public Integer getBalanceCount() {
        return this.balanceCount;
    }

    public void setBalanceCount(Integer balanceCount) {
        this.balanceCount = balanceCount;
    }

    public Integer getMaxPerMember() {
        return this.maxPerMember;
    }

    public void setMaxPerMember(Integer maxPerMember) {
        this.maxPerMember = maxPerMember;
    }

    public CouponSendWayVO getCouponSendWay() {
        return this.couponSendWay;
    }

    public void setCouponSendWay(CouponSendWayVO couponSendWay) {
        this.couponSendWay = couponSendWay;
    }

    public Integer getCouponSendWayId() {
        return this.couponSendWayId;
    }

    public void setCouponSendWayId(Integer couponSendWayId) {
        this.couponSendWayId = couponSendWayId;
    }

    public List<AccessWayVO> getAccessWays() {
        return this.accessWays;
    }

    public void setAccessWays(List<AccessWayVO> accessWays) {
        this.accessWays = accessWays;
    }

    public List<Integer> getAccessWayIds() {
        return this.accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(List<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public Integer getProductScopeId() {
        return productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public List<Long> getProductIds() {
        return this.productIds;
    }

    public void setProductIds(List<Long> productIds) {
        this.productIds = productIds;
    }

    public List<Long> getExcludeProductIds() {
        return this.excludeProductIds;
    }

    public void setExcludeProductIds(List<Long> excludeProductIds) {
        this.excludeProductIds = excludeProductIds;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Long getCouponCodeId() {
        return couponCodeId;
    }

    public void setCouponCodeId(Long couponCodeId) {
        this.couponCodeId = couponCodeId;
    }
}
