package com.thebeastshop.pegasus.component.coupon.client;

import com.thebeastshop.pegasus.component.coupon.vo.*;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.vo.StateVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;
import org.forest.annotation.var.DataParam;

import java.util.List;

/**
 * Created by Administrator on 2016/6/30.
 * @author gongjun
 */
public interface CouponClient {

    /**
     * 根据id获取优惠券
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponVO> getCouponById(Long id);



    /**
     * 根据条件获取优惠券列表
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupons",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponVO>> listCoupon(@DataObject CouponCondVO condVO);


    /**
     * 根据条件统计优惠券
     * @param condVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupons/count",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponCountVO> countCoupons(@DataObject CouponCondVO condVO);



    /**
     * 获取所有优惠券模板状态
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/states",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<StateVO>> listAllCouponSampleStates();

    /**
     * 获取所有优惠券类型
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/types",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<TypeVO>> listAllCouponTypes();


    /**
     * 获取所有优惠券派发方式
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sendWays",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSendWayVO>> listAllCouponSendWays();

    /**
     * 根据条件查询优惠券模板
     * @param cond
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/samples",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSampleVO>> listCouponSample(@DataObject CouponSampleCondVO cond);

    /**
     * 根据ID查询优惠券模板
     * @param id
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponSampleVO> getCouponSample(Long id);

    /**
     * 更新优惠券模板状态
     * @param id
     * @param stateId
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/state",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> updateCouponSampleState(@DataParam("id") Long id, @DataParam("stateId") Integer stateId);

    /**
     * 创建优惠券模板
     * @param couponSampleVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> createCouponSample(@DataObject CouponSampleVO couponSampleVO);


    @Request(
            url = "${couponBaseUrl}/v1/coupon/code",
            type = "get",
            dataType = "json"
    )
    ApiResult<String> generateCouponCode();

    /**
     * 根据优惠券模板ID获取优惠口令
     * @param id
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/code",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponCodeVO> getCouponCodeBySampleId(Long id);


    /**
     * 派发多个用户ID优惠券
     * @param sendCouponUserVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/send",
            contentType = "application/json",
            timeout = 999999,
            type = "post",
            dataType = "json"
    )
    ApiResult<String> sendCouponUsers(@DataObject SendCouponUserVO sendCouponUserVO);

    /**
     * 获取所有待第一级审批或已通过第一级审批的优惠券模板
     *
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/sample/pending/first",
            type="get",
            dataType="json"
    )
    ApiResult<List<PendingCouponVO>> getFirstPendingCouponSample(@DataObject PendingCondVO vo);

    /**
     * 获取所有待第二级审批或已通过第二级审批的优惠券模板
     *
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/sample/pending/second",
            type="get",
            dataType="json"
    )
    ApiResult<List<PendingCouponVO>> getSecondPendingCouponSample(@DataObject PendingCondVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/submit/approval",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> submitApproval(Long id);


    /**
     * 通过口令 领取/兑换 优惠券
     * @param vo
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/code/exchange",
            contentType = "application/json",
            timeout = 999999,
            type = "post",
            dataType = "json"
    )
    ApiResult<CouponCodeExchangeVO> exchangeCouponCode(@DataObject CouponCodeExchangeVO vo);

}
