package com.thebeastshop.pegasus.component.campaign.vo;

import com.thebeastshop.pegasus.component.coupon.vo.FullCutPriceVO;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Desc:创建活动的VO
 *
 * Created by hafiz.zhang on 2016/7/14.
 */
public class AddCampaignVO {
    private Integer type;                               //活动类型  1.打折 2.满减 3.买赠 4.加价购
    private String name;                                //活动名称
    private String title;                               //活动文案
    private Date startTime;                             //活动开始时间
    private Date expireTime;                            //活动结束时间
    private List<Integer> accessWays;                   //活动适用平台    0.未知  1.PC  2.APP  3.WAP  4.线下门店
    private List<Integer> memberLevels;                 //活动适用会员等级  -1.注册会员 0.蚂蚁会员 1.小猫会员 2.老虎会员 3.大象会员
    private Integer productScope;                       //活动适用商品范围  1.单品；2.多品；3.全场
    private List<Long> categories;                      //活动适用商品类目编号
    private BigDecimal factor;                          //打折类型的折扣、买赠类型的赠数
    private Boolean cumulative;                         //多次满足条件是否累积优惠
    private List<FullCutPriceVO> fullCutPriceList;      //满减类型的满减区间列表
    private Integer conditionType;                      //加价购类型的条件类型，1.按金额 2.按件数
    private BigDecimal line;                            //买赠类型的满足条件件数、加价购类型的满足条件金额
    private List<SectionProductVO> sectionProductList;  //买赠类型的赠品集合、加价购类型的加价购商品的集合
    private List<AddCampaignProductVO> productList;     //活动适用商品集合

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public List<Integer> getAccessWays() {
        return accessWays;
    }

    public void setAccessWays(List<Integer> accessWays) {
        this.accessWays = accessWays;
    }

    public List<Integer> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Integer getProductScope() {
        return productScope;
    }

    public void setProductScope(Integer productScope) {
        this.productScope = productScope;
    }

    public List<Long> getCategories() {
        return categories;
    }

    public void setCategories(List<Long> categories) {
        this.categories = categories;
    }

    public BigDecimal getFactor() {
        return factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public Boolean getCumulative() {
        return cumulative;
    }

    public void setCumulative(Boolean cumulative) {
        this.cumulative = cumulative;
    }

    public List<FullCutPriceVO> getFullCutPriceList() {
        return fullCutPriceList;
    }

    public void setFullCutPriceList(List<FullCutPriceVO> fullCutPriceList) {
        this.fullCutPriceList = fullCutPriceList;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public BigDecimal getLine() {
        return line;
    }

    public void setLine(BigDecimal line) {
        this.line = line;
    }

    public List<SectionProductVO> getSectionProductList() {
        return sectionProductList;
    }

    public void setSectionProductList(List<SectionProductVO> sectionProductList) {
        this.sectionProductList = sectionProductList;
    }

    public List<AddCampaignProductVO> getProductList() {
        return productList;
    }

    public void setProductList(List<AddCampaignProductVO> productList) {
        this.productList = productList;
    }

    @Override
    public String toString() {
        return "AddCampaignVO{" +
                "type=" + type +
                ", name='" + name + '\'' +
                ", title='" + title + '\'' +
                ", startTime=" + startTime +
                ", expireTime=" + expireTime +
                ", accessWays=" + accessWays +
                ", memberLevels=" + memberLevels +
                ", productScope=" + productScope +
                ", categories=" + categories +
                ", factor=" + factor +
                ", cumulative=" + cumulative +
                ", fullCutPriceList=" + fullCutPriceList +
                ", conditionType=" + conditionType +
                ", line=" + line +
                ", sectionProductList=" + sectionProductList +
                ", productList=" + productList +
                '}';
    }
}
