package com.thebeastshop.pegasus.component.campaign.client;

import com.thebeastshop.pegasus.component.campaign.vo.*;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.vo.StateVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;
import org.forest.annotation.var.DataParam;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-04
 */
public interface CampaignClient {

    /**
     * 获取所有活动状态
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/states",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<StateVO>> listAllCampaignStates();


    /**
     * 根据条件查询活动
     * @param cond
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaigns",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignVO>> listCampaign(@DataObject CampaignCondVO cond);


    /**
     * 根据条件查询活动(结果与商品ID对应)
     * @param params
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/map/campaigns",
            type = "get",
            dataType = "json"
    )
    ApiResult<Map<Long, List<CampaignVO>>> mapListCampaign(@DataParam("params") String params);



    /**
     * 获取所有活动类型
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/types",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<TypeVO>> listAllCampaignTypes();

    /**
     * 获取指定id的活动详情
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignVO> getCampaignById(Long id);

    /**
     * 根据活动编号获取活动详情（包括优惠区间一级额外商品）
     *
     * @param id 活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/detail",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignDetailVO> getCampaignDetailById(Long id);

    /**
     * 根据活动编号获取该活动关联的优惠区间信息
     *
     * @param id
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/sections",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignSectionVO>> getCampaignSectionById(Long id);

    /**
     * 获取所有待一级审批或者已通过一级审批的活动
     *
     * @param vo    查询条件
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/first",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<PendingCampaignVO>> getFirstApprovalCampaign(@DataObject PendingCampaignCondVO vo);

    /**
     *  获取所有待二级审批或者已通过二级审批的活动
     *
     * @param vo    查询条件
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/second",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<PendingCampaignVO>> getSecondApprovalCampaign(@DataObject PendingCampaignCondVO vo);

    /**
     * 根据活动编号获取活动适用商品集合
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/product/include",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getIncludeProductList(Long id);

    /**
     * 根据活动编号获取活动排除商品
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/product/exclude",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getExcludeProductList(Long id);

    //**************************************为了兼容，回滚的代码，以后要删除*********************************************

    /**
     * 根据活动编号查找该活动所涉及的所有商品信息
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/product",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getProductListByCampaignId(Long id);


    //**************************************为了兼容，回滚的代码，以后要删除*********************************************

    /**
     * 根据活动编号查找该活动所涉及的所有分类目录
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/category",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignCategoryVO>> getCategoryListByCampaignId(Long id);

    /**
     * 获取所有的类目列表
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/category/list",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignCategoryVO>> getAllCategories();

    /**
     * 创建活动
     *
     * @param vo    待创建活动实体
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> addCampaign(@DataObject AddCampaignVO vo);

    /**
     * 下线活动
     *
     * @param id 待下线活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/offLine",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> offLine(Long id);

    /**
     * 获取活动审批记录
     *
     * @param id 活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/record/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<ApprovalRecordVO>> getApprovalRecords(Long id);
}
