package com.thebeastshop.pegasus.component.campaign.client;

import com.thebeastshop.pegasus.component.coupon.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;

import java.util.List;

/**
 * Desc:
 * Created by hafiz.zhang on 2016/7/12.
 */
public interface CampaignApprovalClient {
    /**
     * 根据审批活动编号查找该活动的审批记录
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/record/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<ApprovalRecordVO>> listApprovalRecord(Long id);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> approvalCampaign(@DataObject ApprovalVO vo);
}
