package com.thebeastshop.pegasus.component.json;

import com.thebeastshop.pegasus.component.enums.ResultStatus;

import java.io.Serializable;

/**
 * Api返回结果
 * @author gongjun
 * @since 2016-06-30
 */
public class ApiResult<T> implements Serializable {
    private Integer status;
    private String message;
    private T data;

    public ApiResult() {
    }

    public ApiResult(ResultStatus resultStatus) {
        this.status = resultStatus.getStatus();
        this.message = resultStatus.getMessage();
    }

    public ApiResult(Integer status, String message, T data) {
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public static <T> ApiResult<T> fromStatus(ResultStatus resultStatus) {
        return new ApiResult(resultStatus);
    }

    public static <T> ApiResult<T> fromErrorMessage(String message) {
        return (new ApiResult()).error(message);
    }

    public static <T> ApiResult<T> fromSuccessData(T data) {
        return (new ApiResult()).success(data);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ApiResult<T> message(String message) {
        this.message = message;
        return this;
    }

    public ApiResult<T> error(String message) {
        this.setStatus(ResultStatus.ERROR.getStatus());
        this.setMessage(message);
        return this;
    }

    public ApiResult<T> success(T data) {
        this.setStatus(ResultStatus.SUCCESS.getStatus());
        this.setMessage(ResultStatus.SUCCESS.getMessage());
        this.setData(data);
        return this;
    }

    public ApiResult<T> status(Integer status) {
        this.status = status;
        return this;
    }

    public ApiResult<T> status(ResultStatus status) {
        this.status = status.getStatus();
        this.message = status.getMessage();
        return this;
    }
}
