package com.thebeastshop.pegasus.channelservice.vo.website.user;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.common.enums.MemberLevelEnum;

/***
 * 对外接口的用户对象。变量名称使用原oe 变量名称 
 * @author fs
 *
 */
public class UserQueryVO {
	//用户头像链接
	private String avatar;
	//用户星座
	private String constellation;
	//用户等级
	private String cust_level;
	//用户学历
	private String degree;
	//用户邮箱
	private String email;
	//用户类型.手机用户、邮箱用户
	private String identity_type;
	//用户固定电话
	private String magento_phone;
	//用户积分
	private Double member_point;
    // 历史积分
    private Double history_point; 
	private String memberCode;
	//用户等级描述
	private String memberLevelDesc;
	private int memberLevel=-1;
	//用户手机
	private String mobile;
	//用户id
	private Long partner_id;
	//用户密码
	private String password;
	//用户职业
	private String profession;
	private UserProfileVO profile=new UserProfileVO();
	//用户微博
	private String weibo;
	//用户微信
	private String weixin;
	// 验证的手机号
    private String verifiedMobile;
    
    private Integer birthdayDiscountYear;
	public String getAvatar() {
		return avatar;
	}
	public String getConstellation() {
		return constellation;
	}
	public String getCust_level() {
		return cust_level;
	}
	public String getDegree() {
		return degree;
	}
	public String getEmail() {
		return email;
	}
	public String getIdentity_type() {
		return identity_type;
	}
	public String getMagento_phone() {
		return magento_phone;
	}
	public Double getMember_point() {
		return member_point;
	}
	public String getMemberCode() {
		return memberCode;
	}
	public String getMemberLevelDesc() {
		if(StringUtils.isBlank(cust_level)){
			memberLevelDesc="注册会员";
		}else if("ip".equals(cust_level)){
			memberLevelDesc=MemberLevelEnum.VIP.getName();
		}else if("vip".equals(cust_level)){
			memberLevelDesc="小猫会员";
		}else if("vvip".equals(cust_level)){
			memberLevelDesc="老虎会员";
		}else if("3vip".equals(cust_level)){
			memberLevelDesc="大象会员";
		}
		return memberLevelDesc;
	}
	public String getMobile() {
		return mobile;
	}
	public Long getPartner_id() {
		return partner_id;
	}
	public String getPassword() {
		return password;
	}
	public String getProfession() {
		return profession;
	}
	public UserProfileVO getProfile() {
		return profile;
	}
	public String getWeibo() {
		return weibo;
	}
	public String getWeixin() {
		return weixin;
	}
	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}
	public void setConstellation(String constellation) {
		this.constellation = constellation;
	}
	public void setCust_level(String cust_level) {
		this.cust_level = cust_level;
	}
	public void setDegree(String degree) {
		this.degree = degree;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public void setIdentity_type(String identity_type) {
		this.identity_type = identity_type;
	}
	public void setMagento_phone(String magento_phone) {
		this.magento_phone = magento_phone;
	}
	public void setMember_point(Double member_point) {
		this.member_point = member_point;
	}
	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	public void setMemberLevelDesc(String memberLevelDesc) {
		this.memberLevelDesc = memberLevelDesc;
	}
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	public void setPartner_id(Long partner_id) {
		this.partner_id = partner_id;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public void setProfession(String profession) {
		this.profession = profession;
	}
	public void setProfile(UserProfileVO profile) {
		this.profile = profile;
	}
	public void setWeibo(String weibo) {
		this.weibo = weibo;
	}
	public void setWeixin(String weixin) {
		this.weixin = weixin;
	}
	public Double getHistory_point() {
		return history_point;
	}
	public void setHistory_point(Double history_point) {
		this.history_point = history_point;
	}
	public String getVerifiedMobile() {
		return verifiedMobile;
	}
	public void setVerifiedMobile(String verifiedMobile) {
		this.verifiedMobile = verifiedMobile;
	}
	public int getMemberLevel() {
		return memberLevel;
	}
	public void setMemberLevel(int memberLevel) {
		this.memberLevel = memberLevel;
	}
	public Integer getBirthdayDiscountYear() {
		return birthdayDiscountYear;
	}
	public void setBirthdayDiscountYear(Integer birthdayDiscountYear) {
		this.birthdayDiscountYear = birthdayDiscountYear;
	}
	
}
