package com.thebeastshop.pegasus.channelservice.vo.website.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.vo.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.order.SoInvoiceInfoVO;

/***
 * 处理接口请求的订单对象. 下单接口对象
 *
 * @author fs
 */
public class OrderCreateVO {

    /**
     * 需要发票~是
     */
    public static final int NEED_INVOICE_TRUE = 1;
    /**
     * 需要发票~否
     */
    public static final int NEED_INVOICE_FALSE = 0;

    /**
     * 发票随同货物发送
     */
    public static final int INVOICE_IN_SAME_PACKAGE = 1;
    /**
     * 发票不随同货物发送
     */
    public static final int INVOICE_NOT_IN_SAME_PACKAGE = 0;
    /**
     * 海外购标志位-是海外购
     */
    public static final int CROSS_BOARDER_FLAG_IS_OVERSEA = 1;
    /**
     * 海外购标志位-不是海外购
     */
    public static final int CROSS_BOARDER_FLAG_NOT_OVERSEA = 0;

    //是否匿名购买
    private Boolean anonymous;
    // 礼品卡金额
    private Double cardFee_discount;
    private String channel_code;
    //优惠券
    private String coupon_code;
    //购买者id
    private Long customer_id;
    //收货人信息
    private AddressVO delivery_address = new AddressVO();
    //送达日期
    private String delivery_date;
    //配送方式
    private String delivery_type;
    // 内部备注
    private String innerRemark;
    //订单详情
    private List<OrderCreateDetailVO> items = new ArrayList<OrderCreateDetailVO>();
    //是否限时配送
    private Boolean limited_delivery;
    //显示配送时间
    private String limited_hour;
    //买家备注信息
    private String note;
    //卡片
    private Integer note_card;
    //卡片内容
    private String note_card_message;
    //折扣费用
    private Double other_discount;
    //提货门店id --对应自提
    private String pick_shop_id;

    //礼品卡
    private String present_cards;
    //订单来源
    private String refer;
    //服务费
    private Double service_fee;

    /**
     * @author lijing
     * 是否需要发票  0否 1 是
     */
    private Integer needInvoice;

    /**
     * @author lijing
     * 发票是否随同货物发送，0否1是
     */
    private Integer isInvoiceInSamePackage;
    /**
     * 发票
     */
    private SoInvoiceInfoVO soInvoiceInfoVO = new SoInvoiceInfoVO();

    //  跨境购标注 0普通１跨境购
    private Integer crossBorderFlag;
    // 海淘运费
    private BigDecimal crossFree;
    // 海淘信息
    private IdCardVO idCardVO = new IdCardVO();

    private Integer isGiftCard = 0;
    
    public Boolean getAnonymous() {
        return anonymous;
    }

    public Double getCardFee_discount() {
        return cardFee_discount;
    }

    public String getChannel_code() {
        return channel_code;
    }

    public String getCoupon_code() {
        return coupon_code;
    }

    public Long getCustomer_id() {
        return customer_id;
    }

    public AddressVO getDelivery_address() {
        return delivery_address;
    }

    public String getDelivery_date() {
        return delivery_date;
    }

    public String getDelivery_type() {
        return delivery_type;
    }

    public String getInnerRemark() {
        return innerRemark;
    }

    public List<OrderCreateDetailVO> getItems() {
        return items;
    }

    public Boolean getLimited_delivery() {
        return limited_delivery;
    }

    public String getLimited_hour() {
        return limited_hour;
    }

    public String getNote() {
        return note;
    }

    public Integer getNote_card() {
        return note_card;
    }

    public String getNote_card_message() {
        return note_card_message;
    }

    public Double getOther_discount() {
        return other_discount;
    }

    public String getPick_shop_id() {
        return pick_shop_id;
    }

    public String getPresent_cards() {
        return present_cards;
    }

    public String getRefer() {
        return refer;
    }

    public Double getService_fee() {
        return service_fee;
    }

    public void setAnonymous(final Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setCardFee_discount(final Double cardFee_discount) {
        this.cardFee_discount = cardFee_discount;
    }

    public void setChannel_code(final String channel_code) {
        this.channel_code = channel_code;
    }

    public void setCoupon_code(final String coupon_code) {
        this.coupon_code = coupon_code;
    }

    public void setCustomer_id(final Long customer_id) {
        this.customer_id = customer_id;
    }

    public void setDelivery_address(final AddressVO delivery_address) {
        this.delivery_address = delivery_address;
    }

    public void setDelivery_date(final String delivery_date) {
        this.delivery_date = delivery_date;
    }

    public void setDelivery_type(final String delivery_type) {
        this.delivery_type = delivery_type;
    }

    public void setInnerRemark(final String innerRemark) {
        this.innerRemark = innerRemark;
    }

    public void setItems(final List<OrderCreateDetailVO> items) {
        this.items = items;
    }

    public void setLimited_delivery(final Boolean limited_delivery) {
        this.limited_delivery = limited_delivery;
    }

    public void setLimited_hour(final String limited_hour) {
        this.limited_hour = limited_hour;
    }

    public void setNote(final String note) {
        this.note = note;
    }

    public void setNote_card(final Integer note_card) {
        this.note_card = note_card;
    }

    public void setNote_card_message(final String note_card_message) {
        this.note_card_message = note_card_message;
    }

    public void setOther_discount(final Double other_discount) {
        this.other_discount = other_discount;
    }

    public void setPick_shop_id(final String pick_shop_id) {
        this.pick_shop_id = pick_shop_id;
    }

    public void setPresent_cards(final String present_cards) {
        this.present_cards = present_cards;
    }

    public void setRefer(final String refer) {
        this.refer = refer;
    }

    public void setService_fee(final Double service_fee) {
        this.service_fee = service_fee;
    }

    public IdCardVO getIdCardVO() {
        return idCardVO;
    }

    public void setIdCardVO(final IdCardVO idCardVO) {
        this.idCardVO = idCardVO;
    }

    public SoInvoiceInfoVO getSoInvoiceInfoVO() {
        return soInvoiceInfoVO;
    }

    public void setSoInvoiceInfoVO(final SoInvoiceInfoVO soInvoiceInfoVO) {
        this.soInvoiceInfoVO = soInvoiceInfoVO;
    }

    public Integer getNeedInvoice() {
        return needInvoice;
    }

    public void setNeedInvoice(final Integer needInvoice) {
        this.needInvoice = needInvoice;
    }

    public Integer getIsInvoiceInSamePackage() {
        return isInvoiceInSamePackage;
    }

    public void setIsInvoiceInSamePackage(final Integer isInvoiceInSamePackage) {
        this.isInvoiceInSamePackage = isInvoiceInSamePackage;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(final Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public BigDecimal getCrossFree() {
        return crossFree;
    }

    public void setCrossFree(final BigDecimal crossFree) {
        this.crossFree = crossFree;
    }

	public Integer getIsGiftCard() {
		return isGiftCard;
	}

	public void setIsGiftCard(Integer isGiftCard) {
		this.isGiftCard = isGiftCard;
	}

	
    
}
