package com.thebeastshop.pegasus.channelservice.vo.order;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;

public class ProductPackVO implements ProductPack{


	private Campaign campaign;
	
	private Long id;
	private Long spvId;
	private PsSpvVO spv;
	private Long productId;
	private PsProductVO product;
	private BigDecimal factProductPrice;
	private BigDecimal customizePrice;
	private int count = 1;
	private CartPackSourceEnum source = CartPackSourceEnum.RAW;
	private boolean valid = true;
	private boolean isCustomize = false;
	private List<CartCustomization> customizeList;
	private Date createTime;
	private String sourceBindVal;

	public ProductPackVO() {
		super();
	}

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getSpvId() {
		return spvId;
	}

	public void setSpvId(final Long spvId) {
		this.spvId = spvId;
	}

	@Override
	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}

	public void setFactProductPrice(final BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}

	@Override
	public int getCount() {
		return count;
	}

	public void setCount(final int count) {
		this.count = count;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}
	
	@Override
	public CartPackSourceEnum getSource() {
		return source;
	}

	public void setSource(CartPackSourceEnum source) {
		this.source = source;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}


	public Long getProductId() {
		return productId;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public PsSpvVO getSpv() {
		return spv;
	}

	public void setSpv(PsSpvVO spv) {
		this.spv = spv;
	}

	public PsProductVO getProduct() {
		return product;
	}

	public void setProduct(PsProductVO product) {
		this.product = product;
	}

	@Override
	public boolean isCustomize() {
		return isCustomize;
	}

	public void setCustomize(boolean customize) {
		isCustomize = customize;
	}

	@Override
	public List<CartCustomization> getCustomizeList() {
		return customizeList;
	}

	public void setCustomizeList(List<CartCustomization> customizeList) {
		this.customizeList = customizeList;
	}

	public BigDecimal getCustomizePrice() {
		return customizePrice;
	}

	public void setCustomizePrice(BigDecimal customizePrice) {
		this.customizePrice = customizePrice;
	}

	public String getSourceBindVal() {
		return sourceBindVal;
	}

	@Override
	public Integer getLimitCount() {
		return null;
	}

	public void setSourceBindVal(String sourceBindVal) {
		this.sourceBindVal = sourceBindVal;
	}

	public Campaign getCampaign() {
		return campaign;
	}

	public void setCampaign(Campaign campaign) {
		this.campaign = campaign;
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

	@Override
	public BigDecimal getPrice() {
		// TODO Auto-generated method stub
		return null;
	}
	
}
