package com.thebeastshop.pegasus.channelservice.vo.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/***
 * 订单包含的sku
 * @author 
 *
 */
public class OrderSkuVO {
	private String productCode;     //sku对应的productcode
	private String skuCode;
	private String showSkuCode;    //展示sku
	private Double unitPrice;        //产品单价
	private Double unitPriceAfterDiscount=0.0; //单品折扣后单价 
    private Integer cancleQuantity;  //取消数量
	private int quantity;            //产品个数
	private String imgUrl;           //商品缩略图URL
	private String brandName;		//品牌名称(en)
	private String skuTitle; 		//sku名称
	// 跨境购标注 0普通１跨境购
	private Integer crossBorderFlag;
	
	private Long packageId;
	
	/**
	 * 行总折扣(单品折扣*数量）
	 */
    private BigDecimal totalDiscount=BigDecimal.ZERO;
    
    /**
     * SPV对应属性值对
     */
    private List<GroupProdSKu> groupProdSKuList=new ArrayList<>();
    
	public String getBrandName() {
		return brandName;
	}
	public String getImgUrl() {
		return imgUrl;
	}
	public String getProductCode() {
		return productCode;
	}
	public int getQuantity() {
		return quantity;
	}
	public String getSkuCode() {
		return skuCode;
	}
	public String getSkuTitle() {
		return skuTitle;
	}
	public Double getUnitPrice() {
		return unitPrice;
	}
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}
	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}
	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}
	public void setSkuTitle(String skuTitle) {
		this.skuTitle = skuTitle;
	}
	public void setUnitPrice(Double unitPrice) {
		this.unitPrice = unitPrice;
	}
	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}
	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
	public Integer getCancleQuantity() {
		return cancleQuantity;
	}
	public void setCancleQuantity(Integer cancleQuantity) {
		this.cancleQuantity = cancleQuantity;
	}
	public BigDecimal getTotalDiscount() {
		return totalDiscount;
	}
	public void setTotalDiscount(BigDecimal totalDiscount) {
		this.totalDiscount = totalDiscount;
	}
	public String getShowSkuCode() {
		return showSkuCode;
	}
	public void setShowSkuCode(String showSkuCode) {
		this.showSkuCode = showSkuCode;
	}
	public Double getUnitPriceAfterDiscount() {
		return unitPriceAfterDiscount;
	}
	public void setUnitPriceAfterDiscount(Double unitPriceAfterDiscount) {
		this.unitPriceAfterDiscount = unitPriceAfterDiscount;
	}
	public Long getPackageId() {
		return packageId;
	}
	public void setPackageId(Long packageId) {
		this.packageId = packageId;
	}
	public List<GroupProdSKu> getGroupProdSKuList() {
		return groupProdSKuList;
	}
	public void setGroupProdSKuList(List<GroupProdSKu> groupProdSKuList) {
		this.groupProdSKuList = groupProdSKuList;
	}

	
}
