package com.thebeastshop.pegasus.channelservice.vo.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.product.SpvVO;

/**
 * 订单商品包vo
 * 
 * @author Paul-xiong
 *
 */
public class OrderProductPackVO implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6248972891834189937L;
	/**
	 * 包的id
	 */
	private Long id;
	/**
	 * 商品数量
	 */
	private Integer count;
	/**
	 * 
	 */
	private SpvVO spv;
	/**
	 * 商品包所属赠品列表
	 */
	private List<OrderProductPackVO> gifts;

	/**O
	 * 商品来源
	 */
	private CartPackSource source;
	/**
	 * 定制内容
	 */
	private List<CartCustomization> customizeList;
	/**
	 * 定制费
	 */
	private BigDecimal customizePrice; 

	private String sourceBindVal;
	
	private BigDecimal factProductPrice;
	
	private Campaign campaign;
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public SpvVO getSpv() {
		return spv;
	}

	public void setSpv(SpvVO spv) {
		this.spv = spv;
	}

	public CartPackSource getSource() {
		return source;
	}

	public void setSource(CartPackSource source) {
		this.source = source;
	}

	public List<OrderProductPackVO> getGifts() {
		return gifts;
	}

	public void setGifts(List<OrderProductPackVO> gifts) {
		this.gifts = gifts;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this).append("id", id).append("count", count).append("spv", spv)
				.append("gifts", gifts).append("source", source).toString();
	}

	public List<CartCustomization> getCustomizeList() {
		return customizeList;
	}

	public void setCustomizeList(List<CartCustomization> customizeList) {
		this.customizeList = customizeList;
	}

	public BigDecimal getCustomizePrice() {
		return customizePrice;
	}

	public void setCustomizePrice(BigDecimal customizePrice) {
		this.customizePrice = customizePrice;
	}

	public String getSourceBindVal() {
		return sourceBindVal;
	}

	public void setSourceBindVal(String sourceBindVal) {
		this.sourceBindVal = sourceBindVal;
	}

	public BigDecimal getFactProductPrice() {
		return factProductPrice;
	}

	public void setFactProductPrice(BigDecimal factProductPrice) {
		this.factProductPrice = factProductPrice;
	}

	public Campaign getCampaign() {
		return campaign;
	}

	public void setCampaign(Campaign campaign) {
		this.campaign = campaign;
	}
	
	
}
