package com.thebeastshop.pegasus.channelservice.vo.order;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;

/***
 * 通用的订单详情
 * @author fs
 *
 */
public class OrderDetailVO {

	//订单号
		private String orderCode;
		//订单日期
		private String orderDate;
		//订单状态描述
		private String orderStateDesc;
		//订单状态
		private Integer orderState;
		//渠道编码
		private String channelCode;

		//渠道名称
		private String channelName;

		//订单实际需要支付金额
		private Double payAmount;

		//礼品卡金额
		private Double giftCardAmount;

		//优惠券金额
		private Double couponAmount;

	    //服务费
	    private BigDecimal serviceFeeAmount;

		//订单支付时间
		private String payTime;

		//审单时间
		private String auditTime;


		//包裹信息
		private List<OrderPackageVO> packages;
		
		private IdCardVO idCardVO=new IdCardVO();
		//  跨境购标注 0普通１跨境购
		private Integer crossBorderFlag; 
		
		//  大家具 0否１是
		private Integer hasLogistics = 0; 
		//海淘运费
		private Double crossBorderFee;
		
	    //是否匿名发货 0否1是
	    private Integer isAnonymous;
		/**
		 * 总价
		 */
		private BigDecimal totalAmount=BigDecimal.ZERO;
		/**
		 * 订单头折扣
		 */
		private BigDecimal discountOnHead=BigDecimal.ZERO;
		/**
		 * 订单行折扣汇总
		 */
		private BigDecimal discountOnLine=BigDecimal.ZERO;
		
	    //订单类型，1月送鲜花
	    private Integer orderType;
	    
		/**
		 * 价格步骤
		 */
		private Collection<PriceStepVO> priceSteps;
	    
		public String getAuditTime() {
			return auditTime;
		}

		public String getChannelCode() {
			return channelCode;
		}

		public String getChannelName() {
			return channelName;
		}

		public Double getCouponAmount() {
			return couponAmount;
		}

		public Double getGiftCardAmount() {
			return giftCardAmount;
		}

		public String getOrderCode() {
			return orderCode;
		}

		public String getOrderDate() {
			return orderDate;
		}
		public String getOrderStateDesc() {
			return orderStateDesc;
		}
		public List<OrderPackageVO> getPackages() {
			return packages;
		}
		public Double getPayAmount() {
			return payAmount;
		}
		public String getPayTime() {
			return payTime;
		}
		public void setAuditTime(String auditTime) {
			this.auditTime = auditTime;
		}
		public void setChannelCode(String channelCode) {
			this.channelCode = channelCode;
		}
		public void setChannelName(String channelName) {
			this.channelName = channelName;
		}
	
	public void setCouponAmount(Double couponAmount) {
		this.couponAmount = couponAmount;
	}


	public void setGiftCardAmount(Double giftCardAmount) {
		this.giftCardAmount = giftCardAmount;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public void setOrderStateDesc(String orderStateDesc) {
		this.orderStateDesc = orderStateDesc;
	}

	public void setPackages(List<OrderPackageVO> packages) {
		this.packages = packages;
	}

	public void setPayAmount(Double payAmount) {
		this.payAmount = payAmount;
	}

	public void setPayTime(String payTime) {
		this.payTime = payTime;
	}

	public Integer getOrderState() {
		return orderState;
	}

	public void setOrderState(Integer orderState) {
		this.orderState = orderState;
	}

	public IdCardVO getIdCardVO() {
		return idCardVO;
	}

	public void setIdCardVO(IdCardVO idCardVO) {
		this.idCardVO = idCardVO;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public Double getCrossBorderFee() {
		return crossBorderFee;
	}

	public void setCrossBorderFee(Double crossBorderFee) {
		this.crossBorderFee = crossBorderFee;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getDiscountOnHead() {
		return discountOnHead;
	}

	public void setDiscountOnHead(BigDecimal discountOnHead) {
		this.discountOnHead = discountOnHead;
	}

	public BigDecimal getDiscountOnLine() {
		return discountOnLine;
	}

	public void setDiscountOnLine(BigDecimal discountOnLine) {
		this.discountOnLine = discountOnLine;
	}

	public Integer getIsAnonymous() {
		return isAnonymous;
	}

	public void setIsAnonymous(Integer isAnonymous) {
		this.isAnonymous = isAnonymous;
	}

	public BigDecimal getServiceFeeAmount() {
		return serviceFeeAmount;
	}

	public void setServiceFeeAmount(BigDecimal serviceFeeAmount) {
		this.serviceFeeAmount = serviceFeeAmount;
	}

	public Integer getOrderType() {
		return orderType;
	}

	public void setOrderType(Integer orderType) {
		this.orderType = orderType;
	}

	public Collection<PriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<PriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public Integer getHasLogistics() {
		return hasLogistics;
	}

	public void setHasLogistics(Integer hasLogistics) {
		this.hasLogistics = hasLogistics;
	}

	
	
	
}
