package com.thebeastshop.pegasus.channelservice.vo.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.price.vo.PrsSkuPriceStepVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
import com.thebeastshop.stock.dto.SGroupbuyOwnerOccupyDTO;
import com.thebeastshop.stock.dto.SGroupbuyParterOccupyDTO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cps.CpsInfo;

/***
 * 处理接口请求的订单对象. 下单接口对象
 * 
 * @author ztq
 *
 */
public class OrderCreateVO {

	// 是否匿名购买
	private Boolean anonymous;
	// 礼品卡金额
	private Double cardFeeDiscount;

	private String channelCode;

	// 优惠券
	private String couponCode;
	// 购买者id
	private Long customerId;
	// 收货人信息
	private AddressVO deliveryAddress = new AddressVO();
	// 送达日期
	private String deliveryDate;
	// 配送方式
	private Integer deliveryType;
	// 内部备注
	private String innerRemark;
	// 订单详情
	private List<OrderCreateDetailVO> items = new ArrayList<OrderCreateDetailVO>();
	// 是否限时配送
	private Boolean limitedDelivery;
	// 显示配送时间
	private String limitedHour;
	// 买家备注信息
	private String note;
	// 卡片
	private Integer noteCard;
	// 卡片内容
	private String noteCardMessage;
	// 卡片抬头
	private String noteCardTo;
	// 卡片落款
	private String noteCardFrom;
	// 折扣费用
	private Double otherDiscount;
	// 外部订单号(针对第三方渠道)
	private String outerOrderCode;
	// 提货门店id --对应自提
	private String pickShopId;
	// 礼品卡
	private String presentCards;
	/**
	 * 礼品卡对象
	 */
	private List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs;
	// 订单外部来源
	private String refer;
	// 服务费
	private Double serviceFee;

	// 买家昵称（天猫）
	private String buyerNick;

	// 价格计算（商品相关）
	private PriceResult priceResult;
//	// 服务费计算
//	private List<ServiceFeeStep> serviceStep;
	

	/**
	 * @author lijing 是否需要发票 0否 1 是
	 */
	private Integer needInvoice;

	/**
	 * @author lijing 发票是否随同货物发送，0否1是
	 */
	private Integer isInvoiceInSamePackage;
	/** 第三方渠道 */
	private CpsInfo cpsInfo;
	/**
	 * 发票
	 */
	private SoInvoiceInfoVO soInvoiceInfoVO = new SoInvoiceInfoVO();

	/**
	 * 需要发票~是
	 */
	public static final Integer NEED_INVOICE_TRUE = 1;
	/**
	 * 需要发票~否
	 */
	public static final Integer NEED_INVOICE_FALSE = 0;

	// 跨境购标注 0普通１跨境购
	private Integer crossBorderFlag;
	// 海淘运费
	// private BigDecimal crossFree;
	// 海淘信息
	private IdCardVO idCardVO = new IdCardVO();

	/**
	 * 海外购标志位-是线下海外购
	 */
	public static final int CROSS_BOARDER_FLAG_IS_OVERSEA_3 = 3;
	/**
	 * 海外购标志位-是线下海外购
	 */
	//public static final int CROSS_BOARDER_FLAG_IS_OVERSEA_2 = 2;
	/**
	 * 海外购标志位-是海外购
	 */
	public static final int CROSS_BOARDER_FLAG_IS_OVERSEA = 1;
	/**
	 * 海外购标志位-不是海外购
	 */
	public static final int CROSS_BOARDER_FLAG_NOT_OVERSEA = 0;

	/**
	 * 是否使用生日折扣
	 */
	//private String birthdayDiscountUse;

	private boolean useBdayDiscount = false;
	private boolean birthFlowerUse;
	private BigDecimal birthdayDiscountAmount = BigDecimal.ZERO;
	/**
	 * 生日折扣
	 */

	// private List<Long> packIds;

	private List<CartProductPack> packs = new ArrayList<>();
	/**
	 * 支付金额
	 */
	private BigDecimal actualPayFee;
	
	/**
	 * 支付金额
	 */
	private BigDecimal actualPayPoint;

	// APP下载来源
	private String downloadSource;

	/**
	 * 权益对象
	 */
	private InterestsVO interestsVO;

	/**
	 * 设备Id
	 */
	private String deviceId;

	/**
	 * 投入来源
	 */
	private String utmSource;

	private String warehouseForSales;
	/**
	 * 线下门店专用0，默认，1本地仓库，2总仓库，3预售仓
	 */
	private int stockDistinguish = 0;

//	/**
//	 * 订单类型；7：浦发活动
//	 */
//	public int orderType;
	
	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderBusinessType = OrderBusinessType.NORMAL;

	/**
	 * 所有权益商品
	 */
	//private Map<Long, InterestGoods> interestGoodsMap = null;
	/**
	 * 所有赠品
	 */
	private Map<Long, List<CartProductPack>> giftPackMap = null;

//	/**
//	 * spv 对应的活动
//	 */
//	private Map<Long, List<PrsCampaignVO>> campaignMap = null;

	/**
	 * 操作员Id
	 */
	private Long createOperatorId;
	/**
	 * 操作员名称
	 */
	private String createOperatorName;
	/**
	 * 加加购活动code
	 */
	private Map<Long, String> addiblePacks = null;
	
	/**
	 * spv 步骤
	 */
	private List<PrsSpvPriceStepVO> spvSteps;
	
    /**
     * 价格计算步骤
     */
    private List<PrsPriceStepVO> priceStepVOs;
    
    /**
     * 价格计算步骤sku
     */
	private Map<String,PrsSkuPriceStepVO> skuPriceStepMap = new HashMap<>();
//    /**
//     * 积分兑换对应的Map
//     */
//    private Map<Long, Integer> exchangeMap = null;
    
    /**
     * 支付交易流水号
     */
    private String tradeNo;
    
    /**
     * 支付方式
     */
    private Integer paymentType; 
    /**
     * 订单号
     */
    private String orderCode;
    
    /**
     * 参团数据
     */
    private SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO;
    /**
     * 开团数据
     */
    private SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO;
    
    /**
     * true:开团，fase:参团
     */
    private boolean isGroupbuy = true;
    
	/**
	 * 平台
	 */
	private String tbsClient;
	/**
	 * 投放渠道
	 */
	private String tbsUSource;
	/**
	 * 系统
	 */
	private String platForm;
    
    /**
     * 商场VIP
     */
    private MarketVipVO marketVip;
    
    private Map<String, String> skuWarehouseMap;
    
    /**
     * 预售信息
     */
    private Map<String, SPresaleVO> skuPresaleWarehouseMap;
    
	public boolean isBirthFlowerUse() {
		return birthFlowerUse;
	}

	public void setBirthFlowerUse(boolean birthFlowerUse) {
		this.birthFlowerUse = birthFlowerUse;
	}

	public InterestsVO getInterestsVO() {
		return interestsVO;
	}

	public void setInterestsVO(InterestsVO interestsVO) {
		this.interestsVO = interestsVO;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getBuyerNick() {
		return buyerNick;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public Boolean getAnonymous() {
		return anonymous;
	}

	public Double getCardFeeDiscount() {
		return cardFeeDiscount;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public Long getCustomerId() {
		return customerId;
	}

	public AddressVO getDeliveryAddress() {
		return deliveryAddress;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public Integer getDeliveryType() {
		return deliveryType;
	}

	public String getInnerRemark() {
		return innerRemark;
	}

	public List<OrderCreateDetailVO> getItems() {
		return items;
	}

	public Boolean getLimitedDelivery() {
		return limitedDelivery;
	}

	public String getLimitedHour() {
		return limitedHour;
	}

	public String getNote() {
		return note;
	}

	public Integer getNoteCard() {
		return noteCard;
	}

	public String getNoteCardMessage() {
		return noteCardMessage;
	}

	public String getNoteCardTo() {
		return noteCardTo;
	}

	public void setNoteCardTo(String noteCardTo) {
		this.noteCardTo = noteCardTo;
	}

	public String getNoteCardFrom() {
		return noteCardFrom;
	}

	public void setNoteCardFrom(String noteCardFrom) {
		this.noteCardFrom = noteCardFrom;
	}

	public Double getOtherDiscount() {
		return otherDiscount;
	}

	public String getOuterOrderCode() {
		return outerOrderCode;
	}

	public String getPickShopId() {
		return pickShopId;
	}

	public String getPresentCards() {
		return presentCards;
	}

	public String getRefer() {
		return refer;
	}

	public Double getServiceFee() {
		return serviceFee;
	}

	public void setAnonymous(Boolean anonymous) {
		this.anonymous = anonymous;
	}

	public void setCardFeeDiscount(Double cardFeeDiscount) {
		this.cardFeeDiscount = cardFeeDiscount;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}

	public void setDeliveryAddress(AddressVO deliveryAddress) {
		this.deliveryAddress = deliveryAddress;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public void setDeliveryType(Integer deliveryType) {
		this.deliveryType = deliveryType;
	}

	public void setInnerRemark(String innerRemark) {
		this.innerRemark = innerRemark;
	}

	public void setItems(List<OrderCreateDetailVO> items) {
		this.items = items;
	}

	public void setLimitedDelivery(Boolean limitedDelivery) {
		this.limitedDelivery = limitedDelivery;
	}

	public void setLimitedHour(String limitedHour) {
		this.limitedHour = limitedHour;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public void setNoteCard(Integer noteCard) {
		this.noteCard = noteCard;
	}

	public void setNoteCardMessage(String noteCardMessage) {
		this.noteCardMessage = noteCardMessage;
	}

	public void setOtherDiscount(Double otherDiscount) {
		this.otherDiscount = otherDiscount;
	}

	public void setOuterOrderCode(String outerOrderCode) {
		this.outerOrderCode = outerOrderCode;
	}

	public void setPickShopId(String pickShopId) {
		this.pickShopId = pickShopId;
	}

	public void setPresentCards(String presentCards) {
		this.presentCards = presentCards;
	}

	public void setRefer(String refer) {
		this.refer = refer;
	}

	public void setServiceFee(Double serviceFee) {
		this.serviceFee = serviceFee;
	}

	public Integer getNeedInvoice() {
		return needInvoice;
	}

	public void setNeedInvoice(Integer needInvoice) {
		this.needInvoice = needInvoice;
	}

	public Integer getIsInvoiceInSamePackage() {
		return isInvoiceInSamePackage;
	}

	public void setIsInvoiceInSamePackage(Integer isInvoiceInSamePackage) {
		this.isInvoiceInSamePackage = isInvoiceInSamePackage;
	}

	public SoInvoiceInfoVO getSoInvoiceInfoVO() {
		return soInvoiceInfoVO;
	}

	public void setSoInvoiceInfoVO(SoInvoiceInfoVO soInvoiceInfoVO) {
		this.soInvoiceInfoVO = soInvoiceInfoVO;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	// public BigDecimal getCrossFree() {
	// return crossFree;
	// }
	//
	// public void setCrossFree(BigDecimal crossFree) {
	// this.crossFree = crossFree;
	// }

	public IdCardVO getIdCardVO() {
		return idCardVO;
	}

	public void setIdCardVO(IdCardVO idCardVO) {
		this.idCardVO = idCardVO;
	}

//	public String getBirthdayDiscountUse() {
//		return birthdayDiscountUse;
//	}
//
//	public void setBirthdayDiscountUse(String birthdayDiscountUse) {
//		this.birthdayDiscountUse = birthdayDiscountUse;
//	}

	// public List<Long> getPackIds() {
	// return packIds;
	// }
	//
	// public void setPackIds(List<Long> packIds) {
	// this.packIds = packIds;
	// }

	public List<CartProductPack> getPacks() {
		return packs;
	}

	public void setPacks(List<CartProductPack> packs) {
		this.packs = packs;
	}

	public BigDecimal getActualPayFee() {
		return actualPayFee;
	}

	public void setActualPayFee(BigDecimal actualPayFee) {
		this.actualPayFee = actualPayFee;
	}

	public PriceResult getPriceResult() {
		return priceResult;
	}

	public void setPriceResult(PriceResult priceResult) {
		this.priceResult = priceResult;
	}

//
//
//	public List<ServiceFeeStep> getServiceStep() {
//		return serviceStep;
//	}
//
//	public void setServiceStep(List<ServiceFeeStep> serviceStep) {
//		this.serviceStep = serviceStep;
//	}

	public CpsInfo getCpsInfo() {
		return cpsInfo;
	}

	public void setCpsInfo(CpsInfo cpsInfo) {
		this.cpsInfo = cpsInfo;
	}

	public BigDecimal getBirthdayDiscountAmount() {
		return birthdayDiscountAmount;
	}

	public void setBirthdayDiscountAmount(BigDecimal birthdayDiscountAmount) {
		this.birthdayDiscountAmount = birthdayDiscountAmount;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

//	public int getOrderType() {
//		return orderType;
//	}
//
//	public void setOrderType(int orderType) {
//		this.orderType = orderType;
//	}

	public String getWarehouseForSales() {
		return warehouseForSales;
	}

	public void setWarehouseForSales(String warehouseForSales) {
		this.warehouseForSales = warehouseForSales;
	}

	public int getStockDistinguish() {
		return stockDistinguish;
	}

	public void setStockDistinguish(int stockDistinguish) {
		this.stockDistinguish = stockDistinguish;
	}

	public List<OpSalesOrderGiftCardVO> getOpSalesOrderGiftCardVOs() {
		return opSalesOrderGiftCardVOs;
	}

	public void setOpSalesOrderGiftCardVOs(List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs) {
		this.opSalesOrderGiftCardVOs = opSalesOrderGiftCardVOs;
	}

	public Long getCreateOperatorId() {
		return createOperatorId;
	}

	public void setCreateOperatorId(Long createOperatorId) {
		this.createOperatorId = createOperatorId;
	}

	public String getCreateOperatorName() {
		return createOperatorName;
	}

	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}

	public Map<Long, List<CartProductPack>> getGiftPackMap() {
		return giftPackMap;
	}

	public void setGiftPackMap(Map<Long, List<CartProductPack>> giftPackMap) {
		this.giftPackMap = giftPackMap;
	}

//	public Map<Long, List<PrsCampaignVO>> getCampaignMap() {
//		return campaignMap;
//	}
//
//	public void setCampaignMap(Map<Long, List<PrsCampaignVO>> campaignMap) {
//		this.campaignMap = campaignMap;
//	}
//	

	public Map<Long, String> getAddiblePacks() {
		return addiblePacks;
	}

	public void setAddiblePacks(Map<Long, String> addiblePacks) {
		this.addiblePacks = addiblePacks;
	}



	public List<PrsSpvPriceStepVO> getSpvSteps() {
		return spvSteps;
	}

	public void setSpvSteps(List<PrsSpvPriceStepVO> spvSteps) {
		this.spvSteps = spvSteps;
	}



	public List<PrsPriceStepVO> getPriceStepVOs() {
		return priceStepVOs;
	}

	public void setPriceStepVOs(List<PrsPriceStepVO> priceStepVOs) {
		this.priceStepVOs = priceStepVOs;
	}



//	public Map<Long, Integer> getExchangeMap() {
//		return exchangeMap;
//	}
//
//	public void setExchangeMap(Map<Long, Integer> exchangeMap) {
//		this.exchangeMap = exchangeMap;
//	}



	public OrderBusinessType getOrderBusinessType() {
		return orderBusinessType;
	}

	public void setOrderBusinessType(OrderBusinessType orderBusinessType) {
		this.orderBusinessType = orderBusinessType;
	}



	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}



	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public SGroupbuyParterOccupyDTO getsGroupbuyParterOccupyDTO() {
		return sGroupbuyParterOccupyDTO;
	}

	public void setsGroupbuyParterOccupyDTO(SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO) {
		this.sGroupbuyParterOccupyDTO = sGroupbuyParterOccupyDTO;
	}

	public SGroupbuyOwnerOccupyDTO getsGroupbuyOwnerOccupyDTO() {
		return sGroupbuyOwnerOccupyDTO;
	}

	public void setsGroupbuyOwnerOccupyDTO(SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO) {
		this.sGroupbuyOwnerOccupyDTO = sGroupbuyOwnerOccupyDTO;
	}



	public boolean isGroupbuy() {
		return isGroupbuy;
	}

	public void setGroupbuy(boolean isGroupbuy) {
		this.isGroupbuy = isGroupbuy;
	}



	public Integer getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(Integer paymentType) {
		this.paymentType = paymentType;
	}
	
	public MarketVipVO getMarketVip() {
		return marketVip;
	}

	public void setMarketVip(MarketVipVO marketVip) {
		this.marketVip = marketVip;
	}

	public class MarketVipVO {
		
		/**
	     * VIP活动Id
	     */
	    private Integer activityId;
	    
	    /**
	     * VIP卡号
	     */
	    private String vipCardNo;
	    
	    /**
	     * VIP折扣
	     */
	    private BigDecimal vipDiscount;

		public Integer getActivityId() {
			return activityId;
		}

		public void setActivityId(Integer activityId) {
			this.activityId = activityId;
		}

		public String getVipCardNo() {
			return vipCardNo;
		}

		public void setVipCardNo(String vipCardNo) {
			this.vipCardNo = vipCardNo;
		}

		public BigDecimal getVipDiscount() {
			return vipDiscount;
		}

		public void setVipDiscount(BigDecimal vipDiscount) {
			this.vipDiscount = vipDiscount;
		}
		
	}



	public String getTbsClient() {
		return tbsClient;
	}

	public void setTbsClient(String tbsClient) {
		this.tbsClient = tbsClient;
	}

	public String getTbsUSource() {
		return tbsUSource;
	}

	public void setTbsUSource(String tbsUSource) {
		this.tbsUSource = tbsUSource;
	}

	public String getPlatForm() {
		return platForm;
	}

	public void setPlatForm(String platForm) {
		this.platForm = platForm;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public Map<String, String> getSkuWarehouseMap() {
		return skuWarehouseMap;
	}

	public void setSkuWarehouseMap(Map<String, String> skuWarehouseMap) {
		this.skuWarehouseMap = skuWarehouseMap;
	}

	public Map<String, SPresaleVO> getSkuPresaleWarehouseMap() {
		return skuPresaleWarehouseMap;
	}

	public void setSkuPresaleWarehouseMap(Map<String, SPresaleVO> skuPresaleWarehouseMap) {
		this.skuPresaleWarehouseMap = skuPresaleWarehouseMap;
	}

	public Map<String, PrsSkuPriceStepVO> getSkuPriceStepMap() {
		return skuPriceStepMap;
	}

	public void setSkuPriceStepMap(Map<String, PrsSkuPriceStepVO> skuPriceStepMap) {
		this.skuPriceStepMap = skuPriceStepMap;
	}

	public BigDecimal getActualPayPoint() {
		return actualPayPoint;
	}

	public void setActualPayPoint(BigDecimal actualPayPoint) {
		this.actualPayPoint = actualPayPoint;
	}

	public class InterestsVO {
		/**
		 * 权益id
		 */
		private Integer id;
		/**
		 * 权益类型
		 */
		private String type;

		public Integer getId() {
			return id;
		}

		public void setId(Integer id) {
			this.id = id;
		}

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

	}
	
	
}
