package com.thebeastshop.pegasus.channelservice.vo.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;

public class FlowerMonthOrderVO {

	private String channelCode;
	// 优惠券
	private String couponCode;
	// 购买者id
	private Long memberId;
	// 收货人信息
	private Long addressId;
	// 商品包
	private List<CartProductPack> packs = new ArrayList<>();

	// 买家备注信息
	private String note;
	// 卡片
	private Integer noteCard;
	// 卡片内容
	private String noteCardMessage;
	// 卡片抬头
	private String noteCardTo;
	// 卡片落款
	private String noteCardFrom;
	// 折扣费用
	private BigDecimal otherDiscount;
	// 服务费
	private BigDecimal serviceFee;
	// 价格计算（商品相关）
	private PriceResult priceResult;
	// 服务费计算
	private Collection<ServiceFeeStep> serviceStep;

	// 投放渠道
	private String utmSource;

	// 下载来源
	private String downloadSource;
	/**
	 * 是否使用生日折扣
	 */
	private String birthdayDiscountUse;
	/**
	 * 支付金额
	 */
	private BigDecimal actualPayFee;

	/**
	 * 是否匿名0:否，1：是
	 */
	private int isAnonymous = 0;

	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	
	/**
	 * 礼品卡
	 */
	private List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs;

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	public String getBirthdayDiscountUse() {
		return birthdayDiscountUse;
	}

	public void setBirthdayDiscountUse(String birthdayDiscountUse) {
		this.birthdayDiscountUse = birthdayDiscountUse;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public PriceResult getPriceResult() {
		return priceResult;
	}

	public void setPriceResult(PriceResult priceResult) {
		this.priceResult = priceResult;
	}

	public Collection<ServiceFeeStep> getServiceStep() {
		return serviceStep;
	}

	public void setServiceStep(Collection<ServiceFeeStep> serviceStep) {
		this.serviceStep = serviceStep;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public Long getMemberId() {
		return memberId;
	}

	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getNoteCard() {
		return noteCard;
	}

	public void setNoteCard(Integer noteCard) {
		this.noteCard = noteCard;
	}

	public String getNoteCardMessage() {
		return noteCardMessage;
	}

	public void setNoteCardMessage(String noteCardMessage) {
		this.noteCardMessage = noteCardMessage;
	}

	public String getNoteCardTo() {
		return noteCardTo;
	}

	public void setNoteCardTo(String noteCardTo) {
		this.noteCardTo = noteCardTo;
	}

	public String getNoteCardFrom() {
		return noteCardFrom;
	}

	public void setNoteCardFrom(String noteCardFrom) {
		this.noteCardFrom = noteCardFrom;
	}

	public BigDecimal getOtherDiscount() {
		return otherDiscount;
	}

	public void setOtherDiscount(BigDecimal otherDiscount) {
		this.otherDiscount = otherDiscount;
	}

	public BigDecimal getServiceFee() {
		return serviceFee;
	}

	public void setServiceFee(BigDecimal serviceFee) {
		this.serviceFee = serviceFee;
	}

	public BigDecimal getActualPayFee() {
		return actualPayFee;
	}

	public void setActualPayFee(BigDecimal actualPayFee) {
		this.actualPayFee = actualPayFee;
	}

	public Long getAddressId() {
		return addressId;
	}

	public void setAddressId(Long addressId) {
		this.addressId = addressId;
	}

	public List<CartProductPack> getPacks() {
		return packs;
	}

	public void setPacks(List<CartProductPack> packs) {
		this.packs = packs;
	}

	public int getIsAnonymous() {
		return isAnonymous;
	}

	public void setIsAnonymous(int isAnonymous) {
		this.isAnonymous = isAnonymous;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public List<OpSalesOrderGiftCardVO> getOpSalesOrderGiftCardVOs() {
		return opSalesOrderGiftCardVOs;
	}

	public void setOpSalesOrderGiftCardVOs(
			List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs) {
		this.opSalesOrderGiftCardVOs = opSalesOrderGiftCardVOs;
	}

}
