package com.thebeastshop.pegasus.channelservice.vo.member;

import java.io.Serializable;

import com.thebeastshop.common.enums.MemberLevelEnum;

public class MemberQueryVO implements Serializable{
	private static final long serialVersionUID = 1L;
	// 用户头像链接
	private String avatar;
	// 用户星座
	private Integer constellation;
	// 用户等级
	private Integer custLevel;
	// 用户学历
	private Integer degree;
	// 用户邮箱
	private String email;
	// 用户类型.手机用户、邮箱用户
	private Integer identityType;
	// 用户固定电话
	private String magentoPhone;
	//用户code
	private String memberCode;
	// 用户id
	private Long memberId;
	//用户等级描述
	private String memberLevelDesc;
	// 用户手机
	private String mobile;
	//用户昵称
    private String nickName;
	// 用户密码
	private String password;
	// 用户积分
	private Double point;
    // 历史积分
    private Double historyPoint;
	// 用户职业
	private String profession;

	private MemberProfileVO profile;
	// 用户微博
	private String weibo;
	// 用户微信
	private String weixin;
	public String getAvatar() {
		return avatar;
	}
	public Integer getConstellation() {
		return constellation;
	}
	public Integer getCustLevel() {
		return custLevel;
	}
	
	public Integer getDegree() {
		return degree;
	}
	public String getEmail() {
		return email;
	}
	public Integer getIdentityType() {
		return identityType;
	}
	public String getMagentoPhone() {
		return magentoPhone;
	}
	public String getMemberCode() {
		return memberCode;
	}
	public Long getMemberId() {
		return memberId;
	}
	public String getMemberLevelDesc() {
		if(custLevel==MemberLevelEnum.NORMAL.getCode()){
			memberLevelDesc=MemberLevelEnum.NORMAL.getName();
		}else if(custLevel==MemberLevelEnum.VIP.getCode()){
			memberLevelDesc=MemberLevelEnum.VIP.getName();
		}else if(custLevel==MemberLevelEnum.VIP2.getCode()){
			memberLevelDesc=MemberLevelEnum.VIP2.getName();
		}else if(custLevel==MemberLevelEnum.VIP3.getCode()){
			memberLevelDesc=MemberLevelEnum.VIP3.getName();
		}else if(custLevel==MemberLevelEnum.VIP4.getCode()){
			memberLevelDesc=MemberLevelEnum.VIP4.getName();
		}
		
		return memberLevelDesc;
	}
	public String getMobile() {
		return mobile;
	}
	public String getNickName() {
		return nickName;
	}
	public String getPassword() {
		return password;
	}
	public Double getPoint() {
		return point;
	}
	public String getProfession() {
		return profession;
	}
	public MemberProfileVO getProfile() {
		return profile;
	}
	public String getWeibo() {
		return weibo;
	}
	public String getWeixin() {
		return weixin;
	}
	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}
	
	public void setConstellation(Integer constellation) {
		this.constellation = constellation;
	}
	public void setCustLevel(Integer custLevel) {
		this.custLevel = custLevel;
	}
	public void setDegree(Integer degree) {
		this.degree = degree;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public void setIdentityType(Integer identityType) {
		this.identityType = identityType;
	}
	public void setMagentoPhone(String magentoPhone) {
		this.magentoPhone = magentoPhone;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}
	public void setMemberLevelDesc(String memberLevelDesc) {
		this.memberLevelDesc = memberLevelDesc;
	}
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	public void setNickName(String nickName) {
		this.nickName = nickName;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public void setPoint(Double point) {
		this.point = point;
	}

	public void setProfession(String profession) {
		this.profession = profession;
	}

	public void setProfile(MemberProfileVO profile) {
		this.profile = profile;
	}

	public void setWeibo(String weibo) {
		this.weibo = weibo;
	}

	public void setWeixin(String weixin) {
		this.weixin = weixin;
	}
	public Double getHistoryPoint() {
		return historyPoint;
	}
	public void setHistoryPoint(Double historyPoint) {
		this.historyPoint = historyPoint;
	}

}
