package com.thebeastshop.pegasus.channelservice.vo.item;


import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *@author gongjun
 * @since 2016-10-24
 */
public class SpvItemVO implements Serializable {

    /**
     * ID
     */
    private Long id;
    private Long productId;


    private Integer canSale;
    private Integer canSee;

    private BigDecimal salesPrice;
    /**
     * 原价
     */
    private BigDecimal originalPrice;
    /**
     * PRODUCT编码
     */
    private String productCode;
    /**
     * PRODUCT名称
     */
    private String productName;

    /**
     * 最小起售数
     */
    private Integer minAmount;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * SPV对应属性值JSON字符串{[100,101],[200,201], [300, 301]}
     */
    private String attrJSONText;

    /**
     *  SPV对应属性值文本Map [{AttrName -> AttrValueText}]
     */
    private List<Map<String, String>> attrValueTextMap;

    /**
     * 折扣价格
     */
    private BigDecimal discountPrice;

    /**
     * SKU CODE
     */
    private String skuCode;

    private String skuName;

    /**
     * 单品SKU
     */
    private SkuItemVO skuVO;

    /**
     * SKU组合列表
     */
    private List<SkuCombinationItemVO> skuCombinationList;
    /**
     * SPV对应属性值 [AttrId -> AttrValueId]
     */
    private Map<Long, Long> attrValues;


    /**
     * spv的库存
     */
    private Integer stock;

    /**
     * 库存预警
     */
    private String stockWarn;
    
    /**
     * 预告活动价格
     */
    private BigDecimal advancePrice;
    
    private AdvanceVO advanceVO;
    /**抢购活动*/
    private List<SnapActivityVO> snapActivityVOs = new ArrayList<>();

    /**
     * 会员折扣/生日折扣 不可用原因
     */
    private String forBidVipDisReson;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Integer getCanSale() {
        return canSale;
    }

    public void setCanSale(Integer canSale) {
        this.canSale = canSale;
    }

    public Integer getCanSee() {
        return canSee;
    }

    public void setCanSee(Integer canSee) {
        this.canSee = canSee;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public String getAttrJSONText() {
        return attrJSONText;
    }

    public void setAttrJSONText(String attrJSONText) {
        this.attrJSONText = attrJSONText;
    }

    public List<Map<String, String>> getAttrValueTextMap() {
        return attrValueTextMap;
    }

    public void setAttrValueTextMap(List<Map<String, String>> attrValueTextMap) {
        this.attrValueTextMap = attrValueTextMap;
    }

    public Map<Long, Long> getAttrValues() {
        return attrValues;
    }

    public void setAttrValues(Map<Long, Long> attrValues) {
        this.attrValues = attrValues;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public SkuItemVO getSkuVO() {
        return skuVO;
    }

    public void setSkuVO(SkuItemVO skuVO) {
        this.skuVO = skuVO;
    }

    public List<SkuCombinationItemVO> getSkuCombinationList() {
        return skuCombinationList;
    }

    public void setSkuCombinationList(List<SkuCombinationItemVO> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public Integer getStock(){
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public String getStockWarn() {
        return stockWarn;
    }

    public void setStockWarn(String stockWarn) {
        this.stockWarn = stockWarn;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public BigDecimal getAdvancePrice() {
		return advancePrice;
	}

	public void setAdvancePrice(BigDecimal advancePrice) {
		this.advancePrice = advancePrice;
	}

	public AdvanceVO getAdvanceVO() {
		return advanceVO;
	}

	public void setAdvanceVO(AdvanceVO advanceVO) {
		this.advanceVO = advanceVO;
	}

    public List<SnapActivityVO> getSnapActivityVOs() {
        return snapActivityVOs;
    }

    public void setSnapActivityVOs(List<SnapActivityVO> snapActivityVOs) {
        this.snapActivityVOs = snapActivityVOs;
    }

    public BigDecimal getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(BigDecimal originalPrice) {
		this.originalPrice = originalPrice;
	}

    public String getForBidVipDisReson() {
        return forBidVipDisReson;
    }

    public void setForBidVipDisReson(String forBidVipDisReson) {
        this.forBidVipDisReson = forBidVipDisReson;
    }

    @Override
    public String toString() {
        return new org.apache.commons.lang3.builder.ToStringBuilder(this)
                .append("id", id)
                .append("productId", productId)
                .append("canSale", canSale)
                .append("canSee", canSee)
                .append("salesPrice", salesPrice)
                .append("productCode", productCode)
                .append("productName", productName)
                .append("minAmount", minAmount)
                .append("costPrice", costPrice)
                .append("combined", combined)
                .append("attrJSONText", attrJSONText)
                .append("attrValueTextMap", attrValueTextMap)
                .append("discountPrice", discountPrice)
                .append("skuCode", skuCode)
                .append("skuName", skuName)
                .append("skuVO", skuVO)
                .append("skuCombinationList", skuCombinationList)
                .append("attrValues", attrValues)
                .append("stock", stock)
                .append("stockWarn", stockWarn)
                .append("snapActivityVOs",snapActivityVOs)
                .append("forBidVipDisReson", forBidVipDisReson)
                .toString();
    }
}
