package com.thebeastshop.pegasus.channelservice.vo.item;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsTagVO;
import com.thebeastshop.support.vo.product.PrevueVO;

public class ProductItemVO implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String id;
	
    /**
     * 列表标签
     */
    private List<String> listIcon;

    /**
     * prodCode
     */
    private String code;

	/**
	 * 商品属性列表
	 */
	private List<AttributeVO> attributeList;

    /**
     * 数量
     */
	private int quantity;
    /**
     * 品牌Id
     */
	private Long brandId;
    /**
     * 品牌名称
     */
	private String brandName;
    /**
     * 中文名称
     */
	private String nameZh;
    /**
     * 产品名
     */
    private String name;
    /**
     * 一句话描述
     */
	private String shortDescription;
    /**
     * 折价
     */
	private BigDecimal discountPrice;
	
    /**
     * 是否支持VIP折扣，1是0否*/

    private Integer allowVipDiscount;
    /**
     * 售价
     */
	private BigDecimal price;
    /**
     * 商品活动
     */
    private List<ProductCampaignVO> productCampaignVOs;
    /**
     * 列表图
     */
	private String smallImgUrl;
	/**
	 * 判断是否是app专享商品
	 */
	private Boolean isAppProduct;
	/**
	 * 
	 * @return
	 */
	private List<SkuItemVO> skuItems=new ArrayList<>();

	/**
	 * 是否组合
	 */
	private Boolean combined;

	/**
	 * SPV列表
	 */
	private List<SpvItemVO> spvItems = new ArrayList<>();

	/**
	 * 是否上架：0否，1是
	 */
	private int isShelf;
	
	/**
	 * 是否可售：0否，1是
	 */
	private int isSale;

    /**
     * 详情标签
     */
    private List<String> detailIcon=new ArrayList<>();

    /**
     * 详情图片
     */
    private List<String> detailImageList=new ArrayList<>();
    /**
     * 单张大图
     */
    private String bigImgUrl;
    /**
     * 
     */
    private String picThumb;
    /**
     * 跨境购标注 0普通１跨境购
     */
    private int crossBorderFlag;
    
    /**
     * 产地
     */
    private String brandCountryName;
    
    /**
     * 图标显示内容
     */
    private List<PsTagVO> tagList=new ArrayList<>();
    /**
     * 快递类型 1店送2联邦3顺丰空运4顺丰陆运5圆通6德邦7海淘顺丰 8自送
     */
    private int expressType;
    
    List<PsDynmContentVO> itemDescs=new ArrayList<>();
	
    /**
     * SKU分类描述
     */
    private String skuCategoryDesc;
    
    
    private AdvanceVO advanceVO;
    
	/**
	 * 抢购商品标识：0否，1是
	 */
	private int isPanicBuy=0;
	
    private Integer isMonthSend=0;//月送鲜花
    
	private Boolean foretell = false;// 预告商品
	
	/**
	 * 商品信息
	 */
	private PrevueVO prevue;
	
    /**
     * 虚拟商品，0不是，1是
     */
    private Integer whetherVirtual;

    /**
     * 物流运输，0不是，1是
     */
    private Integer whetherLogistics; 
    
    /**
     * 活动配制文案
     */
    private String activityDesc;

	/**
	 * 库存预警
	 */
	private String stockWarn;
    
	public int getIsShelf() {
		return isShelf;
	}
	public void setIsShelf(int isShelf) {
		this.isShelf = isShelf;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	public List<String> getListIcon() {
		return listIcon;
	}
	public void setListIcon(List<String> listIcon) {
		this.listIcon = listIcon;
	}

	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}

	public List<AttributeVO> getAttributeList() {
		return attributeList;
	}

	public void setAttributeList(List<AttributeVO> attributeList) {
		this.attributeList = attributeList;
	}

	public int getQuantity() {
		return quantity;
	}
	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}
	
	public String getNameZh() {
		return nameZh;
	}
	public void setNameZh(String nameZh) {
		this.nameZh = nameZh;
	}

	public Long getBrandId() {
		return brandId;
	}
	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}
	public String getBrandName() {
		return brandName;
	}
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}
	
	public String getShortDescription() {
		return shortDescription;
	}
	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}
	public BigDecimal getDiscountPrice() {
		return discountPrice;
	}
	public void setDiscountPrice(BigDecimal discountPrice) {
		this.discountPrice = discountPrice;
	}
	public BigDecimal getPrice() {
		return price;
	}
	public void setPrice(BigDecimal price) {
		this.price = price;
	}
	public List<ProductCampaignVO> getProductCampaignVOs() {
		return productCampaignVOs;
	}
	public void setProductCampaignVOs(List<ProductCampaignVO> productCampaignVOs) {
		this.productCampaignVOs = productCampaignVOs;
	}
	public String getSmallImgUrl() {
		return smallImgUrl;
	}
	public void setSmallImgUrl(String smallImgUrl) {
		this.smallImgUrl = smallImgUrl;
	}
	public List<SkuItemVO> getSkuItems() {
		return skuItems;
	}
	public void setSkuItems(List<SkuItemVO> skuItems) {
		this.skuItems = skuItems;
	}
	public List<SpvItemVO> getSpvItems() {
		return spvItems;
	}
	public void setSpvItems(List<SpvItemVO> spvItems) {
		this.spvItems = spvItems;
	}
	public int getIsSale() {
		return isSale;
	}
	public void setIsSale(int isSale) {
		this.isSale = isSale;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public List<String> getDetailIcon() {
		return detailIcon;
	}
	public void setDetailIcon(List<String> detailIcon) {
		this.detailIcon = detailIcon;
	}
	public List<String> getDetailImageList() {
		return detailImageList;
	}
	public void setDetailImageList(List<String> detailImageList) {
		this.detailImageList = detailImageList;
	}
	public String getBigImgUrl() {
		return bigImgUrl;
	}
	public void setBigImgUrl(String bigImgUrl) {
		this.bigImgUrl = bigImgUrl;
	}
	public int getCrossBorderFlag() {
		return crossBorderFlag;
	}
	public void setCrossBorderFlag(int crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}
	public String getBrandCountryName() {
		return brandCountryName;
	}
	public void setBrandCountryName(String brandCountryName) {
		this.brandCountryName = brandCountryName;
	}
	public List<PsTagVO> getTagList() {
		return tagList;
	}
	public void setTagList(List<PsTagVO> tagList) {
		this.tagList = tagList;
	}
	public int getExpressType() {
		return expressType;
	}
	public void setExpressType(int expressType) {
		this.expressType = expressType;
	}
	public List<PsDynmContentVO> getItemDescs() {
		return itemDescs;
	}
	public void setItemDescs(List<PsDynmContentVO> itemDescs) {
		this.itemDescs = itemDescs;
	}
	public String getSkuCategoryDesc() {
		return skuCategoryDesc;
	}
	public void setSkuCategoryDesc(String skuCategoryDesc) {
		this.skuCategoryDesc = skuCategoryDesc;
	}
	public String getPicThumb() {
		return picThumb;
	}
	public void setPicThumb(String picThumb) {
		this.picThumb = picThumb;
	}

	public Boolean getCombined() {
		return combined;
	}

	public void setCombined(Boolean combined) {
		this.combined = combined;
	}

	public Boolean getIsAppProduct() {
		return isAppProduct;
	}

	public void setIsAppProduct(Boolean isAppProduct) {
		this.isAppProduct = isAppProduct;
	}

	public Integer getAllowVipDiscount() {
		return allowVipDiscount;
	}
	public void setAllowVipDiscount(Integer allowVipDiscount) {
		this.allowVipDiscount = allowVipDiscount;
	}
	
	
	public int getIsPanicBuy() {
		return isPanicBuy;
	}
	public void setIsPanicBuy(int isPanicBuy) {
		this.isPanicBuy = isPanicBuy;
	}
	public AdvanceVO getAdvanceVO() {
		return advanceVO;
	}
	public void setAdvanceVO(AdvanceVO advanceVO) {
		this.advanceVO = advanceVO;
	}
	
	
	public Integer getIsMonthSend() {
		return isMonthSend;
	}
	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}
	
	public Boolean getForetell() {
		return foretell;
	}
	public void setForetell(Boolean foretell) {
		this.foretell = foretell;
	}

	public PrevueVO getPrevue() {
		return prevue;
	}
	public void setPrevue(PrevueVO prevue) {
		this.prevue = prevue;
	}
	
	
	public Integer getWhetherVirtual() {
		return whetherVirtual;
	}
	public void setWhetherVirtual(Integer whetherVirtual) {
		this.whetherVirtual = whetherVirtual;
	}
	public Integer getWhetherLogistics() {
		return whetherLogistics;
	}
	public void setWhetherLogistics(Integer whetherLogistics) {
		this.whetherLogistics = whetherLogistics;
	}
	
	public String getActivityDesc() {
		return activityDesc;
	}
	public void setActivityDesc(String activityDesc) {
		this.activityDesc = activityDesc;
	}

	public String getStockWarn() {
		return stockWarn;
	}

	public void setStockWarn(String stockWarn) {
		this.stockWarn = stockWarn;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.append("id", id)
				.append("listIcon", listIcon)
				.append("code", code)
				.append("attributeList", attributeList)
				.append("quantity", quantity)
				.append("brandId", brandId)
				.append("brandName", brandName)
				.append("nameZh", nameZh)
				.append("name", name)
				.append("shortDescription", shortDescription)
				.append("discountPrice", discountPrice)
				.append("price", price)
				.append("productCampaignVOs", productCampaignVOs)
				.append("smallImgUrl", smallImgUrl)
				.append("isAppProduct", isAppProduct)
				.append("skuItems", skuItems)
				.append("combined", combined)
				.append("spvItems", spvItems)
				.append("isShelf", isShelf)
				.append("isSale", isSale)
				.append("detailIcon", detailIcon)
				.append("detailImageList", detailImageList)
				.append("bigImgUrl", bigImgUrl)
				.append("picThumb", picThumb)
				.append("crossBorderFlag", crossBorderFlag)
				.append("brandCountryName", brandCountryName)
				.append("tagList", tagList)
				.append("expressType", expressType)
				.append("itemDescs", itemDescs)
				.append("skuCategoryDesc", skuCategoryDesc)
				.append("stockWarn", stockWarn)
				.toString();
	}
}
