package com.thebeastshop.pegasus.channelservice.vo.item;

import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 商品属性VO
 * @author gongjun
 * @since 2016-10-13
 */
public class AttributeVO implements Serializable {

    private Long id;




    /**
     * 是否为组合属性
     */
    private Boolean combined;

    /**
     * 组名称
     */
    private String groupName;

    /**
     * 名称
     */
    private String name;

    /**
     * 属性值列表
     */
    private List<AttributeValueVO> attributeValueList;

    /**
     * 属性值Map {属性值文本 -> AttributeValueVO}
     */
    private Map<String, AttributeValueVO> attributeValueMap = new LinkedHashMap<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }



    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AttributeValueVO> getAttributeValueList() {
        return attributeValueList;
    }

    public void setAttributeValueList(List<AttributeValueVO> attributeValueList) {
        this.attributeValueList = attributeValueList;
    }

    public Map<String, AttributeValueVO> getAttributeValueMap() {
        return attributeValueMap;
    }

    public void setAttributeValueMap(Map<String, AttributeValueVO> attributeValueMap) {
        this.attributeValueMap = attributeValueMap;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", id)
                .append("combined", combined)
                .append("groupName", groupName)
                .append("name", name)
                .append("attributeValueList", attributeValueList)
                .append("attributeValueMap", attributeValueMap)
                .toString();
    }
}
