package com.thebeastshop.pegasus.channelservice.util;

import com.google.common.collect.Lists;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.price.vo.PrsSpvPriceResultVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PriceResultUtils {

  /**
   * 获取商品的新客标签
   * @param priceResult
   * @return
   */
  public static Boolean getProductNewcomerTag(PrsProductPriceResultVO priceResult) {
    if (null != priceResult && CollectionUtils.isNotEmpty(priceResult.getSpvPriceResultVOs())) {
      for (PrsSpvPriceResultVO spvPriceResultVO : priceResult.getSpvPriceResultVOs()) {
        for (PrsSpvPriceStepVO prsPriceStep : spvPriceResultVO.getSpvPriceStepVOS()) {
          if (PrsPriceTypeEnum.FISH_MAN.equals(prsPriceStep.getPriceType())) {
            return Boolean.TRUE;
          }
        }
      }
    }
    return Boolean.FALSE;
  }


  /**
   * 获取商品所有spv的的新客标签
   *
   * @param priceResult
   * @return
   */
  public static Map<Long, Boolean> getSpvNewcomerTagMap4PriceResult(PrsProductPriceResultVO priceResult) {

    Map<Long, Boolean> spvNewcomerTagMap = new HashMap<Long, Boolean>();
    Map<Long, List<PrsPriceTypeEnum>> spvPriceTypeMap = new HashMap<Long, List<PrsPriceTypeEnum>>();
    if (null != priceResult && CollectionUtils.isNotEmpty(priceResult.getSpvPriceResultVOs())) {
      for (PrsSpvPriceResultVO spvPriceResultVO : priceResult.getSpvPriceResultVOs()) {
        Long spvId = spvPriceResultVO.getSpvId();
        for (PrsSpvPriceStepVO prsPriceStep : spvPriceResultVO.getSpvPriceStepVOS()) {
          if (spvPriceTypeMap.containsKey(spvId)) {
            spvPriceTypeMap.get(spvId).add(prsPriceStep.getPriceType());
          } else {
            spvPriceTypeMap.put(spvId, Lists.newArrayList(prsPriceStep.getPriceType()));
          }
        }
      }
    }

    for (Map.Entry<Long, List<PrsPriceTypeEnum>> entry : spvPriceTypeMap.entrySet()) {
      spvNewcomerTagMap.put(entry.getKey(), entry.getValue().contains(PrsPriceTypeEnum.FISH_MAN));
    }
    return spvNewcomerTagMap;
  }
}
