package com.thebeastshop.pegasus.channelservice.util;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.thebeastshop.support.util.mobile.MobileCode;

/**
 * 手机号处理工具
 * 
 * @author Paul-xiong
 *
 */
public class MobileUtil {
	public static final String SEPARATOR = "-";

	/**
	 * 获取手机号区号
	 * 
	 * @param mobileWithCode
	 *            带区号的手机号
	 */
	public static String getMobileCode(String mobileWithCode) {
		String[] mobileAndCode = mobileWithCode.split(SEPARATOR);
		String mobileCode = mobileAndCode.length >= 2 ? mobileAndCode[0] : MobileCode.CHINA.getName();
		return mobileCode;
	}

	/**
	 * 获取手机号
	 * 
	 * @param mobileWithCode
	 *            带区号的手机号
	 * @return
	 */
	public static String getMobile(String mobileWithCode) {
		String[] mobileAndCode = mobileWithCode.split(SEPARATOR);
		String mobile = mobileAndCode.length >= 2 ? mobileAndCode[1] : mobileAndCode[0];
		return mobile;
	}

	/**
	 * 手机号的判断  限制 11位 和开头    13，14，15，16，18，17，19等
	 * @param phone
	 * @return
	 */
	public static  boolean isValidPhoneNumber(String phone) {
		Pattern p = Pattern.compile("^[1][3456789][0-9]{9}$");
		Matcher m = p.matcher(phone);
		return m.matches();
	}
}
