package com.thebeastshop.pegasus.channelservice.util;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.enums.MemberTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author feiLong.gao
 * @date 2019/5/8
 */
public class CampaignUtils {


    /**
     * 获取活动列表指定折扣类型的活动
     *
     * @param camps
     * @param discountType
     * @return
     */
    public static PsCampaignVO getCampaignByDiscountType(List<PsCampaignVO> camps, DiscountTypeEnum discountType) {
        if (CollectionUtils.isNotEmpty(camps)) {
            for (PsCampaignVO camp : camps) {
                if (discountType.getId().equals(camp.getDiscountTypeId())) {
                    return camp;
                }
            }
        }
        return null;
    }


    /**
     * 获取活动列表指定折扣类型的活动
     *
     * @param camps
     * @param discountType
     * @return
     */
    public static List<PsCampaignVO> getCampaignsByDiscountType(List<PsCampaignVO> camps, DiscountTypeEnum discountType) {
        List<PsCampaignVO> result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(camps)) {
            for (PsCampaignVO camp : camps) {
                if (discountType.getId().equals(camp.getDiscountTypeId())) {
                    result.add(camp);
                }
            }
        }
        return result;
    }

    /**
     * 校验活动类型
     *
     * @param camp
     * @param discountType
     * @return
     */
    public static Boolean checkCampaignDiscountType(PsCampaignVO camp, DiscountTypeEnum discountType) {
        return discountType.getId().equals(camp.getDiscountTypeId());
    }


    /**
     * 校验活动列表是否包含指定折扣类型
     *
     * @param camps
     * @param discountType
     * @return
     */
    public static Boolean checkCampaignInDiscountType(List<PsCampaignVO> camps, DiscountTypeEnum discountType) {
        return null != getCampaignByDiscountType(camps, discountType);
    }




    /* *****************************************************************************************************
     * ****************新人专享活动
     * *****************************************************************************************************/

    /**
     * 获取新人专享活动信息
     *
     * @param camps
     * @return
     */
    public static PsCampaignVO getNewMemberCampaign(List<PsCampaignVO> camps) {
        if (CollectionUtils.isNotEmpty(camps)) {
            for (PsCampaignVO camp : camps) {
                if (isNewMemberCampaign(camp)) {
                    return camp;
                }
            }
        }
        return null;
    }

    /**
     * 获取非新人专享价格活动
     *
     * @param camps
     * @return
     */
    public static PsCampaignVO getNotNewMemberPriceDiscountCampaign(List<PsCampaignVO> camps) {
        List<PsCampaignVO> priceDiscountCamps = getCampaignsByDiscountType(camps,DiscountTypeEnum.PRICE_DISCOUNT);
        if (CollectionUtils.isNotEmpty(priceDiscountCamps)) {
            for (PsCampaignVO camp : priceDiscountCamps) {
                if (!isNewMemberCampaign(camp)) {
                    return camp;
                }
            }
        }
        return null;
    }


    public static Boolean isNewMemberCampaign(PsCampaignVO camp) {
        if (DiscountTypeEnum.PRICE_DISCOUNT.getId().equals(camp.getDiscountTypeId()) && MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(camp.getMemberType())) {
            return true;
        }
        return false;
    }


}
