package com.thebeastshop.pegasus.channelservice.service.smartpos.impl;

import static com.thebeastshop.support.enums.PaymentType.ALIPAY;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.ComOrderAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartCommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.coupon.CouponAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.SnapshotAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.service.smartpos.SmartPosService;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.exception.OperationException;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsCartSettleLabelVO;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderCardType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.cart.SmartPosPreviewVO;
import com.thebeastshop.support.vo.order.OrderDetailVO;

/**
 * Created by GFL on 2017/10/13.
 */
@Service
public class SmartPosServiceImpl implements SmartPosService {

	private static Logger logger = LoggerFactory.getLogger(SmartPosService.class);

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private CouponAdapter couponAdapter;

	@Autowired
	private ComOrderAdapter comOrderAdapter;

	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private SnapshotAdapter snapshotAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private CartCommonAdapter cartCommonAdapter;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private CartPriceAdapter cartPriceAdapter;

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Override
	public SmartPosPreviewVO preview(List<RequestPack> requestPacks, MemberVO member, OpChannelVO channel,
			AccessWayEnum accessWay) {

		SmartPosPreviewVO result = new SmartPosPreviewVO();
		// 商品包加载价格和商品数据
		List<CartProductPack> packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks, accessWay,
				member, channel.getCode());

		// 获取默认可用优惠券
		Long couponId = couponAdapter.getDefaultUsableCouponId(packs, member, accessWay, channel);

		PrsPacksPriceResultVO priceResult = prsPriceService
				.calculatePrs4PreviewOrder(this.getPriceRequest(member, packs, accessWay, channel, couponId));

		return this.buildPreviewCardResult(priceResult, channel, member, packs, accessWay);
		// // 设置支付金额
		// result.setPrice(priceResult.getFinalTotalPrice());
		// // 设置价格步骤
		// Collection<OrderDetailVO.PriceStepVO> priceSteps =
		// priceAdapter.getPriceSteps(priceResult, member.getMemberLevelDesc());
		// result.setPriceSteps(priceSteps);
		//
		// // 设置商品包信息 包括 标签 赠品 ...
		// // TODO 暂时无需处理标签和赠品
		// Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new
		// HashMap<Long, List<PrsCartSettleLabelVO>>();
		// Map<PsSpvVO, List<Label>> spvLabelMap = new HashMap<>();
		// Map<String, Date> spvPresaleDateMap = Maps.newHashMap();
		// Map<Long, List<CartProductPackVO>> giftSinglePackMaps = new
		// HashMap<>();
		// List<CartProductPackVO> resultPacks =
		// priceAdapter.getCartProductPackList(packs, member, channel, true,
		// true,
		// true, accessWay, false, spvPresaleDateMap, null, giftSinglePackMaps,
		// priceResult.getSpvPriceMap(), singleLabelMap, true, spvLabelMap);
		//
		// resetSmartPosStock(packs, resultPacks);
		//
		// result.setPacks(resultPacks);
		// return result;
	}

	/**
	 * 重置智能收银机spv库存数据
	 *
	 * @param packs
	 * @param resultPacks
	 */
	private void resetSmartPosStock(List<CartProductPack> packs, List<CartProductPackVO> resultPacks) {
		Map<Long, Integer> spvStock = new HashMap();
		for (CartProductPack pack : packs) {
			spvStock.put(pack.getSpvId(), pack.getSpv().getPsStockVO().getCanUseQuantity());
		}
		// 智能收银库存修正
		for (CartProductPackVO packVO : resultPacks) {
			packVO.getSpv().setLeft(spvStock.get(packVO.getSpv().getId()));
		}
	}

	@Override
	public String confirm(BigDecimal price, List<RequestPack> requestPacks, MemberVO member, OpChannelVO channel,
			AccessWayEnum accessWay, String deviceId, String downloadSource, String client, String uSource,
			String platform) {

		OrderCreateVO oldOrderCreate = new OrderCreateVO();

		// 商品包加载价格和商品详情
		List<CartProductPack> packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks, accessWay,
				member, channel.getCode());

		// 获取默认可用优惠券
		Long couponId = couponAdapter.getDefaultUsableCouponId(packs, member, accessWay, channel);
		if (!NumberUtil.isNullOrZero(couponId)) {
			oldOrderCreate.setCouponCode(couponId.toString());
		}
		PrsCalPackDto dto = getPriceRequest(member, packs, accessWay, channel, couponId);

		// 校验支付价格是否正确
		PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4SubmitOrder(dto);

		// 应付金额
		BigDecimal needPayPrice = priceResult.getFinalTotalPrice();
		if (price.subtract(needPayPrice).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
			throw new ChannelException(400, "支付金额有误：应付金额" + needPayPrice);
		}
		// 刷新活动后价格
		Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
		for (CartProductPack pack : packs) {
			pack.getSpv().setDiscountPrice(spvMap.get(pack.getSpvId()));
		}
		// 设置商品包[主品包、赠品包、换购包]
		buildOrderCreatePacks(oldOrderCreate, packs, priceResult, channel, member);
		// oldOrderCreate.setPacks(packs);
		// oldOrderCreate.setPriceResult(priceResult); // 价格计算结果
		oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
		oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());
		//oldOrderCreate.setServiceStep(priceAdapter.setServiceStep(priceResult.getPriceStepVOs()));

		oldOrderCreate.setActualPayFee(needPayPrice); // 支付金额
		oldOrderCreate.setCustomerId(member.getId()); // 会员id
		oldOrderCreate.setAnonymous(true); // 匿名购买
		oldOrderCreate.setUseBdayDiscount(false); // 不使用生日折扣
		oldOrderCreate.setDeliveryType(0); // 配送方式：0-非快递 1-快递
		oldOrderCreate.setNoteCard(OrderCardType.NONE.getCode()); // 留言卡：不需要卡片
		oldOrderCreate.setChannelCode(channel.getCode()); // 渠道code
		oldOrderCreate.setDeviceId(deviceId); // 设备id
		oldOrderCreate.setDownloadSource(downloadSource); // 设备来与
		oldOrderCreate.setTbsClient(client); // 终端
		oldOrderCreate.setTbsUSource(uSource); // 投放渠道
		oldOrderCreate.setPlatForm(platform); // 平台

		// 拆分商品包
		OpSalesOrderVO opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay, member, channel,
				null, null);
		// 下订单
		OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);

		String orderCode = "";
		if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {

			orderCode = orderResp.getOrderCode();
			if (couponId != null && StringUtils.isNotBlank(orderCode)) {
				ServiceResp<Boolean> resp = cpCouponService.use(couponId);
				if (resp.isFailure()) {
					throw new OperationException("使用优惠券失败 [couponId=" + couponId + "]: " + resp.getRespMsg());
				}
			}

			// 0元支付
			if (needPayPrice.compareTo(BigDecimal.ZERO) == 0) {
				this.callOldOrderPay(orderCode, ALIPAY.getId(), needPayPrice, "");
			}
			// 保存订单快照
			if (StringUtils.isNotBlank(orderCode)) {
				String couponTitle = "";
				if (null != couponId) {
					couponTitle = dto.getCoupon().getCouponSample().getTitle();
				}
				snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(), couponTitle);
			}

//			try {
//				// ezr coupon
//				cpCouponService.couponUseEzr(couponId, channel.getCode(), orderCode,
//						opSalesOrderVO.getCouponFee().doubleValue());
//			} catch (Exception e) {
//				logger.error("couponUseEzr error");
//				logger.error(e.getMessage());
//			}

		}

		return orderCode;
	}

	private PrsCalPackDto getPriceRequest(MemberVO member, List<? extends ProductPack> packs, AccessWayEnum accessWay,
			OpChannelVO channel, Long couponId) {
		PrsCalPackDto result = new PrsCalPackDto();
		CpCouponVO couponVO = null;
		if (!NumberUtil.isNullOrZero(couponId)) {
			ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId, member.getId(), channel.getCode());
			if (rsp == null || rsp.getBean() == null) {
				throw new WrongArgException("优惠券不可用!", "couponId", couponId);
			} else {
				couponVO = rsp.getBean();
			}
		}
		priceAdapter.assemblePricepacks(null, result, packs, member, channel, accessWay, couponVO, BigDecimal.ZERO,
				null, null, false, null, null);
		return result;

	}

	private Boolean callOldOrderPay(String orderCode, Integer paymentType, BigDecimal totalAmount, String tradeNo) {
		try {
			// XXX:是否有必要给支付价格呢
			// 支付账号
			String _payAccount = "";
			return pcInstance.orderPay(orderCode, paymentType, totalAmount, _payAccount, tradeNo);
		} catch (Exception e) {
			logger.error("订单支付异常! e={}", e);
		}
		return false;
	}

	private SmartPosPreviewVO buildPreviewCardResult(PrsPacksPriceResultVO priceResult, OpChannelVO opChannel,
			MemberVO member, List<CartProductPack> packs, AccessWayEnum accessWay) {
		SmartPosPreviewVO result = new SmartPosPreviewVO();

		// 设置支付金额
		result.setPrice(priceResult.getFinalTotalPrice());
		// 设置价格步骤
		Collection<OrderDetailVO.PriceStepVO> priceSteps = priceAdapter.getPriceSteps(priceResult,
				member.getMemberLevelDesc(), "");
		result.setPriceSteps(priceSteps);
		// ====================xiugai==============

		/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
		List<String> productIds = new ArrayList<>();// 赠品productIdList
		Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

		// 从价格步骤中将需要的东西筛选出来
		priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
				campaignCodeMap);

		/* 取库存取商品详情取限量 */
		Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
		Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
		Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
		Map<PsProductVO, Boolean> hasVariantsMap = new HashMap<PsProductVO, Boolean>();

		if (CollectionUtils.isNotEmpty(productIds)) {
			// 取商详
			psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// 取库存
			stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
			// 多规格
			hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(psProductVOMap.values(), opChannel);

			// 取限量
			List<CampaignStreamVO> csList = new ArrayList<>();
			if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

				for (PsProductVO ppVO : psProductVOMap.values()) {

					CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
					campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
					campaignStreamVO.setProductCode(ppVO.getCode());
					csList.add(campaignStreamVO);
				}
				// 验证赠品限量库存
				ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
				if (srp.isSuccess() && srp.getBean() != null) {

					checkCspLimitMap.putAll(srp.getBean());
				}
			}
		}
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
		// 筛选赠一赠多
		priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

		/* 整理单品赠品、多品赠品、加价购包 */

		Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
		Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
		List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

		priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

		Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
		if (!singleGiftMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					List<String> list = new ArrayList<String>();
					for (PrsAdditionalPackVO pack : entry.getValue()) {
						list.add(pack.getProductId().toString());
					}
					singleGifts.put(entry.getKey().toString(), list);
				}
			}
		}
		List<String> adds = new ArrayList<String>();
		if (CollectionUtils.isNotEmpty(addList)) {
			for (PrsAdditionalPackVO add : addList) {
				adds.add(add.getProductId().toString());
			}
		}
		List<String> mutiGifts = new ArrayList<String>();
		if (!mutiGiftMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : mutiGiftMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					for (PrsAdditionalPackVO pack : entry.getValue()) {
						mutiGifts.add(pack.getProductId().toString());
					}
				}
			}
		}

		// 设置换购包
		result.setAddiblePacks(new ArrayList<CartProductPackVO>());
		if (CollectionUtils.isNotEmpty(adds)) {
			List<PsProductVO> addProducts = new ArrayList<PsProductVO>();
			List<ProductPack> addiblePacks = cartCommonAdapter.getOwnedAddiblePackPrice(packs);
			for (String productId : adds) {
				addProducts.add(psProductVOMap.get(productId));
			}
			List<CartProductPackVO> addPacks = priceAdapter.getAddPacks(addProducts, priceResult.getPriceStepVOs(),
					addiblePacks, stockMap, hasVariantsMap, opChannel, Boolean.TRUE);
			result.setAddiblePacks(addPacks);
		}

		// 设置多品赠品包
		List<PsProductVO> giftProducts = new ArrayList<PsProductVO>();
		result.setGiftPacks(new ArrayList<CartProductPackVO>());
		if (CollectionUtils.isNotEmpty(mutiGifts)) {
			for (String productId : mutiGifts) {
				giftProducts.add(psProductVOMap.get(productId));
			}
			result.setGiftPacks(priceAdapter.getMutiGiftPacks(giftProducts, priceResult.getPriceStepVOs(), stockMap,
					hasVariantsMap));
		}
		// 主商品
		List<ProductPack> rawPacks = Lists.newArrayList();
		for (ProductPack pack : packs) {
			if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
				rawPacks.add(pack);
			}
		}
		result.setPacks(cartPriceAdapter.getCartProductPackWithPrice(rawPacks, member, opChannel, accessWay,
				priceResult, singleGifts, psProductVOMap, new HashMap<Long, List<PrsCartSettleLabelVO>>(), stockMap,
				Boolean.TRUE));

		return result;
	}

	/**
	 * 构建订单创建对象： 设置 orderCreate.setPacks(packs);
	 * orderCreate.setAddiblePacks(addiblePacks);
	 * orderCreate.setGiftPackMap(giftPackMap);
	 *
	 * @param orderCreate
	 * @param packs
	 * @param priceResult
	 * @param opChannel
	 * @param member
	 */
	private void buildOrderCreatePacks(OrderCreateVO orderCreate, List<CartProductPack> packs,
			PrsPacksPriceResultVO priceResult, OpChannelVO opChannel, MemberVO member) {

		// ====================xiugai======================
		/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<>();// 以活动为key的赠品map
		List<String> productIds = new ArrayList<>();// 赠品productIdList
		Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

		// 从价格步骤中将需要的东西筛选出来
		priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
				campaignCodeMap);

		/* 取库存取商品详情取限量 */
		Map<String, PsProductVO> psProductVOMap = new HashMap<>();// 商品map
		Map<String, SSkuStockVO> stockMap = new HashMap<>();// 库存map
		Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

		if (CollectionUtils.isNotEmpty(productIds)) {
			// 取商详
			psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// 取库存
			stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

			// 取限量
			List<CampaignStreamVO> csList = new ArrayList<>();
			if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

				for (PsProductVO ppVO : psProductVOMap.values()) {

					CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
					campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
					campaignStreamVO.setProductCode(ppVO.getCode());
					campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
					if (member != null) {
						campaignStreamVO.setMemberCode(member.getCode());
					}

					csList.add(campaignStreamVO);

				}
				// 验证赠品限量库存
				ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
				if (srp.isSuccess() && srp.getBean() != null) {

					checkCspLimitMap.putAll(srp.getBean());
				}
			}
		}
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<>();// 筛选一次送后的活动map
		// 筛选赠一赠多
		priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

		/* 整理单品赠品、多品赠品、加价购包 */

		Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<>();// 单品赠品map
		Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<>();// 多品赠品map
		List<PrsAdditionalPackVO> addList = new ArrayList<>();// 换购包

		priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

		// ====================xiugai======================

		// 换购商品map,key:换购商品spvId，value:活动code Map<Long, String>： addPacks
		Map<Long, String> addiblePacks = priceAdapter.getAdds(priceResult.getPriceStepVOs(), packs);

		// 主品（spvid作为key）对应的赠品Map<Long,List<CartProductPack>> ： giftPackMap

		Map<Long, List<Long>> giftMap = priceAdapter.blindGift(singleGiftMap, mutiGiftMap);

		Map<Long, Integer> giftSizeMap = priceAdapter.getGiftSize(singleGiftMap, mutiGiftMap);

		Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
		List<CartProductPack> giftPacks = priceAdapter.getGifts(packs);
		if (CollectionUtils.isNotEmpty(giftPacks)) {
			if (null != giftMap && giftMap.size() > 0) {
				// if (CollectionUtils.isNotEmpty(giftPacks)) {

				for (Map.Entry<Long, List<Long>> gift : giftMap.entrySet()) {
					if (CollectionUtils.isNotEmpty(gift.getValue())) {
						List<CartProductPack> resultList = new ArrayList<CartProductPack>();
						for (Long productId : gift.getValue()) {
							for (CartProductPack gif : giftPacks) {// 取一个删一个，防止出现同一个product下多个spv赠品
								if (productId.equals(gif.getProductId())) {
									logger.info("给赠品塞数量，赠品productId = {}", productId);
									if (giftSizeMap.containsKey(productId)) {

										logger.info("，赠品productId = {}的实际数量为 count={}", productId,
												giftSizeMap.get(productId));
										gif.setCount(giftSizeMap.get(productId));
									} else {
										logger.info("，赠品productId = {}没有数量", productId);
									}
									resultList.add(gif);
									giftPacks.remove(gif);
									break;
								}
							}

						}
						if (CollectionUtils.isNotEmpty(resultList)) {
							giftPackMap.put(gift.getKey(), resultList);
						}
					}
				}
			}

		} else {// 前端如果不带赠品来，后端塞赠品
			if (!singleGiftMap.isEmpty()) {
				Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap, stockMap,
						checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack
				for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
					List<CartProductPack> packslist = new ArrayList<CartProductPack>();
					if (giftPackMap.containsKey(entry.getKey())) {
						packslist = giftPackMap.get(entry.getKey());
					}
					packslist.addAll(entry.getValue());
					giftPackMap.put(entry.getKey(), packslist);
				}
			}

			if (!mutiGiftMap.isEmpty()) {
				Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
						checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

				for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
					List<CartProductPack> packslist = new ArrayList<CartProductPack>();
					if (giftPackMap.containsKey(entry.getKey())) {
						packslist = giftPackMap.get(entry.getKey());
					}
					packslist.addAll(entry.getValue());
					giftPackMap.put(entry.getKey(), packslist);
				}
			}
		}

		orderCreate.setAddiblePacks(addiblePacks);
		orderCreate.setGiftPackMap(giftPackMap);
		this.resetPacksByPrice(packs, priceResult, addList);
		orderCreate.setPacks(packs);
	}

	/**
	 * 商品包中价格根据价格计算结果重新赋值
	 *
	 * @param packs
	 * @param priceResult
	 * @param addList
	 */
	private void resetPacksByPrice(List<CartProductPack> packs, PrsPacksPriceResultVO priceResult,
			List<PrsAdditionalPackVO> addList) {
		Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
		for (CartProductPack pack : packs) {
			if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
				PsSpvVO spv = new PsSpvVO();
				spv.setDiscountPrice(spvMap.get(pack.getSpvId()));
				spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
				spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
				spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
				spv.setAttrs(pack.getSpv().getAttrs());
				spv.setAttrValues(pack.getSpv().getAttrValues());
				spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
				spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
				spv.setCampaignList(pack.getSpv().getCampaignList());
				spv.setCategoryId(pack.getSpv().getCategoryId());
				spv.setCombined(pack.getSpv().getCombined());
				spv.setCostPrice(pack.getSpv().getCostPrice());
				spv.setMinAmount(pack.getSpv().getMinAmount());
				spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
				spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
				spv.setProductCode(pack.getSpv().getProductCode());
				spv.setProductId(pack.getSpv().getProductId());
				spv.setProductName(pack.getSpv().getProductName());
				spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
				spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
				spv.setPsStockVO(pack.getSpv().getPsStockVO());
				spv.setSalesPrice(pack.getSpv().getSalesPrice());
				spv.setSkuCode(pack.getSpv().getSkuCode());
				spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
				spv.setSkuVO(pack.getSpv().getSkuVO());
				spv.setSpvId(pack.getSpv().getSpvId());
				pack.setSpv(spv);
			}

			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				if (CollectionUtils.isNotEmpty(addList)) {
					for (PrsAdditionalPackVO add : addList) {
						if (add.getProductId().equals(pack.getProductId())) {

							PsSpvVO spv = new PsSpvVO();
							spv.setDiscountPrice(add.getDiscountPrice());
							spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
							spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
							spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
							spv.setAttrs(pack.getSpv().getAttrs());
							spv.setAttrValues(pack.getSpv().getAttrValues());
							spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
							spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
							spv.setCampaignList(pack.getSpv().getCampaignList());
							spv.setCategoryId(pack.getSpv().getCategoryId());
							spv.setCombined(pack.getSpv().getCombined());
							spv.setCostPrice(pack.getSpv().getCostPrice());
							spv.setMinAmount(pack.getSpv().getMinAmount());
							spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
							spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
							spv.setProductCode(pack.getSpv().getProductCode());
							spv.setProductId(pack.getSpv().getProductId());
							spv.setProductName(pack.getSpv().getProductName());
							spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
							spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
							spv.setPsStockVO(pack.getSpv().getPsStockVO());
							spv.setSalesPrice(pack.getSpv().getSalesPrice());
							spv.setSkuCode(pack.getSpv().getSkuCode());
							spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
							spv.setSkuVO(pack.getSpv().getSkuVO());
							spv.setSpvId(pack.getSpv().getSpvId());
							pack.setSpv(spv);
						}
					}
				}
			}
		}

	}

}
