package com.thebeastshop.pegasus.channelservice.service.impl;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.coupon.dto.CpCouponSampleCondDTO;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.service.CpCouponSetService;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.model.SendCouponRecord;
import com.thebeastshop.pegasus.channelservice.param.SendCouponGroupParam;
import com.thebeastshop.pegasus.channelservice.param.SendCouponParam;
import com.thebeastshop.pegasus.channelservice.service.SendCouponRecordService;
import com.thebeastshop.pegasus.channelservice.service.SendCouponService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongStateException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * create by com.thebeastshop.pegasus.channelservice.service.impl trunk :author lijing
 * User:lijing
 * DATE : 2016/9/19
 * TIME : 17:42
 * trunk.
 */
@Service("sendCouponService")
public class SendCouponServiceImpl implements SendCouponService {
    private final static Logger logger = LoggerFactory.getLogger(SendCouponServiceImpl.class);

    @Autowired
    private CpCouponSampleService cpCouponSampleService;

    @Autowired
    private CpCouponService cpCouponService;

    @Autowired
    private CpCouponSetService cpCouponSetService;

    @Autowired
    private SendCouponRecordService sendCouponRecordService;
    @Override
    public JsonApiResult sendCoupon(SendCouponParam sendCouponParam) {
        logger.info("发券参数为 sendCouponParam={}",sendCouponParam);
          if(null == sendCouponParam || null == sendCouponParam.getMemberId() || null == sendCouponParam.getCouponSampleId() || null == sendCouponParam.getType() ){
              return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(),ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
          }
        try {
            CpCouponSampleVO couponSample1 = null;
            try {
                couponSample1 = cpCouponSampleService.getCouponSampleById(sendCouponParam.getCouponSampleId());
            } catch (Exception ex) {
                logger.error("查询优惠券模板[ID = " + sendCouponParam.getCouponSampleId() + "]异常: " + ex);
            }
            if(null == couponSample1) {
                logger.info("优惠券1查询为空==");
                return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
                        ErrorCode.DATA_NOT_FOUND.getMesage());
            }
            ServiceResp<CpCouponVO> resp1 = cpCouponService.send(couponSample1.getId(), sendCouponParam.getMemberId());
            CpCouponVO coupon1 = resp1.getBean();
            if (resp1.isFailure() || coupon1 == null) {
                logger.info("发放优惠券1给{}的用户失败" ,sendCouponParam.getMemberId());
                return JsonApiResult.ofErrorResult(ErrorCode.DATA_NOT_FOUND.getCode(),
                            ErrorCode.DATA_NOT_FOUND.getMesage());
            } else {
                //保存红包发放记录
                Boolean recordResult =   sendCouponRecordService.saveSendCouponRecord(convertSendCouponParam(sendCouponParam));
                logger.info("发券保存记录 结果  recordResult={}",recordResult);
            }
        }catch (WrongStateException q){
            logger.error("发券接口异常  q={}",q);
            return JsonApiResult.ofErrorResult(3, "已经超过限领数量");
        }catch (WrongArgException w){
            logger.error("发券接口异常  w={}",w);
            return JsonApiResult.ofErrorResult(3, "查无优惠券");
        }catch (Exception e){
            logger.error("发券接口异常  e={}",e);
            return JsonApiResult.ofErrorResult(3, "网络打瞌睡");
        }
        return JsonApiResult.ofSuccessResult(true);
    }

    @Override
    public JsonApiResult sendCouponGroup(SendCouponGroupParam sendCouponGroupParam) {
        logger.info("发套券参数为 sendCouponGroupParam={}", sendCouponGroupParam);
        if(null == sendCouponGroupParam || null == sendCouponGroupParam.getMemberId() || CollectionUtils.isEmpty(sendCouponGroupParam.getCouponGroupId())){
            return JsonApiResult.ofErrorResult(ErrorCode.AUTHFAILED_MISS_PARAMS.getCode(),ErrorCode.AUTHFAILED_MISS_PARAMS.getMesage());
        }
        try{
            List<Long> memberIds =  new ArrayList<Long>();
            memberIds.add(sendCouponGroupParam.getMemberId());
            ServiceResp<Boolean> resp = cpCouponSetService.sendCouponsToMemberIds(sendCouponGroupParam.getCouponGroupId(), memberIds);
            if (resp.isSuccess() && resp.getBean()) {
                return JsonApiResult.ofSuccessResult(true);
            }
            return JsonApiResult.ofErrorResult(3, "发券失败");
        }catch (WrongStateException q){
            logger.error("发套券接口异常  q={}",q);
            return JsonApiResult.ofErrorResult(3, "已经超过限领数量");
        }catch (WrongArgException w){
            logger.error("发券接口异常  w={}",w);
            return JsonApiResult.ofErrorResult(3, "查无优惠券");
        }catch (Exception e){
            logger.error("发套券接口异常  e={}",e);
            return JsonApiResult.ofErrorResult(3, "网络打瞌睡");
        }
    }

    @Override
    public List<Long> findCouponSampleIdsNowActivity() {
        List<Long> couponSampleIds = new ArrayList<>();
        try {
            CpCouponSampleCondDTO condition = new CpCouponSampleCondDTO();
            condition.setStateId(4);
            condition.setIsExpert(false);
            List<CpCouponSampleVO> list = cpCouponSampleService.listBySelectCondition(condition);
            if(CollectionUtils.isNotEmpty(list)){
                for(CpCouponSampleVO couponSample : list){
                    if(null != couponSample && couponSample.getId() != null) {
                        couponSampleIds.add(couponSample.getId());
                    }
                }
            }
        }catch (Exception e){
            logger.error("查询卡券异常 e={}",e);
        }
        return  couponSampleIds;
    }

    /**
     * 参数转换保存 记录
     * @param sendCouponParam
     * @return
     */
    private SendCouponRecord convertSendCouponParam(SendCouponParam sendCouponParam){
        SendCouponRecord sendCouponRecord = new SendCouponRecord();
        if(null != sendCouponParam) {
            sendCouponRecord.setCreateAt(sendCouponParam.getCurrentTime());
            sendCouponRecord.setMemberId(sendCouponParam.getMemberId());
            sendCouponRecord.setCouponSampleId(sendCouponParam.getCouponSampleId());
            sendCouponRecord.setCouponCount(1);
            sendCouponRecord.setSendChannel(sendCouponParam.getChannel());
            sendCouponRecord.setSendType(sendCouponParam.getType());
        }
        return sendCouponRecord;
    }



}
