package com.thebeastshop.pegasus.channelservice.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.dto.CpCouponSampleProductCondDto;
import com.thebeastshop.coupon.dto.CpCouponSampleProductDetailCondDto;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponCustomVO;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.service.ProductCouponService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.YesOrNo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class ProductCouponServiceImpl implements ProductCouponService {

	private static final Logger log = LoggerFactory.getLogger(ProductCouponServiceImpl.class);

	@Autowired
	private CpCouponSampleService cpCouponSampleService;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private CpCouponService cpCouponService;

	// =================private================
	private BigDecimal sumCouponPrice(Collection<? extends ProductPack> sourcePacks, CpCouponVO coupon) {
		BigDecimal sumPrice = BigDecimal.ZERO;
		for (ProductPack pack : sourcePacks) {
			// 判断满足商品是否满足优惠券的条件
			PsProductVO product = mcPsProductService.findProdBySpvId(pack.getSpvId());
			if (checkProductInCoupon(product, coupon)) {
				sumPrice = sumPrice.add(pack.getPrice());
			}
		}
		return sumPrice;
	}
	// ==============华丽丽的分隔符================

	@Override
	public Boolean checkProductInCoupon(PsProductVO product, CpCouponVO coupon) {
		CpCouponSampleVO couponSample = cpCouponSampleService.getCouponSampleById(coupon.getCouponSampleId());
		// 判断是否优惠券模板全场优惠
		if (couponSample.isForAllProducts() && (CollectionUtils.isEmpty(couponSample.getExcludeProductIds())
				|| !couponSample.getExcludeProductIds().contains(Long.valueOf(product.getId())))) {
			return true;
		}
		// 判断是否在优惠券模板的商品列表中
		if (CollectionUtils.isNotEmpty(couponSample.getProductIds())
				&& couponSample.getProductIds().contains(Long.valueOf(product.getId()))) {
			return true;
		}
		// 判断是否在优惠券模板的商品类目列表中
		if (CollectionUtils.isNotEmpty(couponSample.getCategoryIds())) {
			if (product.getCategoryId() != null && couponSample.getCategoryIds().contains(product.getCategoryId())) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean checkCoupon(Collection<? extends ProductPack> sourcePacks, CpCouponVO coupon,
			AccessWayEnum accessWay) {
		if (coupon != null) {
			CpCouponSampleVO couponSampleVO = coupon.getCouponSample();
			if (couponSampleVO == null) {
				couponSampleVO = cpCouponSampleService.getCouponSampleById(coupon.getCouponSampleId());
			}
			if (couponSampleVO != null) {
				// ==========判断平台来源==========
				Collection<Integer> accessWays = couponSampleVO.getAccessWayIds();
				if (CollectionUtils.isNotEmpty(accessWays) && accessWay != null) {
					if (!accessWays.contains(accessWay.getCode())) {
						log.info("accessWay不符合要求=" + accessWay);
						return false;
					}
				}

				// =============判断优惠券支持==============
				Boolean isWeekFlag = false;
				Boolean isCroosflag = false;
				// 判断商品是否海淘和周送
				for (ProductPack productPack : sourcePacks) {
					if (YesOrNo.YES.getId().equals(productPack.getProduct().getIsMonthSend())) {
						isWeekFlag = true;
					}
					if (YesOrNo.YES.getId().equals(productPack.getProduct().getCrossBorderFlag())) {
						isCroosflag = true;
					}

					break;
				}
				// 月送鲜花 0:不限制 1:周送 2:非周送
				Integer weekflag = couponSampleVO.getWeekFlower() == null ? 2 : couponSampleVO.getWeekFlower();
				// 海外购 0:不限制 1:海淘 2:非海淘
				Integer crooslag = couponSampleVO.getCrossBorder() == null ? 0 : couponSampleVO.getCrossBorder();
				if (isCroosflag) {
					if (crooslag == 2) {
						log.info("crooslagA return");
						return false;
					}
				} else {
					if (crooslag == 1) {
						log.info("crooslagB return");
						return false;
					}
				}
				if (isWeekFlag) {
					if (weekflag == 2) {
						log.info("crooslagC return");
						return false;
					}
				} else {
					if (weekflag == 1) {
						log.info("crooslagD return");
						return false;
					}
				}

				// ======判断商品包是否满足优惠券=====
				if (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) { // 满减优惠券类型
					CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) couponSampleVO.getCouponContent();
					// 判断商品总额是否满足优惠券的满额
					BigDecimal sumCouponPrice = sumCouponPrice(sourcePacks, coupon);
					if (sumCouponPrice.equals(BigDecimal.ZERO)) {
						// 无满足优惠券的商品情况，优惠券不可用
						log.info("crooslag 金额 return");
						return false;
					} else {
						// 无门槛的优惠券直接可用，或者总金额满足优惠券门槛则可用
						if (fullCutCoupon.getFullPrice().equals(BigDecimal.ZERO)
								|| sumCouponPrice.compareTo(fullCutCoupon.getFullPrice()) >= 0) {
							log.info("crooslag 金额 ok");
							return true;
						}
					}
				}
				// ============================
			}
		}
		log.info("crooslag other ok");
		return false;
	}

	@Override
	public boolean checkCoupon(Collection<? extends ProductPack> sourcePacks, CpCouponVO coupon,
			AccessWayEnum accessWay, MemberVO member, OpChannelVO opChannel) {
		if (coupon != null) {
			CpCouponSampleVO couponSampleVO = coupon.getCouponSample();
			if (couponSampleVO == null) {
				couponSampleVO = cpCouponSampleService.getCouponSampleById(coupon.getCouponSampleId());
			}
			if (couponSampleVO != null) {
				// ==========判断平台来源==========
				Collection<Integer> accessWays = couponSampleVO.getAccessWayIds();
				if (CollectionUtils.isNotEmpty(accessWays) && accessWay != null) {
					if (!accessWays.contains(accessWay.getCode())) {
						log.info("accessWay不符合要求=" + accessWay);
						return false;
					}
				}

				// =============判断优惠券支持==============
				Boolean isWeekFlag = false;
				Boolean isCroosflag = false;
				// 判断商品是否海淘和周送
				for (ProductPack productPack : sourcePacks) {
					if (YesOrNo.YES.getId().equals(productPack.getProduct().getIsMonthSend())) {
						isWeekFlag = true;
					}
					if (YesOrNo.YES.getId().equals(productPack.getProduct().getCrossBorderFlag())) {
						isCroosflag = true;
					}

					break;
				}
				// 月送鲜花 0:不限制 1:周送 2:非周送
				Integer weekflag = couponSampleVO.getWeekFlower() == null ? 2 : couponSampleVO.getWeekFlower();
				// 海外购 0:不限制 1:海淘 2:非海淘
				Integer crooslag = couponSampleVO.getCrossBorder() == null ? 0 : couponSampleVO.getCrossBorder();
				if (isCroosflag) {
					if (crooslag == 2) {
						log.info("crooslagA return");
						return false;
					}
				} else {
					if (crooslag == 1) {
						log.info("crooslagB return");
						return false;
					}
				}
				if (isWeekFlag) {
					if (weekflag == 2) {
						log.info("crooslagC return");
						return false;
					}
				} else {
					if (weekflag == 1) {
						log.info("crooslagD return");
						return false;
					}
				}

				// ======判断商品包是否满足优惠券=====
				// if
				// (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId()))
				// { // 满减优惠券类型
				// CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO)
				// couponSampleVO.getCouponContent();
				// // 判断商品总额是否满足优惠券的满额
				// BigDecimal sumCouponPrice = sumCouponPrice(sourcePacks,
				// coupon);
				// if (sumCouponPrice.equals(BigDecimal.ZERO)) {
				// // 无满足优惠券的商品情况，优惠券不可用
				// log.info("crooslag 金额 return");
				// return false;
				// } else {
				// // 无门槛的优惠券直接可用，或者总金额满足优惠券门槛则可用
				// if (fullCutCoupon.getFullPrice().equals(BigDecimal.ZERO)
				// || sumCouponPrice.compareTo(fullCutCoupon.getFullPrice()) >=
				// 0) {
				// log.info("crooslag 金额 ok");
				// return true;
				// }
				// }
				// }
				CpCouponSampleProductCondDto cond = new CpCouponSampleProductCondDto();
				List<Long> couponIds = Lists.newArrayList();
				couponIds.add(coupon.getId());
				cond.setMemberId(member.getId());
				cond.setExpert(false);
				cond.setValid(1);
				cond.setUsed(0);
				cond.setCouponIds(couponIds);
				List<String> accessWayIds = new ArrayList<>();
				accessWayIds.add(accessWay.getCode().toString());
				cond.setAccessWayIds(accessWayIds);
				cond.setChannelCode(opChannel.getCode());
				List<CpCouponSampleProductDetailCondDto> cpCouponSampleProductDetailDtos = null;

				if (CollectionUtils.isNotEmpty(sourcePacks)) {

					cpCouponSampleProductDetailDtos = new ArrayList<>();
					boolean is_cross_border = false;
					boolean is_week_flower = false;
					for (ProductPack pack : sourcePacks) {
						if (pack.getProduct().getCrossBorderFlag() != null
								&& pack.getProduct().getCrossBorderFlag() == 1) {
							is_cross_border = true;
						}

						if (pack.getProduct().getIsMonthSend() != null && pack.getProduct().getIsMonthSend() == 1) {
							is_week_flower = true;
						}
//						CpCouponSampleProductDetailCondDto dto = new CpCouponSampleProductDetailCondDto(
//								Long.valueOf(pack.getProduct().getId()), pack.getProduct().getCategoryId(),
//								pack.getPrice(), pack.getCount(), is_cross_border, is_week_flower);

//						if (pack.getSource().equals(CartPackSource.BENEFIT)) {
//							dto = new CpCouponSampleProductDetailCondDto(Long.valueOf(pack.getProduct().getId()),
//									pack.getProduct().getCategoryId(), pack.getSpv().getSalesPrice(), pack.getCount(),
//									is_cross_border, is_week_flower);
//						}

						//cpCouponSampleProductDetailDtos.add(dto);

					}

					cond.setCpCouponSampleProductDetailDtos(cpCouponSampleProductDetailDtos);
				}

				List<CpCouponCustomVO> coupons = cpCouponService.getCouponByShoppingProducts(cond);
				if (CollectionUtils.isNotEmpty(coupons)) {

					return true;
				}

				// ============================
			}
		}
		log.info("crooslag other ok");
		return false;
	}
}
