package com.thebeastshop.pegasus.channelservice.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.campaign.CampaignAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCustomizeAdapter;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.PriceStep;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.channelservice.service.ProductCouponService;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.service.CampaignServiceNew;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.channel.service.ChannelService;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.mark.HasPrice;
import com.thebeastshop.support.util.BeanUtil;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;

/**
 * 价格服务实现
 * 
 * @author Paul-xiong
 *
 */
@Service
public class PriceServiceImpl implements PriceService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private CampaignServiceNew campaignServiceNew = ComponentServiceLoader.getBean(CampaignServiceNew.class);
	private ChannelService channelService = ComponentServiceLoader.getBean(ChannelService.class);
	@Autowired
	private CpCouponSampleService cpCouponSampleService;

	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private CampaignAdapter campaignAdaptor;

	@Autowired
	private ProductCouponService productCouponService;
	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	// ===============private===================

	private List<PsCampaignVO> getOptionCampaign(List<ProductPack> rawPacks) {
		List<PsCampaignVO> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(rawPacks)) {
			for (ProductPack pack : rawPacks) {
				PsProductVO product = pack.getProduct();
				if (product != null && CollectionUtils.isNotEmpty(product.getCampaignList())) {
					for (PsCampaignVO campaign : product.getCampaignList()) {
						if (campaign.getDiscountTypeId().equals(DiscountType.OPTION.id)) {
							rt.add(campaign);
						}
					}
				}
			}
		}
		return rt;
	}

	private List<ProductPack> separatePacksForOneOptionCampaign(List<ProductPack> rawPacks, PsCampaignVO campaign) {
		List<ProductPack> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(rawPacks)) {
			Boolean flag = null;
			List<PsCampaignVO> list = null;
			CartProductPack newPack = null;
			PsProductVO newProduct = null;
			for (ProductPack pack : rawPacks) {
				flag = true;
				PsProductVO product = pack.getProduct();
				if (product != null && CollectionUtils.isNotEmpty(product.getCampaignList())) {
					for (PsCampaignVO productCampaign : product.getCampaignList()) {
						int count = pack.getCount();
						if (productCampaign.getDiscountTypeId().equals(DiscountType.OPTION.id) && count > 1) {
							flag = false;
							for (int i = 0; i < count; i++) {
								list = BeanUtil.buildListFrom(product.getCampaignList(), PsCampaignVO.class);
								newProduct = BeanUtil.buildFrom(product, PsProductVO.class);
								newProduct.setCampaignList(list);
								newPack = new CartProductPack();
								BeanUtils.copyProperties(pack, newPack);
								newPack.setCount(1);
								newPack.setProduct(newProduct);
								rt.add(newPack);
							}
							break;
						}
					}
				}
				if (flag) {
					rt.add(pack);
				}
			}
		}
		return rt;
	}

	/**
	 * N元任选活动拆商品包
	 * 
	 * @param rawPacks
	 * @return
	 */
	private List<ProductPack> separatePacksForOptionCampaign(List<ProductPack> rawPacks) {
		if (CollectionUtils.isNotEmpty(rawPacks)) {
			List<PsCampaignVO> optionCampaign = getOptionCampaign(rawPacks);

			// 商品包按spv原价倒叙排序
			// logger.info("初始包：{}", rawPacks);
			Collections.sort(rawPacks, new CompareSpvPrice(false));

			for (PsCampaignVO campaign : optionCampaign) {
				rawPacks = separatePacksForOneOptionCampaign(rawPacks, campaign);
			}
		}
		return rawPacks;
	}

	private PriceCalResultVO getPriceCalResult(List<PriceCalResultVO> results, PriceCalResultVO result) {
		PriceCalResultVO rt = null;
		if (CollectionUtils.isNotEmpty(results) && result != null) {
			for (PriceCalResultVO priceCalResultVO : results) {
				if (priceCalResultVO.getType().equals(result.getType())
						&& ((priceCalResultVO.getExtId() == null && result.getExtId() == null)
								|| priceCalResultVO.getExtId().equals(result.getExtId()))) {
					rt = priceCalResultVO;
				}
			}
		}
		return rt;
	}

	/**
	 * 计算会员等级折扣
	 * 
	 * @param packs
	 * @param member
	 * @return
	 */
	private PriceStep calMemberLevelPrice(List<ProductPack> packs, MemberVO member) {
		Date start = new Date();
		PriceStep step = null;
		if (CollectionUtils.isNotEmpty(packs)) {
			PriceCalResultVO calMemberPriceResult = null;
			for (ProductPack pack : packs) {
				if (calMemberPriceResult != null) {
					break;
				}
				PsSpvVO spv = pack.getSpv();
				List<PriceCalResultVO> results = spv.getPriceCalResults();
				if (CollectionUtils.isNotEmpty(results)) {
					for (PriceCalResultVO result : results) {
						if (result.getType().equals(PriceCalTypeEnum.MEMBER_LEVEL)) {
							calMemberPriceResult = result;
							break;
						}
					}
				}
			}
			BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
			BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格
			if (calMemberPriceResult != null) {
				Map<ProductPack, BigDecimal> originPriceMap = Maps.newHashMap();
				Map<ProductPack, BigDecimal> finalPriceMap = Maps.newHashMap();
				for (ProductPack pack : packs) {
					PsSpvVO spv = pack.getSpv();
					List<PriceCalResultVO> results = spv.getPriceCalResults();
					PriceCalResultVO spvResult = getPriceCalResult(results, calMemberPriceResult);
					if (spvResult != null) {
						BigDecimal originPrice = PriceUtil.keepToCent(spvResult.getOriginalPrice());
						BigDecimal finalPrice = PriceUtil.keepToCent(spvResult.getFinalPrice());
						calculatingPrice = calculatingPrice
								.add(originPrice.multiply(BigDecimal.valueOf(pack.getCount())));
						calculatedPrice = calculatedPrice.add(finalPrice.multiply(BigDecimal.valueOf(pack.getCount())));
						originPriceMap.put(pack, originPrice);
						finalPriceMap.put(pack, finalPrice);
						pack.setFactProductPrice(finalPrice);
					} else {
						BigDecimal price = PriceUtil.keepToCent(pack.getFactProductPrice());
						calculatingPrice = calculatingPrice.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
						calculatedPrice = calculatedPrice.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
						originPriceMap.put(pack, price);
						finalPriceMap.put(pack, price);
					}
				}
				step = new PriceStep();
				step.setPriceType(PriceType.MEMBER_LEVEL);

				if (member != null) {
					step.setExtId(member.getId());
				}

				step.setOriginalPackPrice(originPriceMap);
				step.setFinalPackPrice(finalPriceMap);
				step.setCalculatingPrice(calculatingPrice);
				step.setCalculatedPrice(calculatedPrice);
				// logger.info("计算会员折扣步骤：{}", step);

			}
		}
		Date end = new Date();
		logger.info("计算会员等级折扣花费时间：{}毫秒", end.getTime() - start.getTime());
		return step;
	}

	/**
	 * 计算所有价格折扣活动优惠
	 * 
	 * @param packs
	 * @param packs
	 * @return
	 */
	private List<PriceStep> calPriceCampaign(List<ProductPack> packs) {
		Date start = new Date();
		List<PriceStep> steps = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(packs)) {
			List<PriceCalResultVO> maxResults = Lists.newArrayList();
			for (ProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				List<PriceCalResultVO> results = spv.getPriceCalResults();
				if (CollectionUtils.isNotEmpty(results)) {
					for (PriceCalResultVO result : results) {
						if (result.getType().equals(PriceCalTypeEnum.CAMPAIGN)) {
							PriceCalResultVO spvResult = getPriceCalResult(maxResults, result);
							if (spvResult == null) {
								maxResults.add(result);
							}
						}
					}
				}
			}
			if (CollectionUtils.isNotEmpty(maxResults)) {
				for (PriceCalResultVO result : maxResults) {
					BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
					BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格
					Map<ProductPack, BigDecimal> originPriceMap = Maps.newHashMap();
					Map<ProductPack, BigDecimal> finalPriceMap = Maps.newHashMap();
					for (ProductPack pack : packs) {
						PsSpvVO spv = pack.getSpv();
						List<PriceCalResultVO> results = spv.getPriceCalResults();
						PriceCalResultVO spvResult = getPriceCalResult(results, result);
						if (spvResult != null) {
							BigDecimal originPrice = PriceUtil.keepToCent(spvResult.getOriginalPrice());
							BigDecimal finalPrice = PriceUtil.keepToCent(spvResult.getFinalPrice());
							calculatingPrice = calculatingPrice
									.add(originPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							calculatedPrice = calculatedPrice
									.add(finalPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							originPriceMap.put(pack, originPrice);
							finalPriceMap.put(pack, finalPrice);
							pack.setFactProductPrice(finalPrice);
						} else {
							BigDecimal price = PriceUtil.keepToCent(pack.getFactProductPrice());
							calculatingPrice = calculatingPrice
									.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
							calculatedPrice = calculatedPrice.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
							originPriceMap.put(pack, price);
							finalPriceMap.put(pack, price);
						}
					}
					PriceStep step = new PriceStep();
					step.setPriceType(PriceType.CAMPAIGN);
					step.setExtId(result.getExtId());
					step.setOriginalPackPrice(originPriceMap);
					step.setFinalPackPrice(finalPriceMap);
					step.setCalculatingPrice(calculatingPrice);
					step.setCalculatedPrice(calculatedPrice);
					steps.add(step);
				}
			}
		}
		Date end = new Date();
		logger.info("计算所有价格折扣活动优惠：{}毫秒  ", end.getTime() - start.getTime());
		return steps;
	}

	/**
	 * 计算所有非价格折扣活动优惠
	 * 
	 * @param rawPacks
	 * @param campaignHandlers
	 * @param opChannel
	 * @param campaignResults
	 * @return
	 */
	private List<PriceStep> calNonPriceCampaign(List<ProductPack> rawPacks, final List<ProductPack> addiblePacks,
			List<CampaignHandler> campaignHandlers, OpChannelVO opChannel, List<CampaignResult> campaignResults) {
		List<PriceStep> steps = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(campaignHandlers)) {
			// 获取非价格折扣活动操作器
			List<CampaignHandler> nonPriceCampaignHandlers = Lists.newArrayList();
			Iterator<CampaignHandler> handlerIter = campaignHandlers.iterator();
			while (handlerIter.hasNext()) {
				CampaignHandler handler = handlerIter.next();
				Campaign campaign = handler.getCampaign();
				if (!campaign.getDiscountType().equals(DiscountType.OFF)
						&& !campaign.getDiscountType().equals(DiscountType.PANIC_BUY)) {
					nonPriceCampaignHandlers.add(handler);
				}
			}
			Channel channel = channelService.getByCode(opChannel.getCode());
			List<CampaignResult> results = campaignServiceNew.match(nonPriceCampaignHandlers, rawPacks, channel);
			if (campaignResults != null) {
				campaignResults.addAll(results);
			}
			for (int i = 0, size = results.size(); i < size; i++) {
				final CampaignResult campaignResult = results.get(i);
				if (campaignResult.isReach()) {
					if (campaignResult.getDiscountType().equals(DiscountType.CHEAPEN_OTHER)) {
						// 加价购活动
						Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
						if (CollectionUtils.isNotEmpty(addiblePacks) && CollectionUtils.isNotEmpty(additionalPacks)) {
							for (ProductPack productPack : additionalPacks) {
								Iterator<? extends ProductPack> iterator = addiblePacks.iterator();
								while (iterator.hasNext()) {
									ProductPack addiblePack = iterator.next();
									if (addiblePack.getProductId().equals(productPack.getProductId())) {
										if (addiblePack.getCount() < addiblePack.getCount()) {
											throw new ChannelException(400, "最大换购数为" + addiblePack.getCount());
										}
										PsSpvVO spv = addiblePack.getSpv();
										BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
										BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格
										Map<ProductPack, BigDecimal> originPriceMap = Maps.newHashMap();
										Map<ProductPack, BigDecimal> finalPriceMap = Maps.newHashMap();
										BigDecimal salesPrice = PriceUtil.keepToCent(spv.getSalesPrice());
										BigDecimal price = productPack.getFactProductPrice();
										calculatingPrice = calculatingPrice
												.add(salesPrice.multiply(BigDecimal.valueOf(addiblePack.getCount())));
										calculatedPrice = calculatedPrice
												.add(price.multiply(BigDecimal.valueOf(addiblePack.getCount())));
										originPriceMap.put(addiblePack, salesPrice);
										finalPriceMap.put(addiblePack, price);
										PriceStep step = new PriceStep();
										step.setPriceType(PriceType.CAMPAIGN);
										step.setExtId(campaignResult.getCampaign().getId());
										step.setOriginalPackPrice(originPriceMap);
										step.setFinalPackPrice(finalPriceMap);
										step.setCalculatingPrice(calculatingPrice);
										step.setCalculatedPrice(calculatedPrice);
										steps.add(step);
										iterator.remove();
									}
								}
							}
						}
					} else {
						PriceStep step = new PriceStep();
						step.setPriceType(PriceType.CAMPAIGN);
						step.setExtId(campaignResult.getCampaign().getId());
						step.setOriginalPackPrice(campaignResult.getOriginPriceMap());
						step.setFinalPackPrice(campaignResult.getFinalPriceMap());
						step.setCalculatingPrice(campaignResult.getParticipatingPrice());
						step.setCalculatedPrice(campaignResult.getParticipatedPrice());
						steps.add(step);
					}
				}
				if (i == size - 1) {// 最后一个活动结果
					Map<ProductPack, BigDecimal> finalPackPrice = campaignResult.getFinalPriceMap();
					// 修改商品包价格
					for (ProductPack pack : rawPacks) {
						BigDecimal price = finalPackPrice.get(pack);
						if (price != null) {
							pack.setFactProductPrice(price);
						}
					}
				}
			}
		}
		return steps;
	}

	/**
	 * 计算优惠券优惠
	 * 
	 * @param packs
	 * @param couponId
	 * @param accessWay
	 * @return
	 */
	private PriceStep calCouponPrice(final List<? extends ProductPack> packs, Long couponId, AccessWayEnum accessWay) {
		PriceStep step = null;
		BigDecimal savedPrice = BigDecimal.ZERO;
		BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
		BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格
		Map<ProductPack, BigDecimal> originalPackPrice = Maps.newHashMap();// 商品包原始价格(单件)
		Map<ProductPack, BigDecimal> finalPackPrice = null;
		for (ProductPack pack : packs) {
			BigDecimal originPrice = PriceUtil.keepToCent(pack.getFactProductPrice());
			calculatingPrice = calculatingPrice.add(originPrice.multiply(BigDecimal.valueOf(pack.getCount())));
			originalPackPrice.put(pack, originPrice);
		}
		if (couponId != null) {
			CpCouponVO coupon = cpCouponService.getCouponById(couponId);
			if (coupon != null && productCouponService.checkCoupon(packs, coupon, accessWay)) {
				if (coupon.getCouponSampleId() != null) {
					CpCouponSampleVO couponSample = cpCouponSampleService
							.getCouponSampleById(coupon.getCouponSampleId());
					if (couponSample.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
						CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) couponSample.getCouponContent();
						savedPrice = fullCutCoupon.getCutPrice();
						finalPackPrice = Maps.newHashMap();
						List<ProductPack> packsForCoupon = Lists.newArrayList(); // 满足优惠券的商品包
						for (Entry<ProductPack, BigDecimal> entry : originalPackPrice.entrySet()) {
							ProductPack pack = entry.getKey();
							BigDecimal price = entry.getValue();
							PsProductVO product = pack.getProduct();
							if (productCouponService.checkProductInCoupon(product, coupon)) {
								packsForCoupon.add(pack);
							} else {
								calculatedPrice = calculatedPrice
										.add(PriceUtil.keepToCent(price.multiply(BigDecimal.valueOf(pack.getCount()))));
								finalPackPrice.put(pack, PriceUtil.keepToCent(price));
							}
						}
						// 计算满足优惠券的商品包价格分摊并且要把分摊后的商品包加到最终商品价格map中
						// 优惠券价格计算分摊，最后一件商品分摊到的优惠应该用优惠券总价减去其他商品分摊优惠
						if (CollectionUtils.isNotEmpty(packsForCoupon)) {
							Map<ProductPack, BigDecimal> sharePricePacks = Maps.newHashMap();
							for (ProductPack productPack : packsForCoupon) {
								sharePricePacks.put(productPack,productPack.getPrice());
							}

							if (sharePricePacks != null) {
								for (ProductPack pack : packsForCoupon) {
									BigDecimal sharePrice = sharePricePacks.get(pack);
									BigDecimal finalPrice = PriceUtil.keepToCent(sharePrice
											.divide(BigDecimal.valueOf(pack.getCount()), 10, RoundingMode.HALF_UP));
									// calculatedPrice =
									// calculatedPrice.add(PriceUtil.keepToCent(finalPrice.multiply(BigDecimal.valueOf(pack.getCount()))));
									calculatedPrice = calculatedPrice.add(sharePrice);
									finalPackPrice.put(pack, finalPrice);
								}
							}
						}
						// 修改商品包价格
						for (ProductPack pack : packs) {
							BigDecimal price = finalPackPrice.get(pack);
							if (price != null) {
								pack.setFactProductPrice(price);
							}
						}
						step = new PriceStep();
						step.setPriceType(PriceType.COUPON);
						step.setExtId(couponId);
						step.setOriginalPackPrice(originalPackPrice);
						step.setFinalPackPrice(finalPackPrice);
						step.setCalculatingPrice(calculatingPrice);
						step.setCalculatedPrice(calculatedPrice);
					}
				}
			} else {
				logger.error("优惠券[{}]不可用", couponId);
				throw new ChannelException(400, "优惠券不可用！");
			}
		}
		return step;
	}

	// =========================================

	@Override
	public PriceResult calculateProductPackPrice(CalculateProductPackDTO dto) {
		logger.debug("计算商品包价格优惠，入参：{}", dto);

		Date start = new Date();
		PriceResult result = null;
		List<? extends ProductPack> packs = BeanUtil.buildListFrom(dto.getPacks(), CartProductPack.class);
		MemberVO member = dto.getMember();
		AccessWayEnum accessWay = dto.getAccessWay();
		OpChannelVO opChannel = dto.getOpChannel();
		if (CollectionUtils.isNotEmpty(packs) && accessWay != null && opChannel != null) {
			// ========拆分主/加价购商品包========
			List<ProductPack> rawPacks = Lists.newArrayListWithExpectedSize(packs.size()); // 主商品包
			List<ProductPack> addiblePacks = Lists.newArrayListWithExpectedSize(packs.size());// 加价购商品包
			for (ProductPack pack : packs) {
				if (null != pack) {
					if (CartPackSourceEnum.RAW.equals(pack.getSource())) {
						rawPacks.add(pack);
					} else if (CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
						addiblePacks.add(pack);
					}
				}
			}
			rawPacks = separatePacksForOptionCampaign(rawPacks);
			List<CampaignHandler> campaignHandlers = campaignAdaptor.getCampaignHandlers(rawPacks, accessWay);
			List<CampaignResult> campaignResults = Lists.newArrayList();
			List<PriceStep> steps = Lists.newArrayList();
			// =============价格折扣活动优惠============
			List<PriceStep> priceCampaignSteps = calPriceCampaign(rawPacks);
			steps.addAll(priceCampaignSteps);

			if (member != null && member.isInBdayDiscountTime() && dto.isBirthday()) {// 会员使用生日折扣
				// ================生日折扣及会员折扣计算方法===============
				List<PriceStep> birthdaySteps = calBirthdayPrice(rawPacks, member);
				if (birthdaySteps != null) {
					for (PriceStep birthdayStep : birthdaySteps) {
						steps.add(birthdayStep);
					}
				}
			} else {
				// ================会员折扣===============
				PriceStep memberLevelStep = calMemberLevelPrice(rawPacks, member);
				if (memberLevelStep != null) {
					steps.add(memberLevelStep);
				}
			}

			// ==============非价格折扣活动优惠==========
			List<PriceStep> nonPriceCampaignSteps = calNonPriceCampaign(rawPacks, addiblePacks, campaignHandlers,
					opChannel, campaignResults);
			steps.addAll(nonPriceCampaignSteps);
			// ==============优惠券优惠==============
			PriceStep couponPriceStep = calCouponPrice(rawPacks, dto.getCouponId(), accessWay);
			if (couponPriceStep != null) {
				steps.add(couponPriceStep);
			}
			// ======================================
			result = new PriceResult();
			result.setSteps(steps);
			result.setCampaignResults(campaignResults);
		}
		Date end = new Date();
		// logger.info("计算商品包价格优惠，返回：{}，花费时间：{}毫秒", result, end.getTime() -
		// start.getTime());
		logger.info("计算商品包价格优惠，花费时间：{}毫秒", end.getTime() - start.getTime());
		return result;

	}

	@Override
	public BigDecimal calculateCustomizePrice(CalculateProductPackDTO dto) {
		BigDecimal customizeFee = BigDecimal.ZERO;
		List<? extends ProductPack> packs = BeanUtil.buildListFrom(dto.getPacks(), CartProductPack.class);
		for (ProductPack pack : packs) {
			if (pack.isCustomize()) {
				BigDecimal customizePrice = spvCustomizeAdapter.getCustomizePriceBySkuCode(pack.getSpv().getSkuCode());
				if (!NumberUtil.isNullOrZero(customizePrice)) {
					customizeFee = customizeFee.add(customizePrice.multiply(new BigDecimal(pack.getCount())));
				}
			}
		}
		return customizeFee;
	}

	public List<? extends ProductPack> calculateRawProductPackPrice(CalculateProductPackDTO dto) {
		logger.debug("计算商品包价格优惠，入参：{}", dto);
		List<ProductPack> rawPacks = Lists.newArrayList(); // 主商品包
		List<ProductPack> addiblePacks = Lists.newArrayList();// 加价购商品包
		Date start = new Date();
		List<? extends ProductPack> packs = BeanUtil.buildListFrom(dto.getPacks(), CartProductPack.class);
		MemberVO member = dto.getMember();
		AccessWayEnum accessWay = dto.getAccessWay();
		OpChannelVO opChannel = dto.getOpChannel();
		if (CollectionUtils.isNotEmpty(packs) && member != null && accessWay != null && opChannel != null) {
			// ========拆分主/加价购商品包========
			for (ProductPack pack : packs) {
				if (CartPackSourceEnum.RAW.equals(pack.getSource())) {
					rawPacks.add(pack);
				} else if (CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
					addiblePacks.add(pack);
				}
			}
			// N元任选 不涉及商品包价格变更 ---注释掉
			rawPacks = separatePacksForOptionCampaign(rawPacks);
			List<CampaignHandler> campaignHandlers = campaignAdaptor.getCampaignHandlers(rawPacks, accessWay);
			// 价格折扣活动优惠 商品价格会重置为活动后价格
			List<PriceStep> priceCampaignSteps = calPriceCampaign(rawPacks);

			if (member.isInBdayDiscountTime() && dto.isBirthday()) {// 会员使用生日折扣
				// 生日折扣及会员折扣计算方法 商品包中价格设置为生日后价格
				List<PriceStep> birthdaySteps = calBirthdayPrice(rawPacks, member);
			} else {
				// 会员折扣 商品包价格变更为会员后价格
				PriceStep memberLevelStep = calMemberLevelPrice(rawPacks, member);
			}
			// 非价格折扣活动优惠 获取非价格活动后商品价格
			List<CampaignResult> campaignResults = Lists.newArrayList();
			calNonPriceCampaign(rawPacks, addiblePacks, campaignHandlers, opChannel, campaignResults);
		}
		Date end = new Date();
		logger.info("计算商品包主品活动后价格，花费时间：{}毫秒", end.getTime() - start.getTime());
		return rawPacks;
	}

	/**
	 * 计算生日折扣
	 * 
	 * @param packs
	 * @param member
	 * @return
	 */
	private List<PriceStep> calBirthdayPrice(List<ProductPack> packs, MemberVO member) {
		Date start = new Date();
		List<PriceStep> steps = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(packs)) {
			PriceCalResultVO calBirthdayResult = null;
			PriceCalResultVO calMemberResult = null;
			for (ProductPack pack : packs) {
				if (calBirthdayResult != null || calMemberResult != null) {
					break;
				}
				PsSpvVO spv = pack.getSpv();
				List<PriceCalResultVO> bdresults = spv.getBdPriceCalResults();
				List<PriceCalResultVO> mbresults = spv.getPriceCalResults();
				if (CollectionUtils.isNotEmpty(bdresults)) {
					for (PriceCalResultVO bdresult : bdresults) {
						if (bdresult.getType().equals(PriceCalTypeEnum.BIRTHDAY)) {
							calBirthdayResult = bdresult;
							break;
						}
					}
				}
				if (CollectionUtils.isNotEmpty(mbresults)) {
					for (PriceCalResultVO mbresult : mbresults) {
						if (mbresult.getType().equals(PriceCalTypeEnum.MEMBER_LEVEL)) {
							calMemberResult = mbresult;
							break;
						}
					}
				}
			}
			if (calBirthdayResult != null) {
				Map<ProductPack, BigDecimal> originPriceMap = Maps.newHashMap();
				Map<ProductPack, BigDecimal> finalPriceMap = Maps.newHashMap();
				for (ProductPack pack : packs) {
					PsSpvVO spv = pack.getSpv();
					PsProductVO product = mcPsProductService.findProdBySpvId(spv.getSpvId());
					if (product.getAllowBdDiscount() == 1) {// 商品参加生日折扣
						BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
						BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格

						List<PriceCalResultVO> results = spv.getBdPriceCalResults();
						PriceCalResultVO spvResult = getPriceCalResult(results, calBirthdayResult);
						if (null != spvResult) {
							BigDecimal originPrice = PriceUtil.keepToCent(spvResult.getOriginalPrice());
							BigDecimal finalPrice = PriceUtil.keepToCent(spvResult.getFinalPrice());
							calculatingPrice = calculatingPrice
									.add(originPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							calculatedPrice = calculatedPrice
									.add(finalPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							originPriceMap.put(pack, originPrice);
							finalPriceMap.put(pack, finalPrice);
							pack.setFactProductPrice(finalPrice);
							PriceStep step = new PriceStep();
							step.setPriceType(PriceType.BIRTHDAY);
							step.setExtId(member.getId());
							step.setOriginalPackPrice(originPriceMap);
							step.setFinalPackPrice(finalPriceMap);
							step.setCalculatingPrice(calculatingPrice);
							step.setCalculatedPrice(calculatedPrice);
							steps.add(step);
							// logger.info("生日折扣价格步骤：{}", step);
						}
					} else if (product.getAllowVipDiscount() == 1) {
						BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
						BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格
						List<PriceCalResultVO> results = spv.getPriceCalResults();
						PriceCalResultVO spvResult = getPriceCalResult(results, calMemberResult);
						if (null != spvResult) {
							BigDecimal originPrice = PriceUtil.keepToCent(spvResult.getOriginalPrice());
							BigDecimal finalPrice = PriceUtil.keepToCent(spvResult.getFinalPrice());
							calculatingPrice = calculatingPrice
									.add(originPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							calculatedPrice = calculatedPrice
									.add(finalPrice.multiply(BigDecimal.valueOf(pack.getCount())));
							originPriceMap.put(pack, originPrice);
							finalPriceMap.put(pack, finalPrice);
							pack.setFactProductPrice(finalPrice);

							PriceStep step = new PriceStep();
							step.setPriceType(PriceType.MEMBER_LEVEL);
							step.setExtId(member.getId());
							step.setOriginalPackPrice(originPriceMap);
							step.setFinalPackPrice(finalPriceMap);
							step.setCalculatingPrice(calculatingPrice);
							step.setCalculatedPrice(calculatedPrice);
							steps.add(step);
						}
					} else {
						BigDecimal calculatingPrice = BigDecimal.ZERO;// 计算前的价格
						BigDecimal calculatedPrice = BigDecimal.ZERO;// 计算后的价格

						BigDecimal price = PriceUtil.keepToCent(pack.getFactProductPrice());
						calculatingPrice = calculatingPrice.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
						calculatedPrice = calculatedPrice.add(price.multiply(BigDecimal.valueOf(pack.getCount())));
						originPriceMap.put(pack, price);
						finalPriceMap.put(pack, price);
						PriceStep step = new PriceStep();
						step.setPriceType(PriceType.BIRTHDAY);
						step.setExtId(member.getId());
						step.setOriginalPackPrice(originPriceMap);
						step.setFinalPackPrice(finalPriceMap);
						step.setCalculatingPrice(calculatingPrice);
						step.setCalculatedPrice(calculatedPrice);
						steps.add(step);
						logger.info("生日折扣价格步骤：{}", step.getSavedPrice());
					}
				}
			}
		}

		Date end = new Date();
		logger.info("计算会员生日折扣花费时间：{}毫秒", end.getTime() - start.getTime());
		return steps;
	}

	private final class CompareSpvPrice implements Comparator<ProductPack> {
		boolean is_Ascend;

		public CompareSpvPrice(boolean b) {
			// TODO Auto-generated constructor stub
			is_Ascend = b;
		}

		@Override
		public int compare(ProductPack o1, ProductPack o2) {
			// TODO Auto-generated method stub
			BigDecimal a, b;
			if (is_Ascend) {
				a = o1.getSpv().getSalesPrice();
				b = o2.getSpv().getSalesPrice();
			} else {
				a = o2.getSpv().getSalesPrice();
				b = o1.getSpv().getSalesPrice();
			}

			if (a.compareTo(b) > 0)
				return 1;
			else if (a.compareTo(b) == 0)
				return 0;
			else
				return -1;
		}
	}

	@Override
	public List<OpSalesOrderGiftCardVO> calculateGiftPrice(List<GiftCardVO> giftCards, BigDecimal orderPrice) {

		List<OpSalesOrderGiftCardVO> vos = new ArrayList<OpSalesOrderGiftCardVO>();

		if (CollectionUtils.isNotEmpty(giftCards)) {
			BigDecimal price = orderPrice;
			for (GiftCardVO giftCard : giftCards) {
				if (price.compareTo(BigDecimal.ZERO) > 0) {

					OpSalesOrderGiftCardVO step = new OpSalesOrderGiftCardVO();
					if (price.compareTo(giftCard.getAmount()) >= 0) {
						price = price.subtract(giftCard.getAmount());
						step.setGiftCardNo(giftCard.getCardNo());
						step.setGiftCardValue(giftCard.getAmount());
					} else {
						step.setGiftCardNo(giftCard.getCardNo());
						step.setGiftCardValue(price);

						price = price.subtract(price);
					}

					vos.add(step);
				}
			}
		}

		return vos;
	}

}
