package com.thebeastshop.pegasus.channelservice.service.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.privilege.service.InterestFreeService;
import com.thebeastshop.privilege.vo.InterestFreeCashVO;
import com.thebeastshop.privilege.vo.InterestFreeVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.service.CampaignQueryService;
import com.thebeastshop.campaign.vo.CampaignDetailVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.model.OrderFeeVO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.PriceStep;
import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.pegasus.channelservice.service.PostageService;
import com.thebeastshop.pegasus.component.delivery.constants.PostageConstant;
import com.thebeastshop.pegasus.merchandise.IService.IInterestGoodsService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.enums.CardsTypeEnum;
import com.thebeastshop.pegasus.service.operation.model.CardType;
import com.thebeastshop.pegasus.service.operation.vo.CardVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class PostageServiceImpl implements PostageService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	String startTime = "2017-07-31 00:00:00";// 海淘免邮开始时间
	String endTime = "2017-08-02 23:59:59";// 海淘免邮结束时间

	@Autowired
	private OverseaService overseaService;

	@Autowired
	private InterestFreeService interestFreeService;

	@Autowired
	private IInterestGoodsService iInterestGoodsService;

	@Autowired
	private CampaignQueryService campaignQueryService;

	private PegasusOperationServiceFacade instance = PegasusOperationServiceFacade.getInstance();

	@Override
	public BigDecimal calculatePostageNew(Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member,
			boolean hasOverSea) {

		return calculatePostage(hasOverSea, price, member);
	}

	@Override
	public BigDecimal calculatePostage(Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member) {
		boolean hasOverSea = isOverSea(packs);
		return calculatePostage(hasOverSea, price, member);
	}

	@Override
	public BigDecimal calculatePostage(boolean hasOverSea, BigDecimal price, MemberVO member) {
		BigDecimal postage = BigDecimal.ZERO;
		if (hasOverSea) {
			// 海淘商品邮费
			postage = PostageConstant.OVER_SEA_POSTAGE;
			// 使用海淘免邮卡

			if (member != null) {
				CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
				logger.info("海淘免邮卡信息:{}", card);
				if (card != null && card.getCardType() != null) {
					CardType cardType = card.getCardType();
					Date now = new Date();
					if (cardType.getId().equals(Long.valueOf(CardsTypeEnum.FREE_POSTAGE_CARD.getId()))
							&& now.after(cardType.getStartAt()) && now.before(cardType.getEndAt())
							&& cardType.getPriceYuan() != null) {
						logger.info("海淘免邮卡减免金额:{}", cardType.getPriceYuan());
						postage = PriceUtil.keepToCent(postage.subtract(cardType.getPriceYuan()));
						postage = postage.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : postage;
					}
				}
			}

			try {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String stime = PropConstants.getProperties("overSeasStartTime", startTime);
				String etime = PropConstants.getProperties("overSeasStartTime", endTime);

				if (StringUtils.isBlank(stime)) {
					stime = startTime;
				}

				if (StringUtils.isBlank(etime)) {
					etime = endTime;
				}

				// if (null != configurer.getProperty("overSeasStartTime")) {
				// stime = configurer.getProperty("overSeasStartTime");
				// }
				// if (null != configurer.getProperty("overSeasEndTime")) {
				// etime = configurer.getProperty("overSeasEndTime");
				// }
				logger.info("开始时间:startTime={}，overSeasStartTime={}", startTime, stime);
				logger.info("结束时间:endTime={},overSeasEndTime={}", endTime, etime);

				Date start = sdf.parse(stime);
				Date end = sdf.parse(etime);
				Date now = new Date();
				if (now.after(start) && now.before(end)) {
					postage = BigDecimal.ZERO;
				}
			} catch (ParseException e) {
				logger.error("海淘免邮异常：", e);
			}
		} else {
			// 普通商品邮费
			// 判断价格是否满足免邮
			if (price.compareTo(PostageConstant.MEET_PRICE) < 0) {
				postage = PostageConstant.NORMAL_PRICE;
			}
		}
		return postage;
	}

	@Override
	public List<PriceStepVO> calculatePostageWithStep(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			Collection<? extends CartProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO opChannelVO) {
		boolean hasOverSea = false;
		boolean hasInterestProductFreePost = this.isInterestProductFreePost(packs);
		int count = 0;

		List<String> productCodes = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				productCodes.add(pack.getProduct().getCode());
				if (overseaService.isOversea(spv)) {
					count++;
				}
			}
		}
		if (count > 0) {
			hasOverSea = true;
		}
		return calculatePostageWithStep(customizePrice, timeSlot, postageVO, hasOverSea, hasInterestProductFreePost,
				price, member, accessWay, productCodes, opChannelVO);
	}

	@Override
	public List<PriceStepVO> calculatePostageWithStepNew(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			Collection<? extends CartProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO opChannelVO, boolean hasOverSea) {

		boolean hasInterestProductFreePost = this.isInterestProductFreePost(packs);

		List<String> productCodes = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {

				productCodes.add(pack.getProduct().getCode());

			}
		}

		return calculatePostageWithStep(customizePrice, timeSlot, postageVO, hasOverSea, hasInterestProductFreePost,
				price, member, accessWay, productCodes, opChannelVO);
	}

	@Override
	public List<PriceStepVO> calculatePostageWithSteps(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			Collection<? extends ProductPack> packs, BigDecimal price, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO opChannelVO) {
		boolean hasOverSea = false;
		boolean hasInterestProductFreePost = this.isInterestProductFreePost(packs);
		int count = 0;

		List<String> productCodes = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (ProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				productCodes.add(pack.getProduct().getCode());
				if (overseaService.isOversea(spv)) {
					count++;
				}
			}
		}
		if (count > 0) {
			hasOverSea = true;
		}
		return calculatePostageWithStep(customizePrice, timeSlot, postageVO, hasOverSea, hasInterestProductFreePost,
				price, member, accessWay, productCodes, opChannelVO);
	}

	private List<PriceStepVO> calculatePostageWithStep(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			boolean hasOverSea, boolean hasInterestProductFreePost, BigDecimal price, MemberVO member,
			AccessWayEnum accessWay, List<String> productCodes, OpChannelVO opChannelVO) {

		List<PriceStepVO> steps = Lists.newArrayList();
		BigDecimal postage = BigDecimal.ZERO;
		if (hasOverSea && member != null) {
			// 海淘商品邮费
			postage = postage.add(PostageConstant.OVER_SEA_POSTAGE);
			steps.add(new PriceStepVO("海淘运费", PostageConstant.OVER_SEA_POSTAGE));
			// 使用海淘免邮卡
			CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
			logger.info("海淘免邮卡信息:{}", card);
			if (card != null && card.getCardType() != null) {
				CardType cardType = card.getCardType();
				Date now = new Date();
				if (cardType.getId().equals(Long.valueOf(CardsTypeEnum.FREE_POSTAGE_CARD.getId()))
						&& now.after(cardType.getStartAt()) && now.before(cardType.getEndAt())
						&& cardType.getPriceYuan() != null) {
					logger.info("海淘免邮卡减免金额:{}", cardType.getPriceYuan());
					BigDecimal cardFee = cardType.getPriceYuan();
					cardFee = cardFee.compareTo(PostageConstant.OVER_SEA_POSTAGE) < 0 ? cardFee
							: PostageConstant.OVER_SEA_POSTAGE;
					postage = postage.add(cardFee);
					steps.add(new PriceStepVO("海淘运费免邮卡减免", BigDecimal.ZERO.subtract(cardFee)));// 文案待定
				}
			}
			// TODO:补丁: 海淘运费为0元（12月15日中午12：00 ~ 12月25日23：59）
			try {
				String stime = PropConstants.getProperties("overSeasStartTime", startTime);
				String etime = PropConstants.getProperties("overSeasStartTime", endTime);

				if (StringUtils.isBlank(stime)) {
					stime = startTime;
				}

				if (StringUtils.isBlank(etime)) {
					etime = endTime;
				}

				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				// if (null != configurer.getProperty("overSeasStartTime")) {
				// stime = configurer.getProperty("overSeasStartTime");
				// }
				// if (null != configurer.getProperty("overSeasEndTime")) {
				// etime = configurer.getProperty("overSeasEndTime");
				// }
				logger.info("开始时间:startTime={}，overSeasStartTime={}", startTime, stime);
				logger.info("结束时间:endTime={},overSeasEndTime={}", endTime, etime);

				Date start = sdf.parse(stime);
				Date end = sdf.parse(etime);
				Date now = new Date();
				if (now.after(start) && now.before(end)) {
					if (postage.compareTo(BigDecimal.ZERO) > 0) {
						steps.add(new PriceStepVO("海淘运费减免", BigDecimal.ZERO.subtract(postage)));
						postage = postage.subtract(postage);
					}
				}
			} catch (ParseException e) {
				logger.error("海淘免邮异常：", e);
			}
		} else {

			// **********偏远地区配送费*********
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					steps.add(new PriceStepVO("配送运费", BigDecimal.ZERO.add(deliveryFee)));
				} else {

					// 如果是线下渠道，用线下传进来的费用
					if (opChannelVO != null && opChannelVO.getChannelType() == 1) {

						BigDecimal normalPostage = BigDecimal.ZERO;
						// 存在运费的时候
						if (postageVO != null) {
							if (postageVO.getNormal() != null) {
								normalPostage = postageVO.getNormal();
							}
							if (postageVO.getFaraway() != null && postageVO.getFaraway().doubleValue() > 0) {
								normalPostage = postageVO.getFaraway();
							}
							if (postageVO.getEDT() != null) {
								normalPostage = normalPostage.add(postageVO.getEDT());
							}

						}

						postage = postage.add(normalPostage);
						steps.add(new PriceStepVO("运费", normalPostage));
					} else {
						// 普通商品邮费(存在偏远地区配送费的时候，免去普通运费)
						// 判断价格是否满足免邮
						postage = postage.add(PostageConstant.NORMAL_PRICE);
						steps.add(new PriceStepVO("运费", PostageConstant.NORMAL_PRICE));
						if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
							postage = postage.subtract(postage);
							steps.add(new PriceStepVO("实付99元免运费",
									BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE)));
						}
					}

				}
			} else {
				// 如果是线下渠道，用线下传进来的费用
				if (opChannelVO != null && opChannelVO.getChannelType() == 1) {
					BigDecimal normalPostage = BigDecimal.ZERO;
					// 存在运费的时候
					if (postageVO != null) {
						if (postageVO.getNormal() != null) {
							normalPostage = postageVO.getNormal();
						}
						if (postageVO.getFaraway() != null && postageVO.getFaraway().doubleValue() > 0) {
							normalPostage = postageVO.getFaraway();
						}
						if (postageVO.getEDT() != null) {
							normalPostage = normalPostage.add(postageVO.getEDT());
						}

					}
					postage = postage.add(normalPostage);
					steps.add(new PriceStepVO("运费", normalPostage));
				} else {
					// 普通商品邮费(存在偏远地区配送费的时候，免去普通运费)
					// 判断价格是否满足免邮
					postage = postage.add(PostageConstant.NORMAL_PRICE);
					steps.add(new PriceStepVO("运费", PostageConstant.NORMAL_PRICE));
					if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
						postage = postage.subtract(postage);
						steps.add(new PriceStepVO("实付99元免运费", BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE)));
					}
				}

			}

		}

		// 权益商品免邮
		if (postage.compareTo(BigDecimal.ZERO) > 0 && hasInterestProductFreePost) {
			steps.add(new PriceStepVO("商品权益免运费", BigDecimal.ZERO.subtract(postage)));

			// 免邮权益
		} else if (member != null && postage.compareTo(BigDecimal.ZERO) > 0) {
			InterestFreeVO interestFreeVO = getInterestFree(member, productCodes, accessWay,opChannelVO);
			if (null != interestFreeVO) {
				// 区分会员权益
				if (null != interestFreeVO.getProvideChannel() && "0".equals(interestFreeVO.getProvideChannel())) {
					steps.add(new PriceStepVO(member.getMemberLevelDesc() + "免运费", BigDecimal.ZERO.subtract(postage)));
				} else {
					steps.add(new PriceStepVO("免邮权益免运费", BigDecimal.ZERO.subtract(postage)));
				}
			}
		}

		if (member != null && BigDecimal.ZERO.compareTo(customizePrice) < 0) {
			steps.add(new PriceStepVO("定制费", BigDecimal.ZERO.add(customizePrice)));
			// 大象会员减免定制费
			if (MemberLevelEnum.VIP4.getCode().equals(member.getMemberLevel())) {
				steps.add(new PriceStepVO("大象会员免定制费", BigDecimal.ZERO.subtract(customizePrice)));
			}
		}
		// **********时段配送费用*********

		BigDecimal extraDeliveryFee = BigDecimal.ZERO;

		if (timeSlot != 0) {

			if (postageVO != null && postageVO.getEDT() != null) {
				extraDeliveryFee = postageVO.getEDT();
			} else {
				// 默认60元
				extraDeliveryFee = BigDecimal.valueOf(60);
			}
		}

		if (timeSlot != 0 && extraDeliveryFee != null) {
			if (!extraDeliveryFee.equals(BigDecimal.ZERO)) {
				steps.add(new PriceStepVO("精确时段配送费", BigDecimal.ZERO.add(extraDeliveryFee)));
			}
		}
		return steps;
	}

	/**
	 * 获取运费权益
	 * 
	 * @param member
	 * @param productCodes
	 * @param accessWay
	 * @return
	 */
	private InterestFreeVO getInterestFree(MemberVO member, List<String> productCodes, AccessWayEnum accessWay,OpChannelVO channel) {
		InterestFreeVO interestFreeVO = null;
		if (CollectionUtils.isNotEmpty(productCodes)) {
			InterestFreeCashVO interestFreeCashVO = new InterestFreeCashVO();
			interestFreeCashVO.setMemberId(member.getId().intValue());
			interestFreeCashVO.setProdCodes(productCodes);
			interestFreeCashVO.setAccessWay(accessWay);
			if(channel != null){
				interestFreeCashVO.setStoreChannel(channel.getCode());
			}
			ServiceResp<InterestFreeVO> resp = interestFreeService.getOptimallyUsableInterestFree(interestFreeCashVO);
			if (resp.getBean() != null) {
				interestFreeVO = resp.getBean();
				logger.info("会员有免邮权益id:{},名字：{}", interestFreeVO.getId(), interestFreeVO.getInterestFreeName());
			}
		}
		return interestFreeVO;
	}

	@Override
	public OrderFeeVO calculateServiceFee(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			Collection<? extends ProductPack> packs, BigDecimal price, BigDecimal remoteFee, MemberVO member,
			AccessWayEnum accessWay) {
		boolean hasOverSea = false;
		boolean hasInterestProductFreePost = this.isInterestProductFreePost(packs);
		int count = 0;

		List<String> productCodes = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (ProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				productCodes.add(pack.getProduct().getCode());
				if (overseaService.isOversea(spv)) {
					count++;
				}
			}
		}
		if (count > 0) {
			hasOverSea = true;
		}
		return calculateServiceFee(customizePrice, timeSlot, postageVO, hasOverSea, hasInterestProductFreePost, price,
				remoteFee, member, accessWay, productCodes);
	}

	@Override
	public OrderFeeVO calculateServiceFeeNew(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			Collection<? extends ProductPack> packs, BigDecimal price, BigDecimal remoteFee, MemberVO member,
			AccessWayEnum accessWay, boolean hasOverSea) {

		boolean hasInterestProductFreePost = this.isInterestProductFreePost(packs);

		List<String> productCodes = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (ProductPack pack : packs) {

				productCodes.add(pack.getProduct().getCode());

			}
		}

		return calculateServiceFee(customizePrice, timeSlot, postageVO, hasOverSea, hasInterestProductFreePost, price,
				remoteFee, member, accessWay, productCodes);
	}

	private OrderFeeVO calculateServiceFee(BigDecimal customizePrice, int timeSlot, PostageVO postageVO,
			boolean hasOverSea, boolean hasInterestProductFreePost, BigDecimal price, BigDecimal remoteFee,
			MemberVO member, AccessWayEnum accessWay, List<String> productCodes) {
		OrderFeeVO orderFee = new OrderFeeVO();
		List<ServiceFeeStep> postageSteps = Lists.newArrayList();
		List<ServiceFeeStep> overseasSteps = Lists.newArrayList();
		List<ServiceFeeStep> customizeSteps = Lists.newArrayList();
		BigDecimal postage = BigDecimal.ZERO;
		if (hasOverSea) {
			// 海淘商品邮费
			postage = postage.add(PostageConstant.OVER_SEA_POSTAGE);
			overseasSteps.add(new ServiceFeeStep("海淘运费", PostageConstant.OVER_SEA_POSTAGE, PriceType.OVERSEAS));

			if (member != null) {
				// 使用海淘免邮卡
				CardVO card = instance.ifMemberOwnFreePostage(member.getCode());
				logger.info("海淘免邮卡信息:{}", card);
				if (card != null && card.getCardType() != null) {
					CardType cardType = card.getCardType();
					Date now = new Date();
					if (cardType.getId().equals(Long.valueOf(CardsTypeEnum.FREE_POSTAGE_CARD.getId()))
							&& now.after(cardType.getStartAt()) && now.before(cardType.getEndAt())
							&& cardType.getPriceYuan() != null) {
						logger.info("海淘免邮卡减免金额:{}", cardType.getPriceYuan());
						BigDecimal cardFee = cardType.getPriceYuan();
						cardFee = cardFee.compareTo(PostageConstant.OVER_SEA_POSTAGE) < 0 ? cardFee
								: PostageConstant.OVER_SEA_POSTAGE;
						postage = postage.add(cardFee);
						overseasSteps.add(
								new ServiceFeeStep("海淘运费免邮卡减免", BigDecimal.ZERO.subtract(cardFee), PriceType.OVERSEAS));// 文案待定
					}
				}
			}

			// TODO:补丁: 海淘运费为0元（12月15日中午12：00 ~ 12月25日23：59）
			try {

				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String stime = PropConstants.getProperties("overSeasStartTime", startTime);
				String etime = PropConstants.getProperties("overSeasStartTime", endTime);

				if (StringUtils.isBlank(stime)) {
					stime = startTime;
				}

				if (StringUtils.isBlank(etime)) {
					etime = endTime;
				}
				logger.info("开始时间:startTime={}，overSeasStartTime={}", startTime, stime);
				logger.info("结束时间:endTime={},overSeasEndTime={}", endTime, etime);

				Date start = sdf.parse(stime);
				Date end = sdf.parse(etime);
				Date now = new Date();
				if (now.after(start) && now.before(end)) {
					if (postage.compareTo(BigDecimal.ZERO) > 0) {
						overseasSteps.add(
								new ServiceFeeStep("海淘运费减免", BigDecimal.ZERO.subtract(postage), PriceType.OVERSEAS));
						postage = postage.subtract(postage);
					}
				}
			} catch (ParseException e) {
				logger.error("海淘免邮异常：", e);
			}

			// 权益商品免邮
			if (postage.compareTo(BigDecimal.ZERO) > 0 && hasInterestProductFreePost) {
				overseasSteps.add(new ServiceFeeStep("商品权益免运费", BigDecimal.ZERO.subtract(postage), PriceType.OVERSEAS));
				// 免邮权益
			} else if (postage.compareTo(BigDecimal.ZERO) > 0 && member != null) {
				InterestFreeVO interestFreeVO = getInterestFree(member, productCodes, accessWay,null);
				if (null != interestFreeVO) {
					// 区分会员权益
					if (null != interestFreeVO.getProvideChannel() && "0".equals(interestFreeVO.getProvideChannel())) {
						overseasSteps.add(new ServiceFeeStep(member.getMemberLevelDesc() + "免运费",
								BigDecimal.ZERO.subtract(postage), PriceType.OVERSEAS));
					} else {
						overseasSteps.add(
								new ServiceFeeStep("免邮权益免运费", BigDecimal.ZERO.subtract(postage), PriceType.OVERSEAS));
					}
					orderFee.setInterest(interestFreeVO.getProvideId());
				}
			}
		} else {

			// **********偏远地区配送费*********
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					postageSteps.add(new ServiceFeeStep("配送运费", BigDecimal.ZERO.add(deliveryFee), PriceType.POSTAGE));
				} else if (remoteFee.compareTo(BigDecimal.ZERO) > 0) {
					postageSteps.add(new ServiceFeeStep("配送运费", BigDecimal.ZERO.add(remoteFee), PriceType.POSTAGE));
				} else {
					// 普通商品邮费(存在偏远地区配送费的时候，免去普通运费)
					if (AccessWayEnum.OFFLINE.getCode().equals(accessWay.getCode())) {
						// 线下指定普通运费
						if (postageVO.getNormal() != null) {
							postage = postage.add(postageVO.getNormal());
							postageSteps.add(new ServiceFeeStep("运费", postageVO.getNormal(), PriceType.POSTAGE));
						}
					} else {
						// 线上默认普通运费10元
						postage = postage.add(PostageConstant.NORMAL_PRICE);
						postageSteps.add(new ServiceFeeStep("运费", PostageConstant.NORMAL_PRICE, PriceType.POSTAGE));
						// 判断价格是否满足免邮
						if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
							postage = postage.subtract(postage);
							postageSteps.add(new ServiceFeeStep("实付99元免运费",
									BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE), PriceType.POSTAGE));
						}
						// 权益商品免邮
						if (postage.compareTo(BigDecimal.ZERO) > 0 && hasInterestProductFreePost) {
							postageSteps.add(new ServiceFeeStep("商品权益免运费", BigDecimal.ZERO.subtract(postage),
									PriceType.POSTAGE));
							// 免邮权益
						} else if (postage.compareTo(BigDecimal.ZERO) > 0 && member != null) {
							InterestFreeVO interestFreeVO = getInterestFree(member, productCodes, accessWay,null);
							if (null != interestFreeVO) {
								// 区分会员权益
								if (null != interestFreeVO.getProvideChannel()
										&& "0".equals(interestFreeVO.getProvideChannel())) {
									postageSteps.add(new ServiceFeeStep(member.getMemberLevelDesc() + "免运费",
											BigDecimal.ZERO.subtract(postage), PriceType.POSTAGE));
								} else {
									postageSteps.add(new ServiceFeeStep("免邮权益免运费", BigDecimal.ZERO.subtract(postage),
											PriceType.POSTAGE));
								}
								orderFee.setInterest(interestFreeVO.getProvideId());
							}
						}
					}
				}
			} else {
				if (remoteFee.compareTo(BigDecimal.ZERO) > 0) {
					postageSteps.add(new ServiceFeeStep("配送运费", BigDecimal.ZERO.add(remoteFee), PriceType.POSTAGE));
				} else {
					// 普通商品邮费(存在偏远地区配送费的时候，免去普通运费)
					if (AccessWayEnum.OFFLINE.getCode().equals(accessWay.getCode())) {
						// 线下指定普通运费
						if (postageVO.getNormal() != null) {
							postage = postage.add(postageVO.getNormal());
							postageSteps.add(new ServiceFeeStep("运费", postageVO.getNormal(), PriceType.POSTAGE));
						}
					} else {
						// 线上默认普通运费10元
						postage = postage.add(PostageConstant.NORMAL_PRICE);
						postageSteps.add(new ServiceFeeStep("运费", PostageConstant.NORMAL_PRICE, PriceType.POSTAGE));
						// 判断价格是否满足免邮
						if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
							postage = postage.subtract(postage);
							postageSteps.add(new ServiceFeeStep("实付99元免运费",
									BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE), PriceType.POSTAGE));
						}
						// 权益商品免邮
						if (postage.compareTo(BigDecimal.ZERO) > 0 && hasInterestProductFreePost) {
							postageSteps.add(new ServiceFeeStep("商品权益免运费", BigDecimal.ZERO.subtract(postage),
									PriceType.POSTAGE));
						} else if (postage.compareTo(BigDecimal.ZERO) > 0 && member != null) {
							InterestFreeVO interestFreeVO = getInterestFree(member, productCodes, accessWay,null);
							if (null != interestFreeVO) {
								// 区分会员权益
								if (null != interestFreeVO.getProvideChannel()
										&& "0".equals(interestFreeVO.getProvideChannel())) {
									postageSteps.add(new ServiceFeeStep(member.getMemberLevelDesc() + "免运费",
											BigDecimal.ZERO.subtract(postage), PriceType.POSTAGE));
								} else {
									postageSteps.add(new ServiceFeeStep("免邮权益免运费", BigDecimal.ZERO.subtract(postage),
											PriceType.POSTAGE));
								}
								orderFee.setInterest(interestFreeVO.getProvideId());
							}
						}
					}
				}
			}
		}

		if (BigDecimal.ZERO.compareTo(customizePrice) < 0 && member != null) {
			customizeSteps.add(new ServiceFeeStep("定制费", BigDecimal.ZERO.add(customizePrice), PriceType.CUSTOMIZE));
			// 大象会员减免定制费
			if (MemberLevelEnum.VIP4.getCode().equals(member.getMemberLevel())) {
				customizeSteps.add(
						new ServiceFeeStep("大象会员免定制费", BigDecimal.ZERO.subtract(customizePrice), PriceType.CUSTOMIZE));
			}
		}
		// **********时段配送费用*********

		BigDecimal extraDeliveryFee = BigDecimal.ZERO;

		if (timeSlot != 0) {

			if (postageVO != null && postageVO.getEDT() != null) {
				extraDeliveryFee = postageVO.getEDT();
			} else {
				// 默认60元
				extraDeliveryFee = BigDecimal.valueOf(60);
			}
		}

		if (timeSlot != 0 && extraDeliveryFee != null) {
			if (!extraDeliveryFee.equals(BigDecimal.ZERO)) {
				postageSteps.add(new ServiceFeeStep("精确时段配送费", BigDecimal.ZERO.add(extraDeliveryFee), PriceType.TIME));
			}
		}
		orderFee.setCustomizeSteps(customizeSteps);
		orderFee.setOverseasSteps(overseasSteps);
		orderFee.setPostageSteps(postageSteps);
		return orderFee;
	}

	@Override
	public List<PriceStepVO> switchPriceSteps(PriceResult priceResult, List<PriceStepVO> serviceSteps) {
		List<PriceStepVO> priceSteps = Lists.newArrayList();
		// *******商品总额******
		BigDecimal totalPrice = priceResult.getTotalPrice();// 商品总额

		priceSteps.add(new PriceStepVO("商品总额", totalPrice));

		// *******优惠******
		BigDecimal birth = BigDecimal.ZERO;
		BigDecimal memb = BigDecimal.ZERO;
		BigDecimal coupon = BigDecimal.ZERO;
		List<PriceStep> steps = priceResult.getSteps();
		// 活动价格步骤
		Collection<PriceStepVO> campaignSteps = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(steps)) {
			Integer discountType;
			for (PriceStep step : steps) {
				BigDecimal savedPrice = step.getSavedPrice();
				if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
					if (step.getPriceType().equals(PriceType.MEMBER_LEVEL)) {
						memb = memb.add(savedPrice);
					} else if (step.getPriceType().equals(PriceType.BIRTHDAY)) {
						birth = birth.add(savedPrice);
					} else if (step.getPriceType().equals(PriceType.CAMPAIGN)) {
						CampaignDetailVO campaign = campaignQueryService.getCampaignById(step.getExtId());
						discountType = campaign.getDiscountType();
						campaignSteps.add(new PriceStepVO(DiscountTypeEnum.getEnumById(discountType).getName(),
								BigDecimal.ZERO.subtract(savedPrice)));
					} else if (step.getPriceType().equals(PriceType.COUPON)) {
						coupon = coupon.add(savedPrice);
					}
				}
			}
		}
		if (memb.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new PriceStepVO("会员折扣", BigDecimal.ZERO.subtract(memb)));
		}
		if (birth.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new PriceStepVO("生日折扣", BigDecimal.ZERO.subtract(birth)));
		}
		if (CollectionUtils.isNotEmpty(campaignSteps)) {
			priceSteps.addAll(campaignSteps);
		}
		if (coupon.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new PriceStepVO("优惠券", BigDecimal.ZERO.subtract(coupon)));
		}

		if (CollectionUtils.isNotEmpty(serviceSteps)) {
			priceSteps.addAll(serviceSteps);
		}
		return priceSteps;
	}

	@Override
	public BigDecimal calculatePayment(PriceResult priceResult, List<ServiceFeeStep> serviceSteps) {
		BigDecimal price = priceResult.getTotalPrice().subtract(priceResult.getSavedPrice());// 总价减去折扣价

		logger.info("价格折扣计算后价格pirce=" + price.toString());
		for (ServiceFeeStep serviceStep : serviceSteps) {
			price = price.add(serviceStep.getPrice());
			logger.info("每一步价格" + serviceStep.getName() + serviceStep.getPrice().toString());
		}

		logger.info("价格核对计算总价pirce" + price.toString());
		return price;
	}

	/**
	 * 是否权益商品免邮
	 * 
	 * @param packs
	 * @return
	 */
	private Boolean isInterestProductFreePost(Collection<? extends ProductPack> packs) {
		Boolean flag = false;
		if (CollectionUtils.isNotEmpty(packs)) {
			for (ProductPack pack : packs) {
				if (CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
					InterestGoods interest = iInterestGoodsService
							.selectInterestById(Integer.parseInt(pack.getSourceBindVal()));
					if (YesOrNo.YES.getId().equals(interest.getIsFreePost())) {
						flag = true;
						break;
					}
				}
			}
		}
		logger.info("权益商品是否免邮判断：" + flag);
		return flag;
	}

	/**
	 * 是否海淘
	 * 
	 * @param packs
	 * @return
	 */
	private Boolean isOverSea(Collection<? extends ProductPack> packs) {
		boolean flag = false;
		List<PsSpvVO> psSpvVOs = new ArrayList<>();
		for (ProductPack pack : packs) {
			psSpvVOs.add(pack.getSpv());
			/*
			 * PsSpvVO spv = pack.getSpv(); if (overseaService.isOversea(spv)) {
			 * flag = true; break; }
			 */
		}
		flag = overseaService.isOverseas(psSpvVOs);
		logger.info("商品包是否海淘判断：" + flag);
		return flag;
	}

}
