package com.thebeastshop.pegasus.channelservice.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

/**
 * @author Liang Wenjian
 */
@Service
public class OverseaServiceImpl implements OverseaService {

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	private boolean checkSkusIsOversea(List<PsSkuVO> skus) {
		if (CollectionUtils.isNotEmpty(skus)) {
			for (PsSkuVO sku : skus) {
				if (sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
					return true;
				}
			}
		}
		return false;
	}
	// ==============华丽丽的分割线===============

	@Override
	public boolean isOversea(PsProductVO product) {
		boolean isHasOverSea = false;
		if (product != null && product.getCrossBorderFlag() != null && product.getCrossBorderFlag().equals(1)) {
			isHasOverSea = true;
		}
		return isHasOverSea;
	}

	@Override
	public boolean isOversea(PsSpvVO spv) {
		if (spv != null) {
			List<String> skuCodes = Lists.newArrayList();
			if (spv.getCombined()) {
				for (PsSkuCombinationVO skuComn : spv.getSkuCombinationList()) {
					skuCodes.add(skuComn.getSubSkuCode());
				}
			} else {
				skuCodes.add(spv.getSkuCode());
			}
			List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
			return checkSkusIsOversea(skus);
		}
		return false;
	}

	@Override
	public boolean isOverseas(List<PsSpvVO> spvs) {
		List<String> skuCodes = Lists.newArrayList();
		for(PsSpvVO psSpvVO : spvs){
			if (psSpvVO != null) {
				if (psSpvVO.getCombined()) {
					for (PsSkuCombinationVO skuComn : psSpvVO.getSkuCombinationList()) {
						skuCodes.add(skuComn.getSubSkuCode());
					}
				} else {
					skuCodes.add(psSpvVO.getSkuCode());
				}

			}
		}
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
		return checkSkusIsOversea(skus);
	}

	@Override
	public boolean isOversea(List<? extends ProductPack> packs) {
		// =========是否包含海外购商品 XXX: 性能可能需要优化===========
		boolean isHasOverSea = false;
		for (ProductPack pack : packs) {
			PsProductVO product = pack.getProduct();
			if (isOversea(product)) {
				isHasOverSea = true;
				
				
				break;
			}
		}
		return isHasOverSea;
	}

	@Override
	public int isOverseaOrPhoto(List<? extends ProductPack> packs) {
		
		int isOverseaOrPhoto = 0;
		// =========是否包含海外购商品 XXX: 性能可能需要优化===========
		for (ProductPack pack : packs) {
			PsProductVO product = pack.getProduct();
			
			if(isOverseaOrPhoto == 2){
				
				break;
			}
			
			if (isOversea(product)) {
				isOverseaOrPhoto = 1;
				
			
					if(pack.getProduct().getCombined()){
						
						if(CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())){
							for(PsSkuCombinationVO sku:pack.getSpv().getSkuCombinationList()){
								
								if(sku.getSubSkuVO().getClearanceWay() ==2){
									isOverseaOrPhoto = 2;
								}
									break;
								}
							}
						
						
					} else {
						
						if(pack.getSpv()!=null && pack.getSpv().getSkuVO() !=null && pack.getSpv().getSkuVO().getClearanceWay() == 2){
							isOverseaOrPhoto = 2;
							
						}

					}
				}

		}
		return isOverseaOrPhoto;
	}
	@Override
	public Map<PsProductVO, Boolean> mapProductsIsOversea(Collection<PsProductVO> products) {
		Map<PsProductVO, Boolean> map = Maps.newHashMap();
		for (PsProductVO product : products) {
			map.put(product, isOversea(product));
		}
		return map;
	}

	@Override
	public Map<Long, Boolean> mapProductIdsIsOversea(List<Long> productIds) {
		Map<Long, Boolean> map = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(productIds)) {
			for (Long productId : productIds) {
				PsProductVO product = mcPsProductService.findByProdId(productId);
				map.put(productId, isOversea(product));
			}
		}
		return map;
	}

	@Override
	public Map<PsSpvVO, Boolean> mapSpvsIsOversea(Collection<PsSpvVO> spvs) {
		Map<PsSpvVO, Boolean> map = Maps.newHashMap();
		for (PsSpvVO spv : spvs) {
			map.put(spv, isOversea(spv));
		}
		return map;
	}

}
