// package com.thebeastshop.pegasus.channelservice.service.impl;
//
// import java.math.BigDecimal;
// import java.util.Collection;
// import java.util.Date;
// import java.util.HashMap;
// import java.util.List;
// import java.util.Map;
// import java.util.Map.Entry;
//
// import org.apache.commons.collections.CollectionUtils;
// import org.slf4j.Logger;
// import org.slf4j.LoggerFactory;
// import org.springframework.beans.factory.annotation.Autowired;
// import org.springframework.stereotype.Service;
//
// import com.google.common.collect.Lists;
// import com.thebeastshop.campaign.enums.DiscountTypeEnum;
// import com.thebeastshop.campaign.service.CampaignQueryService;
// import com.thebeastshop.campaign.vo.CampaignDetailVO;
// import com.thebeastshop.cart.ProductPack;
// import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
// import com.thebeastshop.pegasus.channelservice.model.OrderFeeVO;
// import com.thebeastshop.pegasus.channelservice.model.OrderSnapshotDTO;
// import com.thebeastshop.pegasus.channelservice.model.PriceResult;
// import com.thebeastshop.pegasus.channelservice.model.PriceStep;
// import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
// import com.thebeastshop.pegasus.channelservice.service.PriceService;
// import com.thebeastshop.pegasus.channelservice.service.price.OrderPrice;
// import
// com.thebeastshop.pegasus.channelservice.service.price.OrderPriceProduct;
// import com.thebeastshop.pegasus.channelservice.service.price.OrderPriceSku;
// import
// com.thebeastshop.pegasus.channelservice.service.price.dao.OrderPriceSkuDao;
// import
// com.thebeastshop.pegasus.channelservice.service.price.service.OrderPriceProductService;
// import
// com.thebeastshop.pegasus.channelservice.service.price.service.OrderPriceService;
// import com.thebeastshop.pegasus.component.delivery.constants.PostageConstant;
// import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
// import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
// import com.thebeastshop.price.enums.PrsPriceTypeEnum;
// import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
// import com.thebeastshop.price.vo.PrsPriceStepVO;
// import com.thebeastshop.price.vo.PrsSkuPriceStepVO;
// import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
// import com.thebeastshop.support.enums.PriceType;
// import com.thebeastshop.support.vo.giftcard.GiftCardVO;
//
/// **
// * XXX：订单快照服务（该服务应该是在订单模块中的，不应该出现在业务逻辑层，因为目前订单模块需要重构，所以暂时把这个服务放到这里）
// *
// * @author Paul-xiong
// */
// @Service
// public class OrderSnapshotServiceImpl implements OrderSnapshotService {
//
// protected Logger logger = LoggerFactory.getLogger(getClass());
//
// @Autowired
// private OrderPriceSkuDao orderPriceSkuDao;
//
// @Autowired
// private OrderPriceService orderPriceService;
//
// @Autowired
// private OrderPriceProductService orderPriceProductService;
//
// @Autowired
// private McPsSpvService mcPsSpvService;
//
// @Autowired
// private PriceService priceService;
//
// @Autowired
// private CampaignQueryService campaignQueryService;
//
// // =============private=============
// /**
// * 保存订单活动商品快照
// *
// * @param orderId
// * @param step
// */
// private void saveOrderPriceProduct(Long orderId, PriceStep step, int sort) {
// if (step != null) {
// Map<ProductPack, BigDecimal> rawPriceMap = step.getOriginalPackPrice();//
// 价格计算前的商品价格
// Map<ProductPack, BigDecimal> priceMap = step.getFinalPackPrice();//
// 价格计算后的商品价格
// if (rawPriceMap != null && !rawPriceMap.isEmpty() && priceMap != null &&
// !priceMap.isEmpty()) {
// List<OrderPriceProduct> orderPriceProducts = Lists.newArrayList();
// for (Entry<ProductPack, BigDecimal> entry : rawPriceMap.entrySet()) {
// ProductPack pack = entry.getKey();
// BigDecimal savedPrice = rawPriceMap.get(pack).subtract(priceMap.get(pack));
// if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
// PsSpvVO spv = mcPsSpvService.findBySpvId(pack.getSpvId());
// OrderPriceProduct orderPriceProduct = new OrderPriceProduct();
// orderPriceProduct.setOrderId(orderId);
// orderPriceProduct.setType(step.getPriceType());
// orderPriceProduct.setExtId(step.getExtId());
// orderPriceProduct.setSpvId(pack.getSpvId());
// orderPriceProduct.setSpvPrice(spv.getSalesPrice());
// orderPriceProduct.setSavedPrice(savedPrice);
// orderPriceProduct.setCount(pack.getCount());
// orderPriceProduct.setSort(sort);
// orderPriceProduct.setCreateTime(new Date());
// orderPriceProducts.add(orderPriceProduct);
// }
// }
// orderPriceProductService.save(orderPriceProducts);
// }
// }
// }
//
// /**
// * 保存订单活动商品快照
// *
// * @param orderId
// * @param steps
// */
// private void saveOrderPriceProductBySteps(Long orderId, List<PriceStep>
// steps) {
//
// List<OrderPriceProduct> orderPriceProducts = Lists.newArrayList();
// List<Long> spvIds = Lists.newArrayList();
// Integer sort = 1;
// for (PriceStep step : steps) {
// // 保存活动价格商品OrderPriceSku
// sort++;
// Map<ProductPack, BigDecimal> rawPriceMap = step.getOriginalPackPrice();//
// 价格计算前的商品价格
// Map<ProductPack, BigDecimal> priceMap = step.getFinalPackPrice();//
// 价格计算后的商品价格
// if (rawPriceMap != null && !rawPriceMap.isEmpty() && priceMap != null &&
// !priceMap.isEmpty()) {
// for (Entry<ProductPack, BigDecimal> entry : rawPriceMap.entrySet()) {
// ProductPack pack = entry.getKey();
// BigDecimal savedPrice = rawPriceMap.get(pack).subtract(priceMap.get(pack));
// if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
// spvIds.add(pack.getSpvId());
// OrderPriceProduct orderPriceProduct = new OrderPriceProduct();
// orderPriceProduct.setOrderId(orderId);
// orderPriceProduct.setType(step.getPriceType());
// orderPriceProduct.setExtId(step.getExtId());
// orderPriceProduct.setSpvId(pack.getSpvId());
// orderPriceProduct.setSavedPrice(savedPrice);
// orderPriceProduct.setCount(pack.getCount());
// orderPriceProduct.setSort(sort);
// orderPriceProduct.setCreateTime(new Date());
// orderPriceProducts.add(orderPriceProduct);
// }
// }
// }
// }
//
// if (CollectionUtils.isNotEmpty(spvIds)) {
// List<PsSpvVO> spvs = mcPsSpvService.findBySpvIds(spvIds);
// Map<Long, PsSpvVO> spvMap = new HashMap<>();
// for (PsSpvVO spvVO : spvs) {
// spvMap.put(spvVO.getSpvId(), spvVO);
// }
//
// if (CollectionUtils.isNotEmpty(orderPriceProducts)) {
// for (OrderPriceProduct priceProduct : orderPriceProducts) {
// PsSpvVO spvVO = spvMap.get(priceProduct.getSpvId());
// priceProduct.setSpvPrice(spvVO.getSalesPrice());
// }
// orderPriceProductService.save(orderPriceProducts);
// }
//
// }
//
// }
//
// // =================================
//
// @Override
// public void saveSnapshot(OrderSnapshotDTO dto) {
// try {
// List<? extends ProductPack> packs = dto.getPacks();
// // 价格计算
// CalculateProductPackDTO calProductPackDTO = new CalculateProductPackDTO();
// calProductPackDTO.setAccessWay(dto.getAccessWay());
// calProductPackDTO.setOpChannel(dto.getOpChannel());
// calProductPackDTO.setMember(dto.getMember());
// calProductPackDTO.setPacks(packs);
// calProductPackDTO.setCouponId(dto.getCouponId());
// calProductPackDTO.setBirthday(dto.isBirthday());
// PriceResult priceResult =
// priceService.calculateProductPackPrice(calProductPackDTO);
//
// if (priceResult != null) {
// List<PriceStep> steps = priceResult.getSteps();
// if (CollectionUtils.isNotEmpty(steps)) {
// List<OrderPrice> orderPrices = Lists.newArrayList();
// int sort = 1;
// for (PriceStep step : steps) {
// OrderPrice orderPrice = new OrderPrice();
// orderPrice.setType(step.getPriceType());
// orderPrice.setExtId(step.getExtId());
// orderPrice.setOrderId(dto.getOrderId());
// orderPrice.setSavedPrice(step.getSavedPrice());
// orderPrice.setSort(sort);
// orderPrice.setCreateTime(new Date());
// orderPrices.add(orderPrice);
// sort++;
// }
// this.saveOrderPriceProductBySteps(dto.getOrderId(), steps);
// orderPriceService.save(orderPrices);
// }
// }
// } catch (Exception e) {
// logger.error("保存订单快照异常，e:{}", e);
// }
// }
//
// @Override
// public void saveOrderSnapshot(Long orderId, OrderFeeVO orderFeeVO,
// PriceResult priceResult,
// List<GiftCardVO> giftCards, long addressId) {
// try {
// if (priceResult != null) {
// List<PriceStep> steps = priceResult.getSteps();
// if (CollectionUtils.isNotEmpty(steps)) {
// // 保存活动价格商品
// this.saveOrderPriceProductBySteps(orderId, steps);
//
// List<OrderPrice> orderPrices = Lists.newArrayList();
//
// BigDecimal birth = BigDecimal.ZERO;
// BigDecimal memb = BigDecimal.ZERO;
// BigDecimal coupon = BigDecimal.ZERO;
// OrderPrice birthShot = new OrderPrice();
// OrderPrice memberShot = new OrderPrice();
// OrderPrice couponShot = new OrderPrice();
// Collection<OrderPrice> campaignShots = Lists.newArrayList();
//
// // 活动价格步骤合并及排序(生日折扣、会员折扣、优惠券合并)
// for (PriceStep step : steps) {
// BigDecimal savedPrice = step.getSavedPrice();
// if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
// if (step.getPriceType().equals(PriceType.MEMBER_LEVEL)) {
// memb = memb.add(savedPrice);
// memberShot = stepSwitchToShot(step, orderId, memb, "会员折扣");
// } else if (step.getPriceType().equals(PriceType.BIRTHDAY)) {
// birth = birth.add(savedPrice);
// birthShot = stepSwitchToShot(step, orderId, birth, "生日折扣");
// } else if (step.getPriceType().equals(PriceType.CAMPAIGN)) {
// OrderPrice campShot = stepSwitchCampaignToShot(step, orderId, savedPrice);
// campaignShots.add(campShot);
// } else if (step.getPriceType().equals(PriceType.COUPON)) {
// coupon = coupon.add(savedPrice);
// couponShot = stepSwitchToShot(step, orderId, coupon, "优惠券");
// }
// }
// }
// // 价格折扣排序
// int shotSort = 0;
// if (null != memberShot.getSavedPrice()) {
// shotSort++;
// memberShot.setSort(shotSort);
// orderPrices.add(memberShot);
// }
// if (null != birthShot.getSavedPrice()) {
// shotSort++;
// birthShot.setSort(shotSort);
// orderPrices.add(birthShot);
// }
// if (CollectionUtils.isNotEmpty(campaignShots)) {
// for (OrderPrice campaignShot : campaignShots) {
// shotSort++;
// campaignShot.setSort(shotSort);
// orderPrices.add(campaignShot);
// }
// }
// if (null != couponShot.getSavedPrice()) {
// shotSort++;
// couponShot.setSort(shotSort);
// orderPrices.add(couponShot);
// }
//
// List<ServiceFeeStep> postageSteps = orderFeeVO.getPostageSteps();
// if (CollectionUtils.isNotEmpty(postageSteps)) {
// for (ServiceFeeStep postageStep : postageSteps) {
// shotSort++;
// OrderPrice postageShot = new OrderPrice();
// postageShot.setType(postageStep.getPriceType());
// postageShot.setExtId(addressId);
// postageShot.setOrderId(orderId);
// postageShot.setSavedPrice(BigDecimal.ZERO.subtract(postageStep.getPrice()));
// postageShot.setSort(shotSort);
// postageShot.setCreateTime(new Date());
// postageShot.setNote(postageStep.getName());
// orderPrices.add(postageShot);
// }
// }
//
// List<ServiceFeeStep> overseasSteps = orderFeeVO.getOverseasSteps();
// if (CollectionUtils.isNotEmpty(overseasSteps)) {
// for (ServiceFeeStep overseasStep : overseasSteps) {
// shotSort++;
// OrderPrice overseasShot = new OrderPrice();
// overseasShot.setType(overseasStep.getPriceType());
// overseasShot.setExtId(addressId);
// overseasShot.setOrderId(orderId);
// overseasShot.setSavedPrice(BigDecimal.ZERO.subtract(overseasStep.getPrice()));
// overseasShot.setSort(shotSort);
// overseasShot.setCreateTime(new Date());
// overseasShot.setNote(overseasStep.getName());
// orderPrices.add(overseasShot);
// }
// }
//
// List<ServiceFeeStep> customizeSteps = orderFeeVO.getCustomizeSteps();
// if (CollectionUtils.isNotEmpty(customizeSteps)) {
// for (ServiceFeeStep customizeStep : customizeSteps) {
// shotSort++;
// OrderPrice customizeShot = new OrderPrice();
// customizeShot.setType(customizeStep.getPriceType());
// customizeShot.setExtId(addressId);
// customizeShot.setOrderId(orderId);
// customizeShot.setSavedPrice(BigDecimal.ZERO.subtract(customizeStep.getPrice()));
// customizeShot.setSort(shotSort);
// customizeShot.setCreateTime(new Date());
// customizeShot.setNote(customizeStep.getName());
// orderPrices.add(customizeShot);
// }
// }
//
// // 礼品卡拆分记录（展示时不展示详情）
// if (CollectionUtils.isNotEmpty(giftCards)) {
//
// for (GiftCardVO vo : giftCards) {
// shotSort++;
//
// OrderPrice cardShot = new OrderPrice();
// cardShot.setType(PriceType.GIFTCARD);
// cardShot.setExtId(Long.valueOf(vo.getCardNo()));
// cardShot.setOrderId(orderId);
// cardShot.setSavedPrice(vo.getAmount());
// cardShot.setSort(shotSort);
// cardShot.setCreateTime(new Date());
// cardShot.setNote("礼品卡");
// orderPrices.add(cardShot);
// }
// }
// orderPriceService.saveAllStep(orderPrices);
// }
// }
// } catch (Exception e) {
// logger.error("保存订单快照异常，e:{}", e);
// }
// }
//
// private OrderPrice stepSwitchToShot(PriceStep step, Long orderId, BigDecimal
// price, String note) {
// OrderPrice orderPrice = new OrderPrice();
// if (null != step) {
// orderPrice.setType(step.getPriceType());
// orderPrice.setExtId(step.getExtId());
// orderPrice.setOrderId(orderId);
// orderPrice.setSavedPrice(price);
// orderPrice.setCreateTime(new Date());
// orderPrice.setNote(note);
// }
// return orderPrice;
//
// }
//
// private OrderPrice stepSwitchCampaignToShot(PriceStep step, Long orderId,
// BigDecimal price) {
// OrderPrice orderPrice = new OrderPrice();
// if (null != step) {
// CampaignDetailVO campaign =
// campaignQueryService.getCampaignById(step.getExtId());
// orderPrice.setType(step.getPriceType());
// orderPrice.setExtId(step.getExtId());
// orderPrice.setOrderId(orderId);
// orderPrice.setSavedPrice(price);
// orderPrice.setCreateTime(new Date());
// Integer discountType = campaign.getDiscountType();
// orderPrice.setNote(DiscountTypeEnum.getEnumById(discountType).getName());
// }
// return orderPrice;
// }
//
// @Override
// public void savePSDOrderSnapshot(Long orderId, PsSpvVO spv) {
// try {
// saveSPDOrderPriceProduct(orderId, spv);
// List<OrderPrice> orderPrices = Lists.newArrayList();
//
// // 价格优惠
// int shotSort = 0;
// OrderPrice priceShot = new OrderPrice();
// priceShot.setType(PriceType.PSD);
// priceShot.setExtId(spv.getSpvId());
// priceShot.setOrderId(orderId);
// priceShot.setSavedPrice(spv.getSalesPrice());
// priceShot.setSort(shotSort);
// priceShot.setCreateTime(new Date());
// priceShot.setNote("浦发专享权益");
// orderPrices.add(priceShot);
//
// // 运费
// OrderPrice postageShot = new OrderPrice();
// shotSort++;
// postageShot.setType(PriceType.POSTAGE);
// postageShot.setExtId(spv.getSpvId());
// postageShot.setOrderId(orderId);
// postageShot.setSavedPrice(BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE));
// postageShot.setSort(shotSort);
// postageShot.setCreateTime(new Date());
// postageShot.setNote("运费");
// orderPrices.add(postageShot);
//
// // 运费减免
// OrderPrice postageSubtractShot = new OrderPrice();
// shotSort++;
// postageSubtractShot.setType(PriceType.POSTAGE);
// postageSubtractShot.setExtId(spv.getSpvId());
// postageSubtractShot.setOrderId(orderId);
// postageSubtractShot.setSavedPrice(PostageConstant.NORMAL_PRICE);
// postageSubtractShot.setSort(shotSort);
// postageSubtractShot.setCreateTime(new Date());
// postageSubtractShot.setNote("浦发专享权益免运费");
// orderPrices.add(postageSubtractShot);
//
// orderPriceService.saveAllStep(orderPrices);
// } catch (Exception e) {
// logger.error("保存订单快照异常，e:{}", e);
// }
// }
//
// /**
// * 保存订单活动商品快照
// *
// * @param orderId
// * @param spv
// */
// private void saveSPDOrderPriceProduct(Long orderId, PsSpvVO spv) {
// List<OrderPriceProduct> orderPriceProducts = Lists.newArrayList();
// if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
// OrderPriceProduct orderPriceProduct = new OrderPriceProduct();
// int sort = 0;
// orderPriceProduct.setOrderId(orderId);
// orderPriceProduct.setType(PriceType.PSD);
// orderPriceProduct.setExtId(spv.getSpvId());
// orderPriceProduct.setSpvId(spv.getSpvId());
// orderPriceProduct.setSpvPrice(spv.getSalesPrice());
// orderPriceProduct.setSavedPrice(spv.getSalesPrice());
// orderPriceProduct.setCount(1);
// orderPriceProduct.setSort(sort);
// orderPriceProduct.setCreateTime(new Date());
// orderPriceProducts.add(orderPriceProduct);
// }
// orderPriceProductService.save(orderPriceProducts);
// }
//
// @Override
// public void saveJBROrderSnapshot(Long orderId, PsSpvVO spv, BigDecimal price)
// {
// try {
// saveJBROrderPriceProduct(orderId, spv, price);
// List<OrderPrice> orderPrices = Lists.newArrayList();
//
// // 价格优惠
// int shotSort = 0;
// OrderPrice priceShot = new OrderPrice();
// priceShot.setType(PriceType.JBR);
// priceShot.setExtId(spv.getSpvId());
// priceShot.setOrderId(orderId);
// priceShot.setSavedPrice(spv.getSalesPrice().subtract(price));
// priceShot.setSort(shotSort);
// priceShot.setCreateTime(new Date());
// priceShot.setNote("集赞折扣");
// orderPrices.add(priceShot);
//
// // 运费
// OrderPrice postageShot = new OrderPrice();
// shotSort++;
// postageShot.setType(PriceType.POSTAGE);
// postageShot.setExtId(spv.getSpvId());
// postageShot.setOrderId(orderId);
// postageShot.setSavedPrice(BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE));
// postageShot.setSort(shotSort);
// postageShot.setCreateTime(new Date());
// postageShot.setNote("运费");
// orderPrices.add(postageShot);
//
// // 运费减免
//
// if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
//
// OrderPrice postageSubtractShot = new OrderPrice();
// shotSort++;
// postageSubtractShot.setType(PriceType.POSTAGE);
// postageSubtractShot.setExtId(spv.getSpvId());
// postageSubtractShot.setOrderId(orderId);
// postageSubtractShot.setSavedPrice(PostageConstant.NORMAL_PRICE);
// postageSubtractShot.setSort(shotSort);
// postageSubtractShot.setCreateTime(new Date());
// postageSubtractShot.setNote("实付99元免运费");
// orderPrices.add(postageSubtractShot);
//
// }
//
// orderPriceService.saveAllStep(orderPrices);
// } catch (Exception e) {
// logger.error("保存订单快照异常，e:{}", e);
// }
// }
//
// /**
// * 保存订单活动商品快照
// *
// * @param orderId
// * @param spv
// */
// private void saveJBROrderPriceProduct(Long orderId, PsSpvVO spv, BigDecimal
// price) {
// List<OrderPriceProduct> orderPriceProducts = Lists.newArrayList();
// if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
// OrderPriceProduct orderPriceProduct = new OrderPriceProduct();
// int sort = 0;
// orderPriceProduct.setOrderId(orderId);
// orderPriceProduct.setType(PriceType.JBR);
// orderPriceProduct.setExtId(spv.getSpvId());
// orderPriceProduct.setSpvId(spv.getSpvId());
// orderPriceProduct.setSpvPrice(spv.getSalesPrice());
// orderPriceProduct.setSavedPrice(spv.getSalesPrice().subtract(price));
// orderPriceProduct.setCount(1);
// orderPriceProduct.setSort(sort);
// orderPriceProduct.setCreateTime(new Date());
// orderPriceProducts.add(orderPriceProduct);
// }
// orderPriceProductService.save(orderPriceProducts);
// }
//
// @Override
// public void saveOrderSnapshotPrice(Long orderId, PrsPacksPriceResultVO
// priceResult, String desc) {
//
// try {
//
// List<PrsPriceStepVO> steps = priceResult.getPriceStepVOs();
// List<PrsSpvPriceStepVO> spvSteps = priceResult.getSpvPriceStepVOs();
// List<PrsSkuPriceStepVO> skuSteps = priceResult.getSkuPriceStepVOs();
//
// // 商品快照
// if (CollectionUtils.isNotEmpty(spvSteps)) {
// saveSpvOrderPrice(orderId, spvSteps, skuSteps);
// }
// // 订单快照
// if (CollectionUtils.isNotEmpty(steps)) {
// List<OrderPrice> orderPrices = Lists.newArrayList();
// int sort = 1;
// for (PrsPriceStepVO step : steps) {
// OrderPrice price = new OrderPrice();
// price.setCreateTime(new Date());
// price.setExtId(orderId);
// if (null != step.getExtId()) {
// price.setExtId(step.getExtId());
// }
// price.setNote(step.getStepDesc());
// if (step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)
// || step.getPriceType().equals(PrsPriceTypeEnum.BIRTHDAY)) {
//
// price.setNote(desc + step.getStepDesc());
// } else if (step.getPriceType().equals(PrsPriceTypeEnum.MEMBER_LEVEL)) {
// price.setNote(desc.substring(0, 2) + step.getStepDesc());
// }
// price.setOrderId(orderId);
// price.setSavedPrice(BigDecimal.ZERO);
// if (step.getPriceChange().compareTo(BigDecimal.ZERO) != 0) {
// price.setSavedPrice(BigDecimal.ZERO.subtract(step.getPriceChange()));
// }
// price.setSort(sort);
// price.setType(PriceType.getByCode(step.getPriceType().getCode()));
// sort++;
// orderPrices.add(price);
// }
// orderPriceService.saveAllStep(orderPrices);
//
// }
// } catch (Exception e) {
// logger.error("保存订单快照异常，e:{}", e);
// }
//
// }
//
// /**
// * 保存订单活动商品快照
// *
// * @param orderId
// * @param steps
// */
// private void saveSpvOrderPrice(Long orderId, List<PrsSpvPriceStepVO> steps,
// List<PrsSkuPriceStepVO> skuSteps) {
//
// List<OrderPriceProduct> orderPriceProducts = Lists.newArrayList();
// Integer sort = 1;
// Integer skuSort = 1;
// for (int i = 0; i < steps.size(); i++) {
// PrsSpvPriceStepVO step = steps.get(i);
//
// if (step.getExtId() == null) {
// step.setExtId(String.valueOf(orderId));
// }
//
// if (i > 0 && !steps.get(i).getExtId().equals(steps.get(i - 1).getExtId())) {
// sort++;
// }
// OrderPriceProduct orderPriceProduct = new OrderPriceProduct();
// orderPriceProduct.setOrderId(orderId);
// orderPriceProduct.setType(PriceType.getByCode(step.getPriceType().getCode()));
// orderPriceProduct.setExtId(Long.parseLong(step.getExtId()));
// orderPriceProduct.setSpvId(step.getSpvId());
// orderPriceProduct.setSavedPrice(step.getSpvSavedPrice());
// orderPriceProduct.setCount(step.getCount());
// orderPriceProduct.setSort(sort);
// orderPriceProduct.setCreateTime(new Date());
// orderPriceProduct.setSpvPrice(step.getSpvPrice());
// orderPriceProduct.setNote(step.getPriceType().getName());
// orderPriceProducts.add(orderPriceProduct);
//
// }
//
// orderPriceProductService.savePrice(orderPriceProducts);
// // 存sku
// List<OrderPriceSku> list = Lists.newArrayList();
// if (CollectionUtils.isNotEmpty(skuSteps))
// for (int j = 0; j < skuSteps.size(); j++) {
// PrsSkuPriceStepVO skuStep = skuSteps.get(j);
//
// if (skuStep.getExtId() == null) {
// skuStep.setExtId(String.valueOf(orderId));
// }
// if (j > 0 && !skuSteps.get(j).getExtId().equals(skuSteps.get(j -
// 1).getExtId())) {
// skuSort++;
// }
// OrderPriceSku priceSku = new OrderPriceSku();
// priceSku.setCount(skuStep.getCount());
// priceSku.setCreateTime(new Date());
// priceSku.setExtId(Long.parseLong(skuStep.getExtId()));
// priceSku.setNote(skuStep.getPriceType().getName());
// priceSku.setOrderId(orderId);
// priceSku.setSavedPrice(skuStep.getSkuSavedPrice());
//
// priceSku.setSkuCode(skuStep.getSkuCode());
// priceSku.setSkuPrice(skuStep.getSkuPrice());
// priceSku.setSort(skuSort);
// priceSku.setSpvId(skuStep.getSpvId());
// priceSku.setType(PriceType.getByCode(skuStep.getPriceType().getCode()));
// list.add(priceSku);
// }
// orderPriceSkuDao.create(list);
// }
//
// }
