/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.service.impl;

import com.thebeastshop.common.utils.CSVUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pegasus.channelservice.service.ChnserIdempotentOrderService;
import com.thebeastshop.pegasus.channelservice.service.KoudaiCronService;
import com.thebeastshop.pegasus.channelservice.util.KoudaiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Royan
 * @version $Id: KoudaiCronServiceImpl.java, v 0.1 2015-11-08 下午3:29
 */
@Service("koudaiCronService")
public class KoudaiCronServiceImpl implements KoudaiCronService {

    private final Logger                 logger              = LoggerFactory
                                                                 .getLogger(KoudaiCronServiceImpl.class);

    // 口袋渠道编码
    private static final String          CHANNEL_CODE_KOUDAI = "CHN2013";

    @Autowired
    private ChnserIdempotentOrderService chnserIdempotentOrderService;

    @Override
    public void processOrder() {
        File orderDir = new File(KoudaiProperties.getConfig("path.orderDir"));

        for (File orderFile : orderDir.listFiles(new FilenameFilter() {
            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("csv");
            }
        })) {
            String orderFileName = orderFile.getName();
            logger.info("process order file : " + orderFileName);

            try {
                List<List<String>> lines = CSVUtil.read(new FileInputStream(orderFile));

                // 错误记录：[行数,错误信息]
                List<List<String>> errors = new ArrayList<>();
                int i = 0;
                for (List<String> line : lines) {
                    i++;
                    try {
                        // 解析字段，mapping关系如下：
                        // [订单编号, 订单金额, 订单状态, 订单类型, 下单时间, 付款时间, 发货时间, 买家确认收货时间, 收件人姓名, 收件人手机, 商品编码, 购买数量, 商品价格, 省, 市, 区, 收货详细地址, 物流公司, 物流单号, 商品总件数, 订单描述, 优惠金额, 运费, 推广费, 订单优惠, 订单备注, 微信, 备注, 分销商店铺ID, 分销商注册姓名, 分销商手机号, 分成金额, 下单账号]
                        String orderStatus = line.get(2).trim();

                        // FIXME 是否只处理[已付款]状态
                        if ("已付款".equals(orderStatus)) {

                            // [订单头部分]
                            String outerOrderCode = line.get(0).trim(); // 口袋的订单号，入 pegasus 是外部订单号

                            // 判断幂等
                            if (!chnserIdempotentOrderService.check(CHANNEL_CODE_KOUDAI,
                                outerOrderCode)) {
                                logger.info("判断幂等失败，跳过：" + CHANNEL_CODE_KOUDAI + ","
                                            + outerOrderCode);
                                continue;
                            }

                            String totalAmount = line.get(1).trim();
                            String createTime = line.get(4).trim();
                            String payTime = line.get(5).trim();

                            // [包裹SKU部分]
                            String skuCodes = line.get(10).trim(); // 多个，半角分号(;)分隔
                            String skuQuanties = line.get(11).trim(); // 多个（跟 skuCodes 对应），半角分号(;)分隔
                            String unitPrices = line.get(12).trim(); // 多个（跟 skuCodes 对应），半角分号(;)分隔

                            // [包裹收货信息部分]
                            String receiver = line.get(8).trim();
                            String receiverPhone = line.get(9).trim();
                            String district = "中国-" + line.get(13).trim() + "-"
                                              + line.get(14).trim() + "-" + line.get(15).trim(); // 组装查询 DISTRICT_ID，跟系统是否一致？

                            String address = line.get(16).trim();

                            // TODO
                            // 调用创建订单[状态已付款待审单]，创建默认包裹[初始状态]，如有异常(如库存不足等)则catch作为[错误记录]处理
                            // 快递公司默认顺丰？@孙固

                        }
                    } catch (Exception e) {
                        // 增加[错误记录]
                        List<String> error = new ArrayList<>();
                        error.add(i + "");
                        error.add(e.getMessage());
                        errors.add(error);
                        logger.warn("", e);
                    }
                }

                // 错误记录不为空，则输出错误文件
                if (EmptyUtil.isNotEmpty(errors)) {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(
                            new File(orderDir + "/" + orderFileName + ".err"));
                        fos.write(CSVUtil.write(errors));
                        fos.flush();
                    } catch (IOException e) {
                        logger.warn("", e);
                    } finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            } catch (IOException e) {
                                logger.warn("", e);
                            }
                        }
                    }
                }

                // 删除文件
                orderFile.delete();

            } catch (FileNotFoundException e) {
                logger.warn("", e);
            }
        }
    }
}