package com.thebeastshop.pegasus.channelservice.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.pegasus.channelservice.service.ExchangeCartService;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.cart.RequestPack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author feilong.gao
 * @Date 2018/9/17 16:01.
 * @Description
 */
@Service
public class ExchangeCartServiceImpl implements ExchangeCartService {


    @Autowired
    private RedisClient redisClient;

    public String getShopCartKey(Long memberId){
        return "POINT_EXCHANGE:SHOP_CART:"+ memberId;
    }

    private Long getShopCartPackId(){
        return redisClient.incr("POINT_EXCHANGE:SHOP_CART:PACK_ID");
    }


    public List<RequestPack> getCart(Long memberId){

        List<RequestPack> packs = Lists.newArrayList();
        Map<Long,RequestPack> packMap = redisClient.getRedissonClient().getMap(getShopCartKey(memberId));
        if(packMap != null && !packMap.isEmpty()){
            packs.addAll(packMap.values());
        }
        return packs;
    }



    public List<Long> addPacks(Long memberId,List<RequestPack> packs){
        List<Long> packIds = Lists.newArrayList();
        List<RequestPack> oldPacks = this.getCart(memberId);
        for (RequestPack pack : packs) {
            Long packId = this.addPack(memberId,pack,oldPacks);
            packIds.add(packId);
        }
        return packIds;
    }


    private Long addPack(Long memberId,RequestPack pack,List<RequestPack> oldPacks){
        Long packId =0L;
        Boolean isNew = Boolean.TRUE;
        Integer count = pack.getCount();
        for (RequestPack oldPack : oldPacks) {
            if(oldPack.getSpvId().equals(pack.getSpvId())){
                isNew = Boolean.FALSE;
                packId = oldPack.getId();
                count += oldPack.getCount();
                break;
            }
        }
        if(isNew){
            packId = getShopCartPackId();
        }
        pack.setSource(CartPackSource.RAW);
        pack.setCount(count);
        pack.setId(packId);
        redisClient.getRedissonClient().getMap(getShopCartKey(memberId)).put(packId,pack);
        return packId;
    }




    private RequestPack getPack(Long memberId,Long packId){
        RequestPack requestPack = (RequestPack) redisClient.getRedissonClient().getMap(getShopCartKey(memberId)).get(packId);
        if(requestPack == null){
            return null;
        }
        return requestPack;
    }

    public List<RequestPack> getPacksByIds(Long memberId, List<Long> packIds){
        List<RequestPack> result = Lists.newArrayList();
        List<RequestPack> allPacks = this.getCart(memberId);
        for (RequestPack pack : allPacks) {
            if(packIds.contains(pack.getId())){
                result.add(pack);
            }
        }
        return result;
    }

    public List<RequestPack> modifyPacks(Long memberId,List<RequestPack> requestPacks){

        List<RequestPack> result = Lists.newArrayList();
        for (RequestPack requestPack : requestPacks) {
            result.add(this.modifyPack(memberId,requestPack));
        }
        return result;
    }

    private RequestPack modifyPack(Long memberId,RequestPack requestPack){

        RequestPack newPack = new RequestPack();
        newPack.setSource(CartPackSource.RAW);

        RequestPack old = getPack(memberId,requestPack.getId());
        if(old == null){
            newPack.setId(this.getShopCartPackId());
            newPack.setCount(1);
        }else{
            newPack.setId(old.getId());
            newPack.setSpvId(old.getSpvId());
            newPack.setCount(old.getCount());
        }

        if(!NumberUtil.isNullOrZero(requestPack.getSpvId())){
            newPack.setSpvId(requestPack.getSpvId());
        }

        if(!NumberUtil.isNullOrZero(requestPack.getCount())){
            newPack.setCount(requestPack.getCount());
        }
        redisClient.getRedissonClient().getMap(getShopCartKey(memberId)).put(newPack.getId(),newPack);

        return newPack;
    }


    public Boolean delPacks(Long memberId, List<Long> packsIds){
        for (Long packsId : packsIds) {
            redisClient.getRedissonClient().getMap(getShopCartKey(memberId)).fastRemove(packsId);
        }
        return Boolean.TRUE;
    }


    public Integer getPackSize(Long memberId){
        return getCart(memberId).size();
    }




}
