/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.channelservice.dao.ChnserIdempotentOrderMapper;
import com.thebeastshop.pegasus.channelservice.model.ChnserIdempotentOrder;
import com.thebeastshop.pegasus.channelservice.service.ChnserIdempotentOrderService;

/**
 * @author Royan
 * @version $Id: ChnserIdempotentOrderServiceImpl.java, v 0.1 2015-11-08 下午4:56
 */
@Service("chnserIdempotentOrderService")
public class ChnserIdempotentOrderServiceImpl implements ChnserIdempotentOrderService {

    private final Logger                logger = LoggerFactory
                                                   .getLogger(ChnserIdempotentOrderServiceImpl.class);

    @Autowired
    private ChnserIdempotentOrderMapper chnserIdempotentOrderMapper;

    /**
     * 检查幂等
     *
     * @param channelCode
     * @param outerOrderCode
     * @return
     */
    @Override
    public boolean check(String channelCode, String outerOrderCode) {
        ChnserIdempotentOrder chnserIdempotentOrder = new ChnserIdempotentOrder();
        chnserIdempotentOrder.setChannelCode(channelCode);
        chnserIdempotentOrder.setOuterOrderCode(outerOrderCode);
        try {
            chnserIdempotentOrderMapper.insert(chnserIdempotentOrder);
        } catch (Exception e) {
            logger.debug("", e);
            return false;
        }
        return true;
    }
}